/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.util.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.util.Base64Encoder;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.nio.charset.Charset;

public class Base64StringConverter
implements Converter {
    private static final Base64Encoder base64 = new Base64Encoder();

    public boolean canConvert(Class clazz) {
        return clazz.equals(String.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.addAttribute("encoding", "base64");
        writer.setValue(base64.encode(((String)value).getBytes(Charset.forName("UTF-8"))));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String encoding = reader.getAttribute("encoding");
        String data = reader.getValue();
        try {
            if ("base64".equalsIgnoreCase(encoding)) {
                return new String(base64.decode(data), Charset.forName("UTF-8"));
            }
            return data;
        }
        catch (Exception e) {
            return data;
        }
    }
}

