/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jms;

import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.connectors.jms.JmsConnectorPanel;
import com.mirth.connect.connectors.jms.JmsReceiverProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.text.Document;

public class JmsListener
extends ConnectorSettingsPanel {
    private JmsConnectorPanel jmsConnectorPanel;
    private MirthTextField reconnectIntervalField;
    private JLabel reconnectIntervalLabel;
    private MirthTextField selectorField;
    private JLabel selectorLabel;

    public JmsListener() {
        this.initComponents();
        this.jmsConnectorPanel.init(1, this.getConnectorName());
        this.reconnectIntervalField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
    }

    public String getConnectorName() {
        return new JmsReceiverProperties().getName();
    }

    public ConnectorProperties getProperties() {
        JmsReceiverProperties properties = (JmsReceiverProperties)this.jmsConnectorPanel.getProperties();
        properties.setSelector(this.selectorField.getText());
        properties.setReconnectIntervalMillis(this.reconnectIntervalField.getText());
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        this.jmsConnectorPanel.setProperties(properties);
        JmsReceiverProperties jmsReceiverProperties = (JmsReceiverProperties)properties;
        this.selectorField.setText(jmsReceiverProperties.getSelector());
        this.reconnectIntervalField.setText(jmsReceiverProperties.getReconnectIntervalMillis());
    }

    public ConnectorProperties getDefaults() {
        return new JmsReceiverProperties();
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        return this.jmsConnectorPanel.checkProperties(properties, highlight);
    }

    public void resetInvalidProperties() {
        this.jmsConnectorPanel.resetInvalidProperties();
    }

    private void initComponents() {
        this.selectorLabel = new JLabel();
        this.selectorField = new MirthTextField();
        this.jmsConnectorPanel = new JmsConnectorPanel();
        this.reconnectIntervalField = new MirthTextField();
        this.reconnectIntervalLabel = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.selectorLabel.setHorizontalAlignment(4);
        this.selectorLabel.setText("Selector:");
        this.selectorField.setToolTipText("<html>Enter a selector expression to select specific messages from the queue/topic.<br/>Leave blank to read all messages.</html>");
        this.reconnectIntervalField.setToolTipText("<html>The number of milliseconds between reconnect attempts when a connection error occurs.</html>");
        this.reconnectIntervalLabel.setText("Reconnect Interval (ms):");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)((Object)this.jmsConnectorPanel), -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.reconnectIntervalLabel).addComponent(this.selectorLabel, -2, 150, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.selectorField, -2, 400, -2).addComponent((Component)this.reconnectIntervalField, -2, 87, -2)).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)((Object)this.jmsConnectorPanel), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.reconnectIntervalField, -2, -1, -2).addComponent(this.reconnectIntervalLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.selectorField, -2, -1, -2).addComponent(this.selectorLabel))));
    }
}

