/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jms;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthSyntaxTextArea;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.connectors.jms.JmsConnectorPanel;
import com.mirth.connect.connectors.jms.JmsDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class JmsSender
extends ConnectorSettingsPanel {
    private JmsConnectorPanel jmsConnectorPanel;
    private JLabel templateLabel;
    private MirthSyntaxTextArea templateTextArea;

    public JmsSender() {
        this.initComponents();
        this.jmsConnectorPanel.init(2, this.getConnectorName());
    }

    public String getConnectorName() {
        return new JmsDispatcherProperties().getName();
    }

    public ConnectorProperties getProperties() {
        JmsDispatcherProperties properties = (JmsDispatcherProperties)this.jmsConnectorPanel.getProperties();
        properties.setTemplate(this.templateTextArea.getText());
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        this.jmsConnectorPanel.setProperties(properties);
        JmsDispatcherProperties jmsDispatcherProperties = (JmsDispatcherProperties)properties;
        this.templateTextArea.setText(jmsDispatcherProperties.getTemplate());
    }

    public ConnectorProperties getDefaults() {
        return new JmsDispatcherProperties();
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        boolean valid = this.jmsConnectorPanel.checkProperties(properties, highlight);
        JmsDispatcherProperties jmsDispatcherProperties = (JmsDispatcherProperties)properties;
        if (jmsDispatcherProperties.getTemplate().isEmpty()) {
            valid = false;
            if (highlight) {
                this.templateTextArea.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    public void resetInvalidProperties() {
        this.jmsConnectorPanel.resetInvalidProperties();
        this.templateTextArea.setBackground(null);
    }

    private void initComponents() {
        this.templateLabel = new JLabel();
        this.templateTextArea = new MirthSyntaxTextArea();
        this.jmsConnectorPanel = new JmsConnectorPanel();
        this.setBackground(new Color(255, 255, 255));
        this.templateLabel.setHorizontalAlignment(4);
        this.templateLabel.setText("Template:");
        this.templateTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.templateTextArea.setToolTipText("The JMS message content.");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)((Object)this.jmsConnectorPanel), -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.templateLabel, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.templateTextArea, -1, -1, Short.MAX_VALUE).addGap(50, 50, 50)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)((Object)this.jmsConnectorPanel), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.templateLabel).addContainerGap()).addComponent((Component)this.templateTextArea, -1, 125, Short.MAX_VALUE))));
    }
}

