/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core;

import com.mirth.commons.encryption.Encryptor;
import com.mirth.commons.encryption.KeyEncryptor;
import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.ServerConnection;
import com.mirth.connect.client.core.Version;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.InvocationHandlerRecorder;
import com.mirth.connect.client.core.api.providers.MetaDataSearchParamConverterProvider;
import com.mirth.connect.client.core.api.servlets.AlertServletInterface;
import com.mirth.connect.client.core.api.servlets.ChannelGroupServletInterface;
import com.mirth.connect.client.core.api.servlets.ChannelServletInterface;
import com.mirth.connect.client.core.api.servlets.ChannelStatisticsServletInterface;
import com.mirth.connect.client.core.api.servlets.ChannelStatusServletInterface;
import com.mirth.connect.client.core.api.servlets.CodeTemplateServletInterface;
import com.mirth.connect.client.core.api.servlets.ConfigurationServletInterface;
import com.mirth.connect.client.core.api.servlets.DatabaseTaskServletInterface;
import com.mirth.connect.client.core.api.servlets.EngineServletInterface;
import com.mirth.connect.client.core.api.servlets.EventServletInterface;
import com.mirth.connect.client.core.api.servlets.ExtensionServletInterface;
import com.mirth.connect.client.core.api.servlets.MessageServletInterface;
import com.mirth.connect.client.core.api.servlets.UsageServletInterface;
import com.mirth.connect.client.core.api.servlets.UserServletInterface;
import com.mirth.connect.client.core.api.util.OperationUtil;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.channel.Ports;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelDependency;
import com.mirth.connect.model.ChannelGroup;
import com.mirth.connect.model.ChannelHeader;
import com.mirth.connect.model.ChannelMetadata;
import com.mirth.connect.model.ChannelStatistics;
import com.mirth.connect.model.ChannelSummary;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.ConnectorMetaData;
import com.mirth.connect.model.DashboardChannelInfo;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.model.DatabaseTask;
import com.mirth.connect.model.DriverInfo;
import com.mirth.connect.model.EncryptionSettings;
import com.mirth.connect.model.LicenseInfo;
import com.mirth.connect.model.LoginStatus;
import com.mirth.connect.model.MessageImportResult;
import com.mirth.connect.model.MetaData;
import com.mirth.connect.model.PasswordRequirements;
import com.mirth.connect.model.PluginMetaData;
import com.mirth.connect.model.PublicServerSettings;
import com.mirth.connect.model.ResourceProperties;
import com.mirth.connect.model.ServerConfiguration;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.model.ServerSettings;
import com.mirth.connect.model.UpdateSettings;
import com.mirth.connect.model.User;
import com.mirth.connect.model.alert.AlertInfo;
import com.mirth.connect.model.alert.AlertModel;
import com.mirth.connect.model.alert.AlertStatus;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrarySaveResult;
import com.mirth.connect.model.codetemplates.CodeTemplateSummary;
import com.mirth.connect.model.filters.EventFilter;
import com.mirth.connect.model.filters.MessageFilter;
import com.mirth.connect.server.util.DebuggerUtil;
import com.mirth.connect.util.ConfigurationProperty;
import com.mirth.connect.util.ConnectionTestResponse;
import com.mirth.connect.util.MirthSSLUtil;
import com.mirth.connect.util.messagewriter.EncryptionType;
import com.mirth.connect.util.messagewriter.MessageWriterOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.Path;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.Provider;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class Client
implements UserServletInterface,
ConfigurationServletInterface,
ChannelServletInterface,
ChannelGroupServletInterface,
ChannelStatusServletInterface,
ChannelStatisticsServletInterface,
EngineServletInterface,
MessageServletInterface,
EventServletInterface,
AlertServletInterface,
CodeTemplateServletInterface,
DatabaseTaskServletInterface,
UsageServletInterface,
ExtensionServletInterface {
    public static final int MAX_QUERY_PARAM_COLLECTION_SIZE = 100;
    private Logger logger = LogManager.getLogger(this.getClass());
    private ServerConnection serverConnection;
    private javax.ws.rs.client.Client client;
    private URI api;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private InvocationHandlerRecorder recorder;

    public Client(String address) throws URISyntaxException {
        this(address, 0, MirthSSLUtil.DEFAULT_HTTPS_CLIENT_PROTOCOLS, MirthSSLUtil.DEFAULT_HTTPS_CIPHER_SUITES, null);
    }

    public Client(String address, String[] httpsProtocols, String[] httpsCipherSuites) throws URISyntaxException {
        this(address, 0, httpsProtocols, httpsCipherSuites, null);
    }

    public Client(String address, String[] httpsProtocols, String[] httpsCipherSuites, String[] apiProviderClasses) throws URISyntaxException {
        this(address, 0, httpsProtocols, httpsCipherSuites, apiProviderClasses);
    }

    public Client(String address, int timeout, String[] httpsProtocols, String[] httpsCipherSuites) throws URISyntaxException {
        this(address, timeout, httpsProtocols, httpsCipherSuites, null);
    }

    public Client(String address, int timeout, String[] httpsProtocols, String[] httpsCipherSuites, String[] apiProviderClasses) throws URISyntaxException {
        if (!((String)address).endsWith("/")) {
            address = (String)address + "/";
        }
        URI addressURI = new URI((String)address);
        this.serverConnection = new ServerConnection(timeout, httpsProtocols, httpsCipherSuites, StringUtils.equalsIgnoreCase((CharSequence)addressURI.getScheme(), (CharSequence)"http"));
        ClientConfig config = new ClientConfig().connectorProvider(new ConnectorProvider(){

            public Connector getConnector(javax.ws.rs.client.Client client, Configuration runtimeConfig) {
                return Client.this.serverConnection;
            }
        });
        for (Class providerClass : new Reflections("com.mirth.connect.client.core.api.providers", new Scanner[0]).getTypesAnnotatedWith(Provider.class)) {
            config.register(providerClass);
        }
        config.register(MultiPartFeature.class);
        Set servletClasses = new Reflections("com.mirth.connect.client.core.api.servlets", new Scanner[0]).getSubTypesOf(BaseServletInterface.class);
        for (Class servletClass : servletClasses) {
            config.register(servletClass);
        }
        if (ArrayUtils.isNotEmpty((Object[])apiProviderClasses)) {
            for (String apiProviderClass : apiProviderClasses) {
                try {
                    config.register(Class.forName(apiProviderClass));
                }
                catch (Throwable t) {
                    this.logger.error("Error registering API provider class: " + apiProviderClass);
                }
            }
        }
        this.client = ClientBuilder.newClient((Configuration)config);
        this.api = addressURI.resolve("api/" + Version.getLatest().toString());
    }

    public void registerApiProviders(Set<String> packageNames, Set<String> classes) {
        if (CollectionUtils.isNotEmpty(packageNames)) {
            for (String packageName : packageNames) {
                try {
                    for (Class clazz : new Reflections(packageName, new Scanner[0]).getTypesAnnotatedWith(Provider.class)) {
                        this.client.register(clazz);
                    }
                    for (Class clazz : new Reflections(packageName, new Scanner[0]).getTypesAnnotatedWith(Path.class)) {
                        this.client.register(clazz);
                    }
                }
                catch (Throwable t) {
                    this.logger.error("Error registering API provider package: " + packageName);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(classes)) {
            for (String clazz : classes) {
                try {
                    this.client.register(Class.forName(clazz));
                }
                catch (Throwable t) {
                    this.logger.error("Error registering API provider class: " + clazz);
                }
            }
        }
    }

    public <T> T getServlet(Class<T> servletInterface) {
        return this.getServlet(servletInterface, null);
    }

    public <T> T getServlet(Class<T> servletInterface, Operation.ExecuteType executeType) {
        return this.getServlet(servletInterface, executeType, null);
    }

    public <T> T getServlet(final Class<T> servletInterface, final Operation.ExecuteType executeType, final Map<String, List<String>> customHeaders) {
        return (T)Proxy.newProxyInstance((ClassLoader)AccessController.doPrivileged(ReflectionHelper.getClassLoaderPA(servletInterface)), new Class[]{servletInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws ClientException {
                try {
                    WebTarget target = Client.this.client.target(Client.this.api);
                    Operation operation = OperationUtil.getOperation(servletInterface, method);
                    if (operation != null) {
                        target.property("operation", (Object)operation);
                    }
                    if (executeType != null) {
                        target.property("executeType", (Object)executeType);
                    }
                    if (customHeaders != null) {
                        target.property("customHeaders", (Object)customHeaders);
                    }
                    if (args == null && method.getName().equals("toString")) {
                        return target.toString();
                    }
                    Object resource = WebResourceFactory.newResource(servletInterface, target);
                    Object result = method.invoke(resource, args);
                    if (Client.this.recorder != null) {
                        Client.this.recorder.recordInvocation(method, args, result, null);
                    }
                    if (result == null && method.getReturnType().isPrimitive()) {
                        return method.getReturnType() == Boolean.TYPE ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Byte.valueOf((byte)0);
                    }
                    return result;
                }
                catch (Throwable t) {
                    Throwable cause = t;
                    if (cause instanceof InvocationTargetException && cause.getCause() != null) {
                        cause = cause.getCause();
                    }
                    if (cause instanceof ProcessingException && cause.getCause() != null) {
                        cause = cause.getCause();
                    }
                    if (!(cause instanceof ClientException)) {
                        cause = new ClientException(cause);
                    }
                    if (Client.this.recorder != null) {
                        Client.this.recorder.recordInvocation(method, args, null, cause);
                    }
                    throw (ClientException)cause;
                }
            }
        });
    }

    public ServerConnection getServerConnection() {
        return this.serverConnection;
    }

    public void setRecorder(InvocationHandlerRecorder recorder) {
        this.recorder = recorder;
    }

    public void close() {
        this.closed.set(true);
        if (this.serverConnection != null) {
            this.serverConnection.shutdown();
            this.client.close();
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public synchronized LoginStatus login(String username, String password) throws ClientException {
        return this.getServlet(UserServletInterface.class).login(username, password);
    }

    @Override
    public synchronized void logout() throws ClientException {
        this.getServlet(UserServletInterface.class).logout();
    }

    @Override
    public synchronized void inactivityLogout() throws ClientException {
        this.getServlet(UserServletInterface.class).inactivityLogout();
    }

    @Override
    public synchronized void createUser(User user) throws ClientException {
        this.getServlet(UserServletInterface.class).createUser(user);
    }

    @Override
    public List<User> getAllUsers() throws ClientException {
        return this.getServlet(UserServletInterface.class).getAllUsers();
    }

    public User getUser(Integer userId) throws ClientException {
        return this.getUser(String.valueOf(userId));
    }

    @Override
    public User getUser(String userIdOrName) throws ClientException {
        return this.getServlet(UserServletInterface.class).getUser(userIdOrName);
    }

    @Override
    public User getCurrentUser() throws ClientException {
        return this.getServlet(UserServletInterface.class).getCurrentUser();
    }

    public synchronized void updateUser(User user) throws ClientException {
        this.updateUser(user.getId(), user);
    }

    @Override
    public synchronized void updateUser(Integer userId, User user) throws ClientException {
        this.getServlet(UserServletInterface.class).updateUser(user.getId(), user);
    }

    @Override
    public synchronized List<String> checkUserPassword(String plainPassword) throws ClientException {
        return this.getServlet(UserServletInterface.class).checkUserPassword(plainPassword);
    }

    @Override
    public synchronized List<String> updateUserPassword(Integer userId, String plainPassword) throws ClientException {
        return this.getServlet(UserServletInterface.class).updateUserPassword(userId, plainPassword);
    }

    @Override
    public synchronized void removeUser(Integer userId) throws ClientException {
        this.getServlet(UserServletInterface.class).removeUser(userId);
    }

    @Override
    public boolean isUserLoggedIn(Integer userId) throws ClientException {
        return this.getServlet(UserServletInterface.class).isUserLoggedIn(userId);
    }

    @Override
    public synchronized void setUserNotificationAcknowledged(Integer userId) throws ClientException {
        this.getServlet(UserServletInterface.class).setUserNotificationAcknowledged(userId);
    }

    @Override
    public Properties getUserPreferences(Integer userId, Set<String> names) throws ClientException {
        return this.getServlet(UserServletInterface.class).getUserPreferences(userId, names);
    }

    @Override
    public String getUserPreference(Integer userId, String name) throws ClientException {
        return this.getServlet(UserServletInterface.class).getUserPreference(userId, name);
    }

    @Override
    public void setUserPreferences(Integer userId, Properties properties) throws ClientException {
        this.getServlet(UserServletInterface.class).setUserPreferences(userId, properties);
    }

    @Override
    public void setUserPreference(Integer userId, String name, String value) throws ClientException {
        this.getServlet(UserServletInterface.class).setUserPreference(userId, name, value);
    }

    @Override
    public String getServerId() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getServerId();
    }

    @Override
    public String getVersion() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getVersion();
    }

    @Override
    public String getBuildDate() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getBuildDate();
    }

    @Override
    public synchronized int getStatus() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getStatus();
    }

    @Override
    public String getServerTimezone() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getServerTimezone();
    }

    @Override
    public Calendar getServerTime() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getServerTime();
    }

    @Override
    public String getJVMName() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getJVMName();
    }

    @Override
    public Map<String, Object> getAbout() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getAbout();
    }

    public ServerConfiguration getServerConfiguration() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getServerConfiguration(null, false, false);
    }

    @Override
    public ServerConfiguration getServerConfiguration(DeployedState initialState, boolean pollingOnly, boolean disableAlerts) throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getServerConfiguration(initialState, pollingOnly, disableAlerts);
    }

    @Override
    public synchronized void setServerConfiguration(ServerConfiguration serverConfiguration, boolean deploy, boolean overwriteConfigMap) throws ClientException {
        this.getServlet(ConfigurationServletInterface.class).setServerConfiguration(serverConfiguration, deploy, overwriteConfigMap);
    }

    @Override
    public List<String> getAvailableCharsetEncodings() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getAvailableCharsetEncodings();
    }

    @Override
    public ServerSettings getServerSettings() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getServerSettings();
    }

    @Override
    public synchronized void setServerSettings(ServerSettings settings) throws ClientException {
        this.getServlet(ConfigurationServletInterface.class).setServerSettings(settings);
    }

    @Override
    public PublicServerSettings getPublicServerSettings() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getPublicServerSettings();
    }

    public Encryptor getEncryptor() {
        KeyEncryptor encryptor = null;
        try {
            EncryptionSettings encryptionSettings = this.getEncryptionSettings();
            encryptor = new KeyEncryptor();
            encryptor.setProvider((java.security.Provider)Class.forName(encryptionSettings.getSecurityProvider()).newInstance());
            SecretKeySpec secretKey = new SecretKeySpec(encryptionSettings.getSecretKey(), encryptionSettings.getEncryptionBaseAlgorithm());
            encryptor.setKey((Key)secretKey);
            encryptor.setAlgorithm(encryptionSettings.getEncryptionAlgorithm());
            encryptor.setCharset(encryptionSettings.getEncryptionCharset());
            encryptor.setFallbackAlgorithm(encryptionSettings.getEncryptionFallbackAlgorithm());
            encryptor.setFallbackCharset(encryptionSettings.getEncryptionFallbackCharset());
        }
        catch (Exception e) {
            this.logger.error("Unable to load encryption settings.", (Throwable)e);
        }
        return encryptor;
    }

    public boolean isEncryptExport() {
        try {
            return this.getEncryptionSettings().getEncryptExport();
        }
        catch (Exception e) {
            this.logger.error("Unable to load encryption settings.", (Throwable)e);
            return false;
        }
    }

    @Override
    public EncryptionSettings getEncryptionSettings() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getEncryptionSettings();
    }

    @Override
    public synchronized ConnectionTestResponse sendTestEmail(Properties properties) throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).sendTestEmail(properties);
    }

    @Override
    public UpdateSettings getUpdateSettings() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getUpdateSettings();
    }

    @Override
    public synchronized void setUpdateSettings(UpdateSettings settings) throws ClientException {
        this.getServlet(ConfigurationServletInterface.class).setUpdateSettings(settings);
    }

    @Override
    public LicenseInfo getLicenseInfo() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getLicenseInfo();
    }

    @Override
    public String getGuid() throws ClientException {
        return UUID.randomUUID().toString();
    }

    @Override
    public Map<String, String> getGlobalScripts() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getGlobalScripts();
    }

    @Override
    public void setGlobalScripts(Map<String, String> scripts) throws ClientException {
        this.getServlet(ConfigurationServletInterface.class).setGlobalScripts(scripts);
    }

    @Override
    public Map<String, ConfigurationProperty> getConfigurationMap() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getConfigurationMap();
    }

    @Override
    public void setConfigurationMap(Map<String, ConfigurationProperty> map) throws ClientException {
        this.getServlet(ConfigurationServletInterface.class).setConfigurationMap(map);
    }

    @Override
    public List<DriverInfo> getDatabaseDrivers() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getDatabaseDrivers();
    }

    @Override
    public void setDatabaseDrivers(List<DriverInfo> drivers) throws ClientException {
        this.getServlet(ConfigurationServletInterface.class).setDatabaseDrivers(drivers);
    }

    @Override
    public PasswordRequirements getPasswordRequirements() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getPasswordRequirements();
    }

    @Override
    public List<ResourceProperties> getResources() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getResources();
    }

    @Override
    public void setResources(List<ResourceProperties> resources) throws ClientException {
        this.getServlet(ConfigurationServletInterface.class).setResources(resources);
    }

    @Override
    public void reloadResource(String resourceId) throws ClientException {
        this.getServlet(ConfigurationServletInterface.class).reloadResource(resourceId);
    }

    @Override
    public Set<ChannelDependency> getChannelDependencies() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getChannelDependencies();
    }

    @Override
    public void setChannelDependencies(Set<ChannelDependency> dependencies) throws ClientException {
        this.getServlet(ConfigurationServletInterface.class).setChannelDependencies(dependencies);
    }

    @Override
    public Map<String, ChannelMetadata> getChannelMetadata() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getChannelMetadata();
    }

    @Override
    public void setChannelMetadata(Map<String, ChannelMetadata> metadata) throws ClientException {
        this.getServlet(ConfigurationServletInterface.class).setChannelMetadata(metadata);
    }

    @Override
    public Map<String, String[]> getProtocolsAndCipherSuites() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getProtocolsAndCipherSuites();
    }

    @Override
    public Set<ChannelTag> getChannelTags() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getChannelTags();
    }

    @Override
    public void setChannelTags(Set<ChannelTag> channelTags) throws ClientException {
        this.getServlet(ConfigurationServletInterface.class).setChannelTags(channelTags);
    }

    @Override
    public int getRhinoLanguageVersion() throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getRhinoLanguageVersion();
    }

    @Override
    public synchronized boolean createChannel(Channel channel) throws ClientException {
        return this.getServlet(ChannelServletInterface.class).createChannel(channel);
    }

    public List<Channel> getAllChannels() throws ClientException {
        return this.getServlet(ChannelServletInterface.class).getChannels(null, false, false);
    }

    public List<Channel> getChannels(Set<String> channelIds) throws ClientException {
        return this.getServlet(ChannelServletInterface.class).getChannels(channelIds, false, false);
    }

    @Override
    public List<Channel> getChannels(Set<String> channelIds, boolean pollingOnly, boolean includeCodeTemplateLibraries) throws ClientException {
        if (CollectionUtils.size(channelIds) > 100) {
            return this.getChannelsPost(channelIds, pollingOnly, includeCodeTemplateLibraries);
        }
        return this.getServlet(ChannelServletInterface.class).getChannels(channelIds, pollingOnly, includeCodeTemplateLibraries);
    }

    @Override
    public List<Channel> getChannelsPost(Set<String> channelIds, boolean pollingOnly, boolean includeCodeTemplateLibraries) throws ClientException {
        return this.getServlet(ChannelServletInterface.class).getChannelsPost(channelIds, pollingOnly, includeCodeTemplateLibraries);
    }

    @Override
    public Channel getChannel(String channelId, boolean includeCodeTemplateLibraries) throws ClientException {
        return this.getServlet(ChannelServletInterface.class).getChannel(channelId, includeCodeTemplateLibraries);
    }

    @Override
    public Map<Integer, String> getConnectorNames(String channelId) throws ClientException {
        return this.getServlet(ChannelServletInterface.class).getConnectorNames(channelId);
    }

    @Override
    public List<MetaDataColumn> getMetaDataColumns(String channelId) throws ClientException {
        return this.getServlet(ChannelServletInterface.class).getMetaDataColumns(channelId);
    }

    @Override
    public Map<String, String> getChannelIdsAndNames() throws ClientException {
        return this.getServlet(ChannelServletInterface.class).getChannelIdsAndNames();
    }

    @Override
    public List<Ports> getChannelPortsInUse() throws ClientException {
        return this.getServlet(ChannelServletInterface.class).getChannelPortsInUse();
    }

    @Override
    public List<ChannelSummary> getChannelSummary(Map<String, ChannelHeader> cachedChannels, boolean ignoreNewChannels) throws ClientException {
        return this.getServlet(ChannelServletInterface.class).getChannelSummary(cachedChannels, ignoreNewChannels);
    }

    @Override
    public synchronized void setChannelEnabled(Set<String> channelIds, boolean enabled) throws ClientException {
        this.getServlet(ChannelServletInterface.class).setChannelEnabled(channelIds, enabled);
    }

    @Override
    public synchronized void setChannelEnabled(String channelId, boolean enabled) throws ClientException {
        this.getServlet(ChannelServletInterface.class).setChannelEnabled(channelId, enabled);
    }

    @Override
    public synchronized void setChannelInitialState(Set<String> channelIds, DeployedState initialState) throws ClientException {
        this.getServlet(ChannelServletInterface.class).setChannelInitialState(channelIds, initialState);
    }

    @Override
    public synchronized void setChannelInitialState(String channelId, DeployedState initialState) throws ClientException {
        this.getServlet(ChannelServletInterface.class).setChannelInitialState(channelId, initialState);
    }

    public synchronized boolean updateChannel(Channel channel, boolean override, Calendar dateStartEdit) throws ClientException {
        SimpleDateFormat sfd = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.getDefault());
        if (dateStartEdit == null) {
            dateStartEdit = Calendar.getInstance();
        }
        String startEdit = sfd.format(dateStartEdit.getTime());
        return this.updateChannel(channel.getId(), channel, override, startEdit);
    }

    @Override
    public synchronized boolean updateChannel(String channelId, Channel channel, boolean override, String startEdit) throws ClientException {
        return this.getServlet(ChannelServletInterface.class).updateChannel(channelId, channel, override, startEdit);
    }

    @Override
    public synchronized void removeChannel(String channelId) throws ClientException {
        this.getServlet(ChannelServletInterface.class).removeChannel(channelId);
    }

    @Override
    public synchronized void removeChannels(Set<String> channelIds) throws ClientException {
        if (CollectionUtils.size(channelIds) > 100) {
            this.removeChannelsPost(channelIds);
        } else {
            this.getServlet(ChannelServletInterface.class).removeChannels(channelIds);
        }
    }

    @Override
    public synchronized void removeChannelsPost(Set<String> channelIds) throws ClientException {
        this.getServlet(ChannelServletInterface.class).removeChannelsPost(channelIds);
    }

    public List<ChannelGroup> getAllChannelGroups() throws ClientException {
        return this.getServlet(ChannelGroupServletInterface.class).getChannelGroups(null);
    }

    @Override
    public List<ChannelGroup> getChannelGroups(Set<String> channelGroupIds) throws ClientException {
        if (CollectionUtils.size(channelGroupIds) > 100) {
            return this.getChannelGroupsPost(channelGroupIds);
        }
        return this.getServlet(ChannelGroupServletInterface.class).getChannelGroups(channelGroupIds);
    }

    @Override
    public List<ChannelGroup> getChannelGroupsPost(Set<String> channelGroupIds) throws ClientException {
        return this.getServlet(ChannelGroupServletInterface.class).getChannelGroupsPost(channelGroupIds);
    }

    @Override
    public boolean updateChannelGroups(Set<ChannelGroup> channelGroups, Set<String> removedChannelGroupIds, boolean override) throws ClientException {
        return this.getServlet(ChannelGroupServletInterface.class).updateChannelGroups(channelGroups, removedChannelGroupIds, override);
    }

    @Override
    public DashboardStatus getChannelStatus(String channelId) throws ClientException {
        return this.getServlet(ChannelStatusServletInterface.class).getChannelStatus(channelId);
    }

    public List<DashboardStatus> getAllChannelStatuses() throws ClientException {
        return this.getServlet(ChannelStatusServletInterface.class).getChannelStatusList(null, null, false);
    }

    @Override
    public DashboardChannelInfo getDashboardChannelInfo(int fetchSize, String filter) throws ClientException {
        return this.getServlet(ChannelStatusServletInterface.class).getDashboardChannelInfo(fetchSize, filter);
    }

    public List<DashboardStatus> getChannelStatusList(Set<String> channelIds, String filter) throws ClientException {
        return this.getServlet(ChannelStatusServletInterface.class).getChannelStatusList(channelIds, filter, false);
    }

    @Override
    public List<DashboardStatus> getChannelStatusList(Set<String> channelIds, String filter, boolean includeUndeployed) throws ClientException {
        if (CollectionUtils.size(channelIds) > 100) {
            return this.getChannelStatusListPost(channelIds, filter, includeUndeployed);
        }
        return this.getServlet(ChannelStatusServletInterface.class).getChannelStatusList(channelIds, filter, includeUndeployed);
    }

    @Override
    public List<DashboardStatus> getChannelStatusListPost(Set<String> channelIds, String filter, boolean includeUndeployed) throws ClientException {
        return this.getServlet(ChannelStatusServletInterface.class).getChannelStatusListPost(channelIds, filter, includeUndeployed);
    }

    public void startChannel(String channelId) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).startChannel(channelId, false);
    }

    @Override
    public void startChannel(String channelId, boolean returnErrors) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).startChannel(channelId, returnErrors);
    }

    public void startChannels(Set<String> channelIds) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).startChannels(channelIds, false);
    }

    @Override
    public void startChannels(Set<String> channelIds, boolean returnErrors) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).startChannels(channelIds, returnErrors);
    }

    public void stopChannel(String channelId) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).stopChannel(channelId, false);
    }

    @Override
    public void stopChannel(String channelId, boolean returnErrors) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).stopChannel(channelId, returnErrors);
    }

    public void stopChannels(Set<String> channelIds) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).stopChannels(channelIds, false);
    }

    @Override
    public void stopChannels(Set<String> channelIds, boolean returnErrors) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).stopChannels(channelIds, returnErrors);
    }

    public void haltChannel(String channelId) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).haltChannel(channelId, false);
    }

    @Override
    public void haltChannel(String channelId, boolean returnErrors) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).haltChannel(channelId, returnErrors);
    }

    public void haltChannels(Set<String> channelIds) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).haltChannels(channelIds, false);
    }

    @Override
    public void haltChannels(Set<String> channelIds, boolean returnErrors) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).haltChannels(channelIds, returnErrors);
    }

    public void pauseChannel(String channelId) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).pauseChannel(channelId, false);
    }

    @Override
    public void pauseChannel(String channelId, boolean returnErrors) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).pauseChannel(channelId, returnErrors);
    }

    public void pauseChannels(Set<String> channelIds) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).pauseChannels(channelIds, false);
    }

    @Override
    public void pauseChannels(Set<String> channelIds, boolean returnErrors) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).pauseChannels(channelIds, returnErrors);
    }

    public void resumeChannel(String channelId) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).resumeChannel(channelId, false);
    }

    @Override
    public void resumeChannel(String channelId, boolean returnErrors) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).resumeChannel(channelId, returnErrors);
    }

    public void resumeChannels(Set<String> channelIds) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).resumeChannels(channelIds, false);
    }

    @Override
    public void resumeChannels(Set<String> channelIds, boolean returnErrors) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).resumeChannels(channelIds, returnErrors);
    }

    public void startConnector(String channelId, Integer metaDataId) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).startConnector(channelId, metaDataId, false);
    }

    @Override
    public void startConnector(String channelId, Integer metaDataId, boolean returnErrors) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).startConnector(channelId, metaDataId, returnErrors);
    }

    public void startConnectors(Map<String, List<Integer>> connectorInfo) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).startConnectors(connectorInfo, false);
    }

    @Override
    public void startConnectors(Map<String, List<Integer>> connectorInfo, boolean returnErrors) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).startConnectors(connectorInfo, returnErrors);
    }

    public void stopConnector(String channelId, Integer metaDataId) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).stopConnector(channelId, metaDataId, false);
    }

    @Override
    public void stopConnector(String channelId, Integer metaDataId, boolean returnErrors) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).stopConnector(channelId, metaDataId, returnErrors);
    }

    public void stopConnectors(Map<String, List<Integer>> connectorInfo) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).stopConnectors(connectorInfo, false);
    }

    @Override
    public void stopConnectors(Map<String, List<Integer>> connectorInfo, boolean returnErrors) throws ClientException {
        this.getServlet(ChannelStatusServletInterface.class).stopConnectors(connectorInfo, returnErrors);
    }

    public List<ChannelStatistics> getStatistics() throws ClientException {
        return this.getServlet(ChannelStatisticsServletInterface.class).getStatistics(null, false, null, null, false);
    }

    public List<ChannelStatistics> getStatistics(boolean includeUndeployed) throws ClientException {
        return this.getServlet(ChannelStatisticsServletInterface.class).getStatistics(null, includeUndeployed, null, null, false);
    }

    public List<ChannelStatistics> getStatistics(boolean includeUndeployed, boolean aggregateStats) throws ClientException {
        return this.getServlet(ChannelStatisticsServletInterface.class).getStatistics(null, includeUndeployed, null, null, aggregateStats);
    }

    @Override
    public List<ChannelStatistics> getStatistics(Set<String> channelIds, boolean includeUndeployed, Set<Integer> includeMetadataIds, Set<Integer> excludeMetadataIds, boolean aggregateStats) throws ClientException {
        if (CollectionUtils.size(channelIds) > 100) {
            return this.getStatisticsPost(channelIds, includeUndeployed, includeMetadataIds, excludeMetadataIds, aggregateStats);
        }
        return this.getServlet(ChannelStatisticsServletInterface.class).getStatistics(channelIds, includeUndeployed, includeMetadataIds, excludeMetadataIds, aggregateStats);
    }

    @Override
    public List<ChannelStatistics> getStatisticsPost(Set<String> channelIds, boolean includeUndeployed, Set<Integer> includeMetadataIds, Set<Integer> excludeMetadataIds, boolean aggregateStats) throws ClientException {
        return this.getServlet(ChannelStatisticsServletInterface.class).getStatisticsPost(channelIds, includeUndeployed, includeMetadataIds, excludeMetadataIds, aggregateStats);
    }

    @Override
    public ChannelStatistics getStatistics(String channelId) throws ClientException {
        return this.getServlet(ChannelStatisticsServletInterface.class).getStatistics(channelId);
    }

    @Override
    public void clearStatistics(Map<String, List<Integer>> channelConnectorMap, boolean received, boolean filtered, boolean sent, boolean error) throws ClientException {
        this.getServlet(ChannelStatisticsServletInterface.class).clearStatistics(channelConnectorMap, received, filtered, sent, error);
    }

    @Override
    public void clearAllStatistics() throws ClientException {
        this.getServlet(ChannelStatisticsServletInterface.class).clearAllStatistics();
    }

    public void redeployAllChannels() throws ClientException {
        this.getServlet(EngineServletInterface.class).redeployAllChannels(false);
    }

    @Override
    public void redeployAllChannels(boolean returnErrors) throws ClientException {
        this.getServlet(EngineServletInterface.class).redeployAllChannels(returnErrors);
    }

    public void deployChannel(String channelId) throws ClientException {
        this.getServlet(EngineServletInterface.class).deployChannel(channelId, false, new String());
    }

    @Override
    public void deployChannel(String channelId, boolean returnErrors, String debug) throws ClientException {
        this.getServlet(EngineServletInterface.class).deployChannel(channelId, returnErrors, debug);
    }

    public void deployChannel(String channelId, boolean returnErrors, DebugOptions debugOptions) throws ClientException {
        String debug = DebuggerUtil.parseDebugOptions(debugOptions);
        this.getServlet(EngineServletInterface.class).deployChannel(channelId, returnErrors, debug);
    }

    public void deployChannels(Set<String> channelIds) throws ClientException {
        this.getServlet(EngineServletInterface.class).deployChannels(channelIds, false);
    }

    @Override
    public void deployChannels(Set<String> channelIds, boolean returnErrors) throws ClientException {
        this.getServlet(EngineServletInterface.class).deployChannels(channelIds, returnErrors);
    }

    public void undeployChannel(String channelId) throws ClientException {
        this.getServlet(EngineServletInterface.class).undeployChannel(channelId, false);
    }

    @Override
    public void undeployChannel(String channelId, boolean returnErrors) throws ClientException {
        this.getServlet(EngineServletInterface.class).undeployChannel(channelId, returnErrors);
    }

    public void undeployChannels(Set<String> channelIds) throws ClientException {
        this.getServlet(EngineServletInterface.class).undeployChannels(channelIds, false);
    }

    @Override
    public void undeployChannels(Set<String> channelIds, boolean returnErrors) throws ClientException {
        this.getServlet(EngineServletInterface.class).undeployChannels(channelIds, returnErrors);
    }

    public Long processMessage(String channelId, String rawMessage) throws ClientException {
        return this.processMessage(channelId, rawMessage, null, null, false, false, null);
    }

    @Override
    public Long processMessage(String channelId, String rawData, Set<Integer> destinationMetaDataIds, Set<String> sourceMapEntries, boolean overwrite, boolean imported, Long originalMessageId) throws ClientException {
        return this.getServlet(MessageServletInterface.class).processMessage(channelId, rawData, destinationMetaDataIds, sourceMapEntries, overwrite, imported, originalMessageId);
    }

    @Override
    public Long processMessage(String channelId, RawMessage rawMessage) throws ClientException {
        return this.getServlet(MessageServletInterface.class).processMessage(channelId, rawMessage);
    }

    @Override
    public Message getMessageContent(String channelId, Long messageId, List<Integer> metaDataIds) throws ClientException {
        return this.getServlet(MessageServletInterface.class).getMessageContent(channelId, messageId, metaDataIds);
    }

    public List<Attachment> getAttachmentsByMessageId(String channelId, Long messageId) throws ClientException {
        return this.getAttachmentsByMessageId(channelId, messageId, true);
    }

    @Override
    public List<Attachment> getAttachmentsByMessageId(String channelId, Long messageId, boolean includeContent) throws ClientException {
        return this.getServlet(MessageServletInterface.class).getAttachmentsByMessageId(channelId, messageId, includeContent);
    }

    @Override
    public Attachment getAttachment(String channelId, Long messageId, String attachmentId) throws ClientException {
        return this.getServlet(MessageServletInterface.class).getAttachment(channelId, messageId, attachmentId);
    }

    public String getDICOMMessage(ConnectorMessage message) throws ClientException {
        return this.getDICOMMessage(message.getChannelId(), message.getMessageId(), message);
    }

    @Override
    public String getDICOMMessage(String channelId, Long messageId, ConnectorMessage message) throws ClientException {
        return this.getServlet(MessageServletInterface.class).getDICOMMessage(channelId, messageId, message);
    }

    @Override
    public Long getMaxMessageId(String channelId) throws ClientException {
        return this.getServlet(MessageServletInterface.class).getMaxMessageId(channelId);
    }

    @Override
    public List<Message> getMessages(String channelId, MessageFilter filter, Boolean includeContent, Integer offset, Integer limit) throws ClientException {
        return this.getServlet(MessageServletInterface.class).getMessages(channelId, filter, includeContent, offset, limit);
    }

    @Override
    public List<Message> getMessages(String channelId, Long minMessageId, Long maxMessageId, Long minOriginalId, Long maxOriginalId, Long minImportId, Long maxImportId, Calendar startDate, Calendar endDate, String textSearch, Boolean textSearchRegex, Set<Status> statuses, Set<Integer> includedMetaDataIds, Set<Integer> excludedMetaDataIds, String serverId, Set<String> rawContentSearches, Set<String> processedRawContentSearches, Set<String> transformedContentSearches, Set<String> encodedContentSearches, Set<String> sentContentSearches, Set<String> responseContentSearches, Set<String> responseTransformedContentSearches, Set<String> processedResponseContentSearches, Set<String> connectorMapContentSearches, Set<String> channelMapContentSearches, Set<String> sourceMapContentSearches, Set<String> responseMapContentSearches, Set<String> processingErrorContentSearches, Set<String> postprocessorErrorContentSearches, Set<String> responseErrorContentSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataCaseInsensitiveSearches, Set<String> textSearchMetaDataColumns, Integer minSendAttempts, Integer maxSendAttempts, Boolean attachment, Boolean error, Boolean includeContent, Integer offset, Integer limit) throws ClientException {
        return this.getServlet(MessageServletInterface.class).getMessages(channelId, minMessageId, maxMessageId, minOriginalId, maxOriginalId, minImportId, maxImportId, startDate, endDate, textSearch, textSearchRegex, statuses, includedMetaDataIds, excludedMetaDataIds, serverId, rawContentSearches, processedRawContentSearches, transformedContentSearches, encodedContentSearches, sentContentSearches, responseContentSearches, responseTransformedContentSearches, processedResponseContentSearches, connectorMapContentSearches, channelMapContentSearches, sourceMapContentSearches, responseMapContentSearches, processingErrorContentSearches, postprocessorErrorContentSearches, responseErrorContentSearches, metaDataSearches, metaDataCaseInsensitiveSearches, textSearchMetaDataColumns, minSendAttempts, maxSendAttempts, attachment, error, includeContent, offset, limit);
    }

    @Override
    public Long getMessageCount(String channelId, MessageFilter filter) throws ClientException {
        return this.getServlet(MessageServletInterface.class).getMessageCount(channelId, filter);
    }

    @Override
    public Long getMessageCount(String channelId, Long minMessageId, Long maxMessageId, Long minOriginalId, Long maxOriginalId, Long minImportId, Long maxImportId, Calendar startDate, Calendar endDate, String textSearch, Boolean textSearchRegex, Set<Status> statuses, Set<Integer> includedMetaDataIds, Set<Integer> excludedMetaDataIds, String serverId, Set<String> rawContentSearches, Set<String> processedRawContentSearches, Set<String> transformedContentSearches, Set<String> encodedContentSearches, Set<String> sentContentSearches, Set<String> responseContentSearches, Set<String> responseTransformedContentSearches, Set<String> processedResponseContentSearches, Set<String> connectorMapContentSearches, Set<String> channelMapContentSearches, Set<String> sourceMapContentSearches, Set<String> responseMapContentSearches, Set<String> processingErrorContentSearches, Set<String> postprocessorErrorContentSearches, Set<String> responseErrorContentSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataCaseInsensitiveSearches, Set<String> textSearchMetaDataColumns, Integer minSendAttempts, Integer maxSendAttempts, Boolean attachment, Boolean error) throws ClientException {
        return this.getServlet(MessageServletInterface.class).getMessageCount(channelId, minMessageId, maxMessageId, minOriginalId, maxOriginalId, minImportId, maxImportId, startDate, endDate, textSearch, textSearchRegex, statuses, includedMetaDataIds, excludedMetaDataIds, serverId, rawContentSearches, processedRawContentSearches, transformedContentSearches, encodedContentSearches, sentContentSearches, responseContentSearches, responseTransformedContentSearches, processedResponseContentSearches, connectorMapContentSearches, channelMapContentSearches, sourceMapContentSearches, responseMapContentSearches, processingErrorContentSearches, postprocessorErrorContentSearches, responseErrorContentSearches, metaDataSearches, metaDataCaseInsensitiveSearches, textSearchMetaDataColumns, minSendAttempts, maxSendAttempts, attachment, error);
    }

    public void reprocessMessages(String channelId, MessageFilter filter, boolean replace, Collection<Integer> reprocessMetaDataIds) throws ClientException {
        HashSet<Integer> set = null;
        if (reprocessMetaDataIds != null) {
            set = new HashSet<Integer>(reprocessMetaDataIds);
        }
        this.reprocessMessages(channelId, filter, replace, reprocessMetaDataIds != null, set);
    }

    @Override
    public void reprocessMessages(String channelId, MessageFilter filter, boolean replace, boolean filterDestinations, Set<Integer> reprocessMetaDataIds) throws ClientException {
        this.getServlet(MessageServletInterface.class).reprocessMessages(channelId, filter, replace, filterDestinations, reprocessMetaDataIds);
    }

    @Override
    public void reprocessMessages(String channelId, Long minMessageId, Long maxMessageId, Long minOriginalId, Long maxOriginalId, Long minImportId, Long maxImportId, Calendar startDate, Calendar endDate, String textSearch, Boolean textSearchRegex, Set<Status> statuses, Set<Integer> includedMetaDataIds, Set<Integer> excludedMetaDataIds, String serverId, Set<String> rawContentSearches, Set<String> processedRawContentSearches, Set<String> transformedContentSearches, Set<String> encodedContentSearches, Set<String> sentContentSearches, Set<String> responseContentSearches, Set<String> responseTransformedContentSearches, Set<String> processedResponseContentSearches, Set<String> connectorMapContentSearches, Set<String> channelMapContentSearches, Set<String> sourceMapContentSearches, Set<String> responseMapContentSearches, Set<String> processingErrorContentSearches, Set<String> postprocessorErrorContentSearches, Set<String> responseErrorContentSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataCaseInsensitiveSearches, Set<String> textSearchMetaDataColumns, Integer minSendAttempts, Integer maxSendAttempts, Boolean attachment, Boolean error, boolean replace, boolean filterDestinations, Set<Integer> reprocessMetaDataIds) throws ClientException {
        this.getServlet(MessageServletInterface.class).reprocessMessages(channelId, minMessageId, maxMessageId, minOriginalId, maxOriginalId, minImportId, maxImportId, startDate, endDate, textSearch, textSearchRegex, statuses, includedMetaDataIds, excludedMetaDataIds, serverId, rawContentSearches, processedRawContentSearches, transformedContentSearches, encodedContentSearches, sentContentSearches, responseContentSearches, responseTransformedContentSearches, processedResponseContentSearches, connectorMapContentSearches, channelMapContentSearches, sourceMapContentSearches, responseMapContentSearches, processingErrorContentSearches, postprocessorErrorContentSearches, responseErrorContentSearches, metaDataSearches, metaDataCaseInsensitiveSearches, textSearchMetaDataColumns, minSendAttempts, maxSendAttempts, attachment, error, replace, filterDestinations, reprocessMetaDataIds);
    }

    public void reprocessMessage(String channelId, Long messageId, boolean replace, Collection<Integer> reprocessMetaDataIds) throws ClientException {
        HashSet<Integer> set = null;
        if (reprocessMetaDataIds != null) {
            set = new HashSet<Integer>(reprocessMetaDataIds);
        }
        this.getServlet(MessageServletInterface.class).reprocessMessage(channelId, messageId, replace, reprocessMetaDataIds != null, set);
    }

    @Override
    public void reprocessMessage(String channelId, Long messageId, boolean replace, boolean filterDestinations, Set<Integer> reprocessMetaDataIds) throws ClientException {
        this.getServlet(MessageServletInterface.class).reprocessMessage(channelId, messageId, replace, filterDestinations, reprocessMetaDataIds);
    }

    @Override
    public void removeMessages(String channelId, MessageFilter filter) throws ClientException {
        this.getServlet(MessageServletInterface.class).removeMessages(channelId, filter);
    }

    @Override
    public void removeMessages(String channelId, Long minMessageId, Long maxMessageId, Long minOriginalId, Long maxOriginalId, Long minImportId, Long maxImportId, Calendar startDate, Calendar endDate, String textSearch, Boolean textSearchRegex, Set<Status> statuses, Set<Integer> includedMetaDataIds, Set<Integer> excludedMetaDataIds, String serverId, Set<String> rawContentSearches, Set<String> processedRawContentSearches, Set<String> transformedContentSearches, Set<String> encodedContentSearches, Set<String> sentContentSearches, Set<String> responseContentSearches, Set<String> responseTransformedContentSearches, Set<String> processedResponseContentSearches, Set<String> connectorMapContentSearches, Set<String> channelMapContentSearches, Set<String> sourceMapContentSearches, Set<String> responseMapContentSearches, Set<String> processingErrorContentSearches, Set<String> postprocessorErrorContentSearches, Set<String> responseErrorContentSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataCaseInsensitiveSearches, Set<String> textSearchMetaDataColumns, Integer minSendAttempts, Integer maxSendAttempts, Boolean attachment, Boolean error) throws ClientException {
        this.getServlet(MessageServletInterface.class).removeMessages(channelId, minMessageId, maxMessageId, minOriginalId, maxOriginalId, minImportId, maxImportId, startDate, endDate, textSearch, textSearchRegex, statuses, includedMetaDataIds, excludedMetaDataIds, serverId, rawContentSearches, processedRawContentSearches, transformedContentSearches, encodedContentSearches, sentContentSearches, responseContentSearches, responseTransformedContentSearches, processedResponseContentSearches, connectorMapContentSearches, channelMapContentSearches, sourceMapContentSearches, responseMapContentSearches, processingErrorContentSearches, postprocessorErrorContentSearches, responseErrorContentSearches, metaDataSearches, metaDataCaseInsensitiveSearches, textSearchMetaDataColumns, minSendAttempts, maxSendAttempts, attachment, error);
    }

    @Override
    public void removeMessage(String channelId, Long messageId, Integer metaDataId, String patientId) throws ClientException {
        this.getServlet(MessageServletInterface.class).removeMessage(channelId, messageId, metaDataId, patientId);
    }

    @Override
    public void removeAllMessages(String channelId, boolean restartRunningChannels, boolean clearStatistics) throws ClientException {
        this.getServlet(MessageServletInterface.class).removeAllMessages(channelId, restartRunningChannels, clearStatistics);
    }

    @Override
    public void removeAllMessages(Set<String> channelIds, boolean restartRunningChannels, boolean clearStatistics) throws ClientException {
        if (CollectionUtils.size(channelIds) > 100) {
            this.removeAllMessagesPost(channelIds, restartRunningChannels, clearStatistics);
        } else {
            this.getServlet(MessageServletInterface.class).removeAllMessages(channelIds, restartRunningChannels, clearStatistics);
        }
    }

    @Override
    public void removeAllMessagesPost(Set<String> channelIds, boolean restartRunningChannels, boolean clearStatistics) throws ClientException {
        this.getServlet(MessageServletInterface.class).removeAllMessagesPost(channelIds, restartRunningChannels, clearStatistics);
    }

    @Override
    public void importMessage(String channelId, Message message) throws ClientException {
        this.getServlet(MessageServletInterface.class).importMessage(channelId, message);
    }

    @Override
    public MessageImportResult importMessagesServer(String channelId, String path, boolean includeSubfolders) throws ClientException {
        return this.getServlet(MessageServletInterface.class).importMessagesServer(channelId, path, includeSubfolders);
    }

    @Override
    public int exportMessagesServer(String channelId, MessageFilter filter, int pageSize, MessageWriterOptions writerOptions) throws ClientException {
        return this.getServlet(MessageServletInterface.class).exportMessagesServer(channelId, filter, pageSize, writerOptions);
    }

    @Override
    public int exportMessagesServer(String channelId, Long minMessageId, Long maxMessageId, Long minOriginalId, Long maxOriginalId, Long minImportId, Long maxImportId, Calendar startDate, Calendar endDate, String textSearch, Boolean textSearchRegex, Set<Status> statuses, Set<Integer> includedMetaDataIds, Set<Integer> excludedMetaDataIds, String serverId, Set<String> rawContentSearches, Set<String> processedRawContentSearches, Set<String> transformedContentSearches, Set<String> encodedContentSearches, Set<String> sentContentSearches, Set<String> responseContentSearches, Set<String> responseTransformedContentSearches, Set<String> processedResponseContentSearches, Set<String> connectorMapContentSearches, Set<String> channelMapContentSearches, Set<String> sourceMapContentSearches, Set<String> responseMapContentSearches, Set<String> processingErrorContentSearches, Set<String> postprocessorErrorContentSearches, Set<String> responseErrorContentSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataSearches, Set<MetaDataSearchParamConverterProvider.MetaDataSearch> metaDataCaseInsensitiveSearches, Set<String> textSearchMetaDataColumns, Integer minSendAttempts, Integer maxSendAttempts, Boolean attachment, Boolean error, int pageSize, ContentType contentType, boolean destinationContent, boolean encrypt, boolean includeAttachments, String baseFolder, String rootFolder, String filePattern, String archiveFileName, String archiveFormat, String compressFormat, String password, EncryptionType encryptionType) throws ClientException {
        return this.getServlet(MessageServletInterface.class).exportMessagesServer(channelId, minMessageId, maxMessageId, minOriginalId, maxOriginalId, minImportId, maxImportId, startDate, endDate, textSearch, textSearchRegex, statuses, includedMetaDataIds, excludedMetaDataIds, serverId, rawContentSearches, processedRawContentSearches, transformedContentSearches, encodedContentSearches, sentContentSearches, responseContentSearches, responseTransformedContentSearches, processedResponseContentSearches, connectorMapContentSearches, channelMapContentSearches, sourceMapContentSearches, responseMapContentSearches, processingErrorContentSearches, postprocessorErrorContentSearches, responseErrorContentSearches, metaDataSearches, metaDataCaseInsensitiveSearches, textSearchMetaDataColumns, minSendAttempts, maxSendAttempts, attachment, error, pageSize, contentType, destinationContent, encrypt, includeAttachments, baseFolder, rootFolder, filePattern, archiveFileName, archiveFormat, compressFormat, password, encryptionType);
    }

    @Override
    public void exportAttachmentServer(String channelId, Long messageId, String attachmentId, String filePath, boolean binary) throws ClientException {
        this.getServlet(MessageServletInterface.class).exportAttachmentServer(channelId, messageId, attachmentId, filePath, binary);
    }

    @Override
    public synchronized void auditAccessedPHIMessage(Map<String, String> auditMessageAttributesMap) throws ClientException {
        this.getServlet(MessageServletInterface.class).auditAccessedPHIMessage(auditMessageAttributesMap);
    }

    @Override
    public synchronized void auditQueriedPHIMessage(Map<String, String> auditMessageAttributesMap) throws ClientException {
        this.getServlet(MessageServletInterface.class).auditQueriedPHIMessage(auditMessageAttributesMap);
    }

    @Override
    public synchronized void auditExportMessages(Map<String, String> auditMessageAttributesMap) throws ClientException {
        this.getServlet(MessageServletInterface.class).auditExportMessages(auditMessageAttributesMap);
    }

    @Override
    public synchronized void auditExportMessagesSuccess(Map<String, String> auditMessageAttributesMap) throws ClientException {
        this.getServlet(MessageServletInterface.class).auditExportMessagesSuccess(auditMessageAttributesMap);
    }

    @Override
    public Integer getMaxEventId() throws ClientException {
        return this.getServlet(EventServletInterface.class).getMaxEventId();
    }

    @Override
    public ServerEvent getEvent(Integer eventId) throws ClientException {
        return this.getServlet(EventServletInterface.class).getEvent(eventId);
    }

    @Override
    public List<ServerEvent> getEvents(EventFilter filter, Integer offset, Integer limit) throws ClientException {
        return this.getServlet(EventServletInterface.class).getEvents(filter, offset, limit);
    }

    @Override
    public List<ServerEvent> getEvents(Integer maxEventId, Integer minEventId, Set<ServerEvent.Level> levels, Calendar startDate, Calendar endDate, String name, ServerEvent.Outcome outcome, Integer userId, String attributeSearch, String ipAddress, String serverId, Integer offset, Integer limit) throws ClientException {
        return this.getServlet(EventServletInterface.class).getEvents(maxEventId, minEventId, levels, startDate, endDate, name, outcome, userId, attributeSearch, ipAddress, serverId, offset, limit);
    }

    @Override
    public Long getEventCount(EventFilter filter) throws ClientException {
        return this.getServlet(EventServletInterface.class).getEventCount(filter);
    }

    @Override
    public Long getEventCount(Integer maxEventId, Integer minEventId, Set<ServerEvent.Level> levels, Calendar startDate, Calendar endDate, String name, ServerEvent.Outcome outcome, Integer userId, String attributeSearch, String ipAddress, String serverId) throws ClientException {
        return this.getServlet(EventServletInterface.class).getEventCount(maxEventId, minEventId, levels, startDate, endDate, name, outcome, userId, attributeSearch, ipAddress, serverId);
    }

    @Override
    public String exportAllEvents() throws ClientException {
        return this.getServlet(EventServletInterface.class).exportAllEvents();
    }

    @Override
    public void createAlert(AlertModel alertModel) throws ClientException {
        this.getServlet(AlertServletInterface.class).createAlert(alertModel);
    }

    @Override
    public AlertModel getAlert(String alertId) throws ClientException {
        return this.getServlet(AlertServletInterface.class).getAlert(alertId);
    }

    public List<AlertModel> getAllAlerts() throws ClientException {
        return this.getServlet(AlertServletInterface.class).getAlerts(null);
    }

    @Override
    public List<AlertModel> getAlerts(Set<String> alertIds) throws ClientException {
        if (CollectionUtils.size(alertIds) > 100) {
            return this.getAlertsPost(alertIds);
        }
        return this.getServlet(AlertServletInterface.class).getAlerts(alertIds);
    }

    @Override
    public List<AlertModel> getAlertsPost(Set<String> alertIds) throws ClientException {
        return this.getServlet(AlertServletInterface.class).getAlertsPost(alertIds);
    }

    @Override
    public List<AlertStatus> getAlertStatusList() throws ClientException {
        return this.getServlet(AlertServletInterface.class).getAlertStatusList();
    }

    @Override
    public AlertInfo getAlertInfo(String alertId, Map<String, ChannelHeader> cachedChannels) throws ClientException {
        return this.getServlet(AlertServletInterface.class).getAlertInfo(alertId, cachedChannels);
    }

    @Override
    public AlertInfo getAlertInfo(Map<String, ChannelHeader> cachedChannels) throws ClientException {
        return this.getServlet(AlertServletInterface.class).getAlertInfo(cachedChannels);
    }

    @Override
    public Map<String, Map<String, String>> getAlertProtocolOptions() throws ClientException {
        return this.getServlet(AlertServletInterface.class).getAlertProtocolOptions();
    }

    public synchronized void updateAlert(AlertModel alertModel) throws ClientException {
        this.getServlet(AlertServletInterface.class).updateAlert(alertModel.getId(), alertModel);
    }

    @Override
    public synchronized void updateAlert(String alertId, AlertModel alertModel) throws ClientException {
        this.getServlet(AlertServletInterface.class).updateAlert(alertId, alertModel);
    }

    @Override
    public synchronized void enableAlert(String alertId) throws ClientException {
        this.getServlet(AlertServletInterface.class).enableAlert(alertId);
    }

    @Override
    public synchronized void disableAlert(String alertId) throws ClientException {
        this.getServlet(AlertServletInterface.class).disableAlert(alertId);
    }

    @Override
    public synchronized void removeAlert(String alertId) throws ClientException {
        this.getServlet(AlertServletInterface.class).removeAlert(alertId);
    }

    public List<CodeTemplateLibrary> getAllCodeTemplateLibraries(boolean includeCodeTemplates) throws ClientException {
        return this.getServlet(CodeTemplateServletInterface.class).getCodeTemplateLibraries(null, includeCodeTemplates);
    }

    @Override
    public List<CodeTemplateLibrary> getCodeTemplateLibraries(Set<String> libraryIds, boolean includeCodeTemplates) throws ClientException {
        if (CollectionUtils.size(libraryIds) > 100) {
            return this.getCodeTemplateLibrariesPost(libraryIds, includeCodeTemplates);
        }
        return this.getServlet(CodeTemplateServletInterface.class).getCodeTemplateLibraries(libraryIds, includeCodeTemplates);
    }

    @Override
    public List<CodeTemplateLibrary> getCodeTemplateLibrariesPost(Set<String> libraryIds, boolean includeCodeTemplates) throws ClientException {
        return this.getServlet(CodeTemplateServletInterface.class).getCodeTemplateLibrariesPost(libraryIds, includeCodeTemplates);
    }

    @Override
    public CodeTemplateLibrary getCodeTemplateLibrary(String libraryId, boolean includeCodeTemplates) throws ClientException {
        return this.getServlet(CodeTemplateServletInterface.class).getCodeTemplateLibrary(libraryId, includeCodeTemplates);
    }

    @Override
    public synchronized boolean updateCodeTemplateLibraries(List<CodeTemplateLibrary> libraries, boolean override) throws ClientException {
        return this.getServlet(CodeTemplateServletInterface.class).updateCodeTemplateLibraries(libraries, override);
    }

    public List<CodeTemplate> getAllCodeTemplates() throws ClientException {
        return this.getServlet(CodeTemplateServletInterface.class).getCodeTemplates(null);
    }

    @Override
    public List<CodeTemplate> getCodeTemplates(Set<String> codeTemplateIds) throws ClientException {
        if (CollectionUtils.size(codeTemplateIds) > 100) {
            return this.getCodeTemplatesPost(codeTemplateIds);
        }
        return this.getServlet(CodeTemplateServletInterface.class).getCodeTemplates(codeTemplateIds);
    }

    @Override
    public List<CodeTemplate> getCodeTemplatesPost(Set<String> codeTemplateIds) throws ClientException {
        return this.getServlet(CodeTemplateServletInterface.class).getCodeTemplatesPost(codeTemplateIds);
    }

    @Override
    public CodeTemplate getCodeTemplate(String codeTemplateId) throws ClientException {
        return this.getServlet(CodeTemplateServletInterface.class).getCodeTemplate(codeTemplateId);
    }

    @Override
    public List<CodeTemplateSummary> getCodeTemplateSummary(Map<String, Integer> clientRevisions) throws ClientException {
        return this.getServlet(CodeTemplateServletInterface.class).getCodeTemplateSummary(clientRevisions);
    }

    public synchronized boolean updateCodeTemplate(CodeTemplate codeTemplate, boolean override) throws ClientException {
        return this.getServlet(CodeTemplateServletInterface.class).updateCodeTemplate(codeTemplate.getId(), codeTemplate, override);
    }

    @Override
    public synchronized boolean updateCodeTemplate(String codeTemplateId, CodeTemplate codeTemplate, boolean override) throws ClientException {
        return this.getServlet(CodeTemplateServletInterface.class).updateCodeTemplate(codeTemplateId, codeTemplate, override);
    }

    @Override
    public synchronized void removeCodeTemplate(String codeTemplateId) throws ClientException {
        this.getServlet(CodeTemplateServletInterface.class).removeCodeTemplate(codeTemplateId);
    }

    @Override
    public synchronized CodeTemplateLibrarySaveResult updateLibrariesAndTemplates(List<CodeTemplateLibrary> libraries, Set<String> removedLibraryIds, List<CodeTemplate> updatedCodeTemplates, Set<String> removedCodeTemplateIds, boolean override) throws ClientException {
        return this.getServlet(CodeTemplateServletInterface.class).updateLibrariesAndTemplates(libraries, removedLibraryIds, updatedCodeTemplates, removedCodeTemplateIds, override);
    }

    @Override
    public Map<String, DatabaseTask> getDatabaseTasks() throws ClientException {
        return this.getServlet(DatabaseTaskServletInterface.class).getDatabaseTasks();
    }

    @Override
    public DatabaseTask getDatabaseTask(String databaseTaskId) throws ClientException {
        return this.getServlet(DatabaseTaskServletInterface.class).getDatabaseTask(databaseTaskId);
    }

    @Override
    public String runDatabaseTask(String databaseTaskId) throws ClientException {
        return this.getServlet(DatabaseTaskServletInterface.class).runDatabaseTask(databaseTaskId);
    }

    @Override
    public void cancelDatabaseTask(String databaseTaskId) throws ClientException {
        this.getServlet(DatabaseTaskServletInterface.class).cancelDatabaseTask(databaseTaskId);
    }

    @Override
    public String getUsageData(Map<String, Object> clientStats) throws ClientException {
        return this.getServlet(UsageServletInterface.class).getUsageData(clientStats);
    }

    public void installExtension(File file) throws ClientException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            this.getServlet(ExtensionServletInterface.class).installExtension(inputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ClientException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    @Override
    public void installExtension(InputStream inputStream) throws ClientException {
        this.getServlet(ExtensionServletInterface.class).installExtension(inputStream);
    }

    @Override
    public void uninstallExtension(String extensionPath) throws ClientException {
        this.getServlet(ExtensionServletInterface.class).uninstallExtension(extensionPath);
    }

    @Override
    public MetaData getExtensionMetaData(String extensionName) throws ClientException {
        return this.getServlet(ExtensionServletInterface.class).getExtensionMetaData(extensionName);
    }

    @Override
    public Map<String, ConnectorMetaData> getConnectorMetaData() throws ClientException {
        return this.getServlet(ExtensionServletInterface.class).getConnectorMetaData();
    }

    @Override
    public Map<String, PluginMetaData> getPluginMetaData() throws ClientException {
        return this.getServlet(ExtensionServletInterface.class).getPluginMetaData();
    }

    @Override
    public boolean isExtensionEnabled(String extensionName) throws ClientException {
        return this.getServlet(ExtensionServletInterface.class).isExtensionEnabled(extensionName);
    }

    @Override
    public void setExtensionEnabled(String extensionName, boolean enabled) throws ClientException {
        this.getServlet(ExtensionServletInterface.class).setExtensionEnabled(extensionName, enabled);
    }

    public Properties getPluginProperties(String extensionName) throws ClientException {
        return this.getPluginProperties(extensionName, null);
    }

    @Override
    public Properties getPluginProperties(String extensionName, Set<String> propertyKeys) throws ClientException {
        return this.getServlet(ExtensionServletInterface.class).getPluginProperties(extensionName, propertyKeys);
    }

    public void setPluginProperties(String extensionName, Properties properties) throws ClientException {
        this.getServlet(ExtensionServletInterface.class).setPluginProperties(extensionName, properties, false);
    }

    @Override
    public void setPluginProperties(String extensionName, Properties properties, boolean mergeProperties) throws ClientException {
        this.getServlet(ExtensionServletInterface.class).setPluginProperties(extensionName, properties, mergeProperties);
    }

    @Override
    public String getProperty(String group, String name) throws ClientException {
        return this.getServlet(ConfigurationServletInterface.class).getProperty(group, name);
    }
}

