/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.model.ChannelHeader;
import com.mirth.connect.model.alert.AlertInfo;
import com.mirth.connect.model.alert.AlertModel;
import com.mirth.connect.model.alert.AlertStatus;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/alerts")
@Tag(name="Alerts")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface AlertServletInterface
extends BaseServletInterface {
    @POST
    @Path(value="/")
    @Operation(summary="Creates a new alert.")
    @MirthOperation(name="createAlert", display="Create alert", permission="manageAlerts")
    public void createAlert(@Param(value="alertModel") @RequestBody(description="The alert to create.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="alert", ref="../apiexamples/alert_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="alert", ref="../apiexamples/alert_json")})}) AlertModel var1) throws ClientException;

    @GET
    @Path(value="/{alertId}")
    @Operation(summary="Retrieves an alert by ID.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="alert", ref="../apiexamples/alert_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="alert", ref="../apiexamples/alert_json")})})
    @MirthOperation(name="getAlert", display="Get alerts", permission="viewAlerts")
    public AlertModel getAlert(@Param(value="alertId") @Parameter(description="The ID of the alert.", required=true) @PathParam(value="alertId") String var1) throws ClientException;

    @GET
    @Path(value="/")
    @Operation(summary="Retrieves multiple alerts by ID, or all alerts if not specified.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="alert_list", ref="../apiexamples/alert_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="alert_list", ref="../apiexamples/alert_list_json")})})
    @MirthOperation(name="getAlert", display="Get alerts", permission="viewAlerts")
    public List<AlertModel> getAlerts(@Param(value="alertIds") @Parameter(description="The ID of the alert(s). If absent, all alerts will be returned.") @QueryParam(value="alertId") Set<String> var1) throws ClientException;

    @POST
    @Path(value="/_getAlerts")
    @Operation(summary="Retrieves multiple alerts by ID, or all alerts if not specified. This is a POST request alternative to GET /alerts that may be used when there are too many alert IDs to include in the query parameters.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="alert_list", ref="../apiexamples/alert_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="alert_list", ref="../apiexamples/alert_list_json")})})
    @MirthOperation(name="getAlert", display="Get alerts", permission="viewAlerts")
    public List<AlertModel> getAlertsPost(@Param(value="alertIds") @RequestBody(description="The ID of the alert(s). If absent, all alerts will be returned.", content={@Content(mediaType="application/xml", examples={@ExampleObject(name="alert_set", ref="../apiexamples/guid_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="alert_set", ref="../apiexamples/guid_set_json")})}) Set<String> var1) throws ClientException;

    @GET
    @Path(value="/statuses")
    @Operation(summary="Returns all alert dashboard statuses.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="alert_status_list", ref="../apiexamples/alert_status_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="alert_status_list", ref="../apiexamples/alert_status_list_json")})})
    @MirthOperation(name="getAlertStatusList", display="Get alert status list", permission="viewAlerts", type=Operation.ExecuteType.ASYNC, auditable=false)
    public List<AlertStatus> getAlertStatusList() throws ClientException;

    @POST
    @Path(value="/{alertId}/_getInfo")
    @Operation(summary="Returns an AlertInfo object containing the alert model, alert protocol options, and any updated channel summaries.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="alert_info", ref="../apiexamples/alert_info_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="alert_info", ref="../apiexamples/alert_info_json")})})
    @MirthOperation(name="getAlertInfo", display="Get alert info", permission="viewAlerts", auditable=false)
    public AlertInfo getAlertInfo(@Param(value="alertId") @Parameter(description="The ID of the alert.", required=true) @PathParam(value="alertId") String var1, @Param(value="cachedChannels") @RequestBody(description="A map of ChannelHeader objects telling the server the state of the client-side channel cache.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channel_header_map", ref="../apiexamples/channel_header_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channel_header_map", ref="../apiexamples/channel_header_map_json")})}) Map<String, ChannelHeader> var2) throws ClientException;

    @POST
    @Path(value="/_getInfo")
    @Operation(summary="Returns an AlertInfo object containing alert protocol options and any updated channel summaries.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="alert_info", ref="../apiexamples/alert_info_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="alert_info", ref="../apiexamples/alert_info_json")})})
    @MirthOperation(name="getAlertInfo", display="Get alert info", permission="viewAlerts")
    public AlertInfo getAlertInfo(@Param(value="cachedChannels") @RequestBody(description="A map of ChannelHeader objects telling the server the state of the client-side channel cache.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channel_header_map", ref="../apiexamples/channel_header_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channel_header_map", ref="../apiexamples/channel_header_map_json")})}) Map<String, ChannelHeader> var1) throws ClientException;

    @GET
    @Path(value="/options")
    @Operation(summary="Returns all alert protocol options.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="alert_protocol_options", ref="../apiexamples/alert_protocol_options_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="alert_protocol_options", ref="../apiexamples/alert_protocol_options_json")})})
    @MirthOperation(name="getAlertProtocolOptions", display="Get alert protocol options", permission="viewAlerts", auditable=false)
    public Map<String, Map<String, String>> getAlertProtocolOptions() throws ClientException;

    @PUT
    @Path(value="/{alertId}")
    @Operation(summary="Updates the specified alert.")
    @MirthOperation(name="updateAlert", display="Update alert", permission="manageAlerts")
    public void updateAlert(@Param(value="alertId") @Parameter(description="The ID of the alert.", required=true) @PathParam(value="alertId") String var1, @Param(value="alertModel") @RequestBody(description="The alert to create.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="alert", ref="../apiexamples/alert_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="alert", ref="../apiexamples/alert_json")})}) AlertModel var2) throws ClientException;

    @POST
    @Path(value="/{alertId}/_enable")
    @Operation(summary="Enables the specified alert.")
    @MirthOperation(name="enableAlert", display="Enable alert", permission="manageAlerts")
    public void enableAlert(@Param(value="alertId") @Parameter(description="The ID of the alert.", required=true) @PathParam(value="alertId") String var1) throws ClientException;

    @POST
    @Path(value="/{alertId}/_disable")
    @Operation(summary="Disables the specified alert.")
    @MirthOperation(name="disableAlert", display="Disable alert", permission="manageAlerts")
    public void disableAlert(@Param(value="alertId") @Parameter(description="The ID of the alert.", required=true) @PathParam(value="alertId") String var1) throws ClientException;

    @DELETE
    @Path(value="/{alertId}")
    @Operation(summary="Removes the specified alert.")
    @MirthOperation(name="removeAlert", display="Remove alert", permission="manageAlerts")
    public void removeAlert(@Param(value="alertId") @Parameter(description="The ID of the alert.", required=true) @PathParam(value="alertId") String var1) throws ClientException;
}

