/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrarySaveResult;
import com.mirth.connect.model.codetemplates.CodeTemplateSummary;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/")
@Tag(name="Code Templates")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface CodeTemplateServletInterface
extends BaseServletInterface {
    @GET
    @Path(value="/codeTemplateLibraries")
    @Operation(summary="Retrieves multiple code template libraries by ID, or all libraries if not specified.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="code_template_library_list", ref="../apiexamples/code_template_library_list_xml"), @ExampleObject(name="code_template_library_list_full_templates", ref="../apiexamples/code_template_library_list_full_templates_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="code_template_library_list", ref="../apiexamples/code_template_library_list_json"), @ExampleObject(name="code_template_library_list_full_templates", ref="../apiexamples/code_template_library_list_full_templates_json")})})
    @MirthOperation(name="getCodeTemplateLibraries", display="Get code template libraries", permission="viewCodeTemplates", type=Operation.ExecuteType.ASYNC, auditable=false)
    public List<CodeTemplateLibrary> getCodeTemplateLibraries(@Param(value="libraryIds") @Parameter(description="The ID of the library(s) to retrieve.") @QueryParam(value="libraryId") Set<String> var1, @Param(value="includeCodeTemplates") @Parameter(description="If true, full code templates will be included inside each library.", schema=@Schema(defaultValue="false")) @QueryParam(value="includeCodeTemplates") boolean var2) throws ClientException;

    @POST
    @Path(value="/codeTemplateLibraries/_getCodeTemplateLibraries")
    @Operation(summary="Retrieves multiple code template libraries by ID, or all libraries if not specified. This is a POST request alternative to GET /codeTemplateLibraries that may be used when there are too many library IDs to include in the query parameters.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="code_template_library_list", ref="../apiexamples/code_template_library_list_xml"), @ExampleObject(name="code_template_library_list_full_templates", ref="../apiexamples/code_template_library_list_full_templates_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="code_template_library_list", ref="../apiexamples/code_template_library_list_json"), @ExampleObject(name="code_template_library_list_full_templates", ref="../apiexamples/code_template_library_list_full_templates_json")})})
    @MirthOperation(name="getCodeTemplateLibraries", display="Get code template libraries", permission="viewCodeTemplates", type=Operation.ExecuteType.ASYNC, auditable=false)
    public List<CodeTemplateLibrary> getCodeTemplateLibrariesPost(@Param(value="libraryIds") @RequestBody(description="The ID of the library(s) to retrieve.", content={@Content(mediaType="application/xml", examples={@ExampleObject(name="code_template_library_id_set", ref="../apiexamples/guid_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="code_template_library_id_set", ref="../apiexamples/guid_set_json")})}) Set<String> var1, @Param(value="includeCodeTemplates") @Parameter(description="If true, full code templates will be included inside each library.", schema=@Schema(defaultValue="false")) @QueryParam(value="includeCodeTemplates") boolean var2) throws ClientException;

    @GET
    @Path(value="/codeTemplateLibraries/{libraryId}")
    @Operation(summary="Retrieves a single code template library.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="code_template_library", ref="../apiexamples/code_template_library_xml"), @ExampleObject(name="code_template_library_full_templates", ref="../apiexamples/code_template_library_full_templates_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="code_template_library", ref="../apiexamples/code_template_library_json"), @ExampleObject(name="code_template_library_full_templates", ref="../apiexamples/code_template_library_full_templates_json")})})
    @MirthOperation(name="getCodeTemplateLibrary", display="Get code template library", permission="viewCodeTemplates", type=Operation.ExecuteType.ASYNC)
    public CodeTemplateLibrary getCodeTemplateLibrary(@Param(value="libraryId") @Parameter(description="The ID of the library to retrieve.") @PathParam(value="libraryId") String var1, @Param(value="includeCodeTemplates") @Parameter(description="If true, full code templates will be included inside each library.", schema=@Schema(defaultValue="false")) @QueryParam(value="includeCodeTemplates") boolean var2) throws ClientException;

    @PUT
    @Path(value="/codeTemplateLibraries")
    @Operation(summary="Replaces all code template libraries.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="libraries_replaced", ref="../apiexamples/boolean_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="libraries_replaced", ref="../apiexamples/boolean_json")})})
    @MirthOperation(name="updateCodeTemplateLibraries", display="Update code template libraries", permission="manageCodeTemplates")
    public boolean updateCodeTemplateLibraries(@Param(value="libraries") @RequestBody(description="The list of code template libraries to replace with.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="code_template_library_list_full_templates", ref="../apiexamples/code_template_library_list_full_templates_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="code_template_library_list_full_templates", ref="../apiexamples/code_template_library_list_full_templates_json")})}) List<CodeTemplateLibrary> var1, @Param(value="override") @Parameter(description="If true, the code template library will be updated even if a different revision exists on the server.", schema=@Schema(defaultValue="false")) @QueryParam(value="override") boolean var2) throws ClientException;

    @GET
    @Path(value="/codeTemplates")
    @Operation(summary="Retrieves multiple code templates by ID, or all templates if not specified.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="code_template_list", ref="../apiexamples/code_template_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="code_template_list", ref="../apiexamples/code_template_list_json")})})
    @MirthOperation(name="getCodeTemplates", display="Get code templates", permission="viewCodeTemplates")
    public List<CodeTemplate> getCodeTemplates(@Param(value="codeTemplateIds") @Parameter(description="The ID of the code template(s) to retrieve.") @QueryParam(value="codeTemplateId") Set<String> var1) throws ClientException;

    @POST
    @Path(value="/codeTemplates/_getCodeTemplates")
    @Operation(summary="Retrieves multiple code templates by ID, or all templates if not specified. This is a POST request alternative to GET /codeTemplates that may be used when there are too many code template IDs to include in the query parameters.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="code_template_list", ref="../apiexamples/code_template_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="code_template_list", ref="../apiexamples/code_template_list_json")})})
    @MirthOperation(name="getCodeTemplates", display="Get code templates", permission="viewCodeTemplates")
    public List<CodeTemplate> getCodeTemplatesPost(@Param(value="codeTemplateIds") @RequestBody(description="The ID of the code template(s) to retrieve.", content={@Content(mediaType="application/xml", examples={@ExampleObject(name="code_template_id_set", ref="../apiexamples/guid_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="code_template_id_set", ref="../apiexamples/guid_set_json")})}) Set<String> var1) throws ClientException;

    @GET
    @Path(value="/codeTemplates/{codeTemplateId}")
    @Operation(summary="Retrieves a single code template.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="code_template", ref="../apiexamples/code_template_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="code_template", ref="../apiexamples/code_template_json")})})
    @MirthOperation(name="getCodeTemplates", display="Get code templates", permission="viewCodeTemplates")
    public CodeTemplate getCodeTemplate(@Param(value="codeTemplateId") @Parameter(description="The ID of the code template to retrieve.") @PathParam(value="codeTemplateId") String var1) throws ClientException;

    @POST
    @Path(value="/codeTemplates/_getSummary")
    @Operation(summary="Returns a list of code template summaries, indicating to a client which code templates have changed. If a code template was modified, the entire CodeTemplate object will be returned.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="code_template_summary_list", ref="../apiexamples/code_template_summary_list_xml"), @ExampleObject(name="code_template_summary_list_revision_changed", ref="../apiexamples/code_template_summary_list_revision_changed_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="code_template_summary_list", ref="../apiexamples/code_template_summary_list_json"), @ExampleObject(name="code_template_summary_list_revision_changed", ref="../apiexamples/code_template_summary_list_revision_changed_json")})})
    @MirthOperation(name="getCodeTemplateSummary", display="Get code template summary", permission="viewCodeTemplates", type=Operation.ExecuteType.ASYNC, auditable=false)
    public List<CodeTemplateSummary> getCodeTemplateSummary(@Param(value="clientRevisions") @RequestBody(description="A map of revisions telling the server the state of the client-side code template cache.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="guid_to_int_map", ref="../apiexamples/guid_to_int_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="guid_to_int_map", ref="../apiexamples/guid_to_int_map_json")})}) Map<String, Integer> var1) throws ClientException;

    @PUT
    @Path(value="/codeTemplates/{codeTemplateId}")
    @Operation(summary="Updates a single code template.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="code_template_replaced", ref="../apiexamples/boolean_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="code_template_replaced", ref="../apiexamples/boolean_json")})})
    @MirthOperation(name="updateCodeTemplate", display="Update code template", permission="manageCodeTemplates")
    public boolean updateCodeTemplate(@Param(value="codeTemplateId") @Parameter(description="The ID of the code template.", required=true) @PathParam(value="codeTemplateId") String var1, @Param(value="codeTemplate") @RequestBody(description="The CodeTemplate object to update with.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="code_template", ref="../apiexamples/code_template_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="code_template", ref="../apiexamples/code_template_json")})}) CodeTemplate var2, @Param(value="override") @Parameter(description="If true, the code template will be updated even if a different revision exists on the server.", schema=@Schema(defaultValue="false")) @QueryParam(value="override") boolean var3) throws ClientException;

    @DELETE
    @Path(value="/codeTemplates/{codeTemplateId}")
    @Operation(summary="Removes a single code template.")
    @MirthOperation(name="removeCodeTemplate", display="Remove code template", permission="manageCodeTemplates")
    public void removeCodeTemplate(@Param(value="codeTemplateId") @Parameter(description="The ID of the code template.", required=true) @PathParam(value="codeTemplateId") String var1) throws ClientException;

    @POST
    @Path(value="/codeTemplateLibraries/_bulkUpdate")
    @Consumes(value={"multipart/form-data"})
    @Operation(summary="Updates all libraries and updates/removes selected code templates in one request. (\"Try it out\" doesn't work for this endpoint, but the descriptions are valid. Please use another tool for testing.)")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="code_template_library_saved_result", ref="../apiexamples/code_template_library_saved_result_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="code_template_library_saved_result", ref="../apiexamples/code_template_library_saved_result_json")})})
    @MirthOperation(name="updateCodeTemplatesAndLibraries", display="Update code templates and libraries", permission="manageCodeTemplates")
    public CodeTemplateLibrarySaveResult updateLibrariesAndTemplates(@Param(value="libraries") @Parameter(description="The set of code template libraries to replace with.", schema=@Schema(description="The set of code template libraries to replace with.")) @FormDataParam(value="libraries") List<CodeTemplateLibrary> var1, @Param(value="removedLibraryIds") @Parameter(description="All library IDs known to be removed.", schema=@Schema(description="All library IDs known to be removed.")) @FormDataParam(value="removedLibraryIds") Set<String> var2, @Param(value="updatedCodeTemplates") @Parameter(description="The set of code templates to update.", schema=@Schema(description="The set of code templates to update.")) @FormDataParam(value="updatedCodeTemplates") List<CodeTemplate> var3, @Param(value="removedCodeTemplateIds") @Parameter(description="All code template IDs known to be removed.", schema=@Schema(description="All code template IDs known to be removed.")) @FormDataParam(value="removedCodeTemplateIds") Set<String> var4, @Param(value="override") @Parameter(description="If true, the libraries and code templates will be updated even if different revisions exist on the server.", schema=@Schema(defaultValue="false")) @QueryParam(value="override") boolean var5) throws ClientException;
}

