/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.model.SystemInfo;
import com.mirth.connect.model.SystemStats;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/system")
@Tag(name="System Information and Statistics")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface SystemServletInterface
extends BaseServletInterface {
    @GET
    @Path(value="/info")
    @Operation(summary="Returns information about the underlying system.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="systemInfo", ref="../apiexamples/system_info_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="systemInfo", ref="../apiexamples/system_info_json")})})
    @MirthOperation(name="getJVMInfo", display="Get System Information", auditable=false)
    public SystemInfo getInfo() throws ClientException;

    @GET
    @Path(value="/stats")
    @Operation(summary="Returns statistics for the underlying system.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="systemStats", ref="../apiexamples/system_stats_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="systemStats", ref="../apiexamples/system_stats_json")})})
    @MirthOperation(name="getStats", display="Get System Statistics", auditable=false)
    public SystemStats getStats() throws ClientException;
}

