/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.alert;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.migration.Migratable;
import com.mirth.connect.donkey.util.purge.Purgable;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.alert.AlertActionGroup;
import com.mirth.connect.model.alert.AlertTrigger;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@XStreamAlias(value="alertModel")
public class AlertModel
implements Serializable,
Migratable,
Purgable {
    private String id = UUID.randomUUID().toString();
    private String name;
    private boolean enabled = false;
    private AlertTrigger trigger;
    private List<AlertActionGroup> actionGroups;
    private Map<String, Object> properties;

    public AlertModel(AlertTrigger trigger, AlertActionGroup actionGroup) {
        this.trigger = trigger;
        this.actionGroups = new ArrayList<AlertActionGroup>();
        this.actionGroups.add(actionGroup);
        this.properties = new HashMap<String, Object>();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public AlertTrigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(AlertTrigger trigger) {
        this.trigger = trigger;
    }

    public List<AlertActionGroup> getActionGroups() {
        return this.actionGroups;
    }

    public void setActionGroups(List<AlertActionGroup> actionGroups) {
        this.actionGroups = actionGroups;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append('[');
        builder.append("id=").append(this.id).append(", ");
        builder.append("name=").append(this.name).append(", ");
        builder.append("enabled=").append(this.enabled).append(", ");
        builder.append("trigger=").append(this.trigger).append(", ");
        builder.append("actionGroups=").append(this.actionGroups).append(", ");
        builder.append("properties=").append(this.properties).append(']');
        return builder.toString();
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("id", this.id);
        purgedProperties.put("nameChars", PurgeUtil.countChars((String)this.name));
        purgedProperties.put("enabled", this.enabled);
        if (this.trigger instanceof Purgable) {
            purgedProperties.put("trigger", ((Purgable)this.trigger).getPurgedProperties());
        }
        purgedProperties.put("actionGroups", PurgeUtil.purgeList(this.actionGroups));
        return purgedProperties;
    }
}

