/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.converters;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.migration.Migratable;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.mirth.connect.model.converters.MirthDomReader;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.util.MigrationUtil;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DocumentReader;
import com.thoughtworks.xstream.mapper.Mapper;
import org.w3c.dom.Element;

public class MigratableConverter
extends ReflectionConverter {
    private static final String DEFAULT_VERSION = "3.0.0";
    protected String currentVersion;

    public MigratableConverter(String currentVersion, Mapper mapper) {
        super(mapper, JVM.newReflectionProvider());
        this.currentVersion = currentVersion;
    }

    public boolean canConvert(Class type) {
        return type != null && super.canConvert(type) && Migratable.class.isAssignableFrom(type);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.addAttribute("version", this.currentVersion);
        super.marshal(value, writer, context);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String version = reader.getAttribute("version");
        if (version == null) {
            version = DEFAULT_VERSION;
        }
        if (MigrationUtil.compareVersions(version, this.currentVersion) < 0 && context.getRequiredType() != null) {
            if (reader.underlyingReader() instanceof DocumentReader) {
                this.migrateElement(new DonkeyElement((Element)((DocumentReader)reader.underlyingReader()).getCurrent()), version, context.getRequiredType());
            }
            if (reader.underlyingReader() instanceof MirthDomReader) {
                ((MirthDomReader)reader.underlyingReader()).reloadCurrentElement();
            }
        }
        return super.unmarshal(reader, context);
    }

    private void migrateElement(DonkeyElement element, String elementVersion, Class<?> clazz) {
        try {
            ReflectionProvider provider = ObjectXMLSerializer.getInstance().getXStream().getReflectionProvider();
            Migratable instance = (Migratable)provider.newInstance(clazz);
            if (MigrationUtil.compareVersions(elementVersion, "3.0.1") < 0) {
                instance.migrate3_0_1(element);
            }
            if (MigrationUtil.compareVersions(elementVersion, "3.0.2") < 0) {
                instance.migrate3_0_2(element);
            }
            if (MigrationUtil.compareVersions(elementVersion, "3.1.0") < 0) {
                instance.migrate3_1_0(element);
            }
            if (MigrationUtil.compareVersions(elementVersion, "3.2.0") < 0) {
                instance.migrate3_2_0(element);
            }
            if (MigrationUtil.compareVersions(elementVersion, "3.3.0") < 0) {
                instance.migrate3_3_0(element);
            }
            if (MigrationUtil.compareVersions(elementVersion, "3.4.0") < 0) {
                instance.migrate3_4_0(element);
            }
            if (MigrationUtil.compareVersions(elementVersion, "3.5.0") < 0) {
                instance.migrate3_5_0(element);
            }
            if (MigrationUtil.compareVersions(elementVersion, "3.6.0") < 0) {
                instance.migrate3_6_0(element);
            }
            if (MigrationUtil.compareVersions(elementVersion, "3.7.0") < 0) {
                instance.migrate3_7_0(element);
            }
            if (MigrationUtil.compareVersions(elementVersion, "3.9.0") < 0) {
                instance.migrate3_9_0(element);
            }
            if (MigrationUtil.compareVersions(elementVersion, "3.11.0") < 0) {
                instance.migrate3_11_0(element);
            }
            if (MigrationUtil.compareVersions(elementVersion, "3.11.1") < 0) {
                instance.migrate3_11_1(element);
            }
            if (MigrationUtil.compareVersions(elementVersion, "3.12.0") < 0) {
                instance.migrate3_12_0(element);
            }
            if (MigrationUtil.compareVersions(elementVersion, "4.4.0") < 0) {
                instance.migrate4_4_0(element);
            }
            if (MigrationUtil.compareVersions(elementVersion, "4.5.0") < 0) {
                instance.migrate4_5_0(element);
            }
            if (MigrationUtil.compareVersions(elementVersion, "4.6.0") < 0) {
                instance.migrate4_6_0(element);
            }
        }
        catch (Exception e) {
            throw new SerializerException("An error occurred while attempting to migrate serialized object element: " + element.getNodeName(), (Throwable)e);
        }
    }
}

