/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.transmission.batch;

import com.mirth.connect.donkey.server.message.batch.BatchStreamReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class DelimiterBatchStreamReader
extends BatchStreamReader {
    private byte[] delimiterBytes;
    private boolean includeDelimiter;

    public DelimiterBatchStreamReader(InputStream inputStream) {
        this(inputStream, new byte[0], false);
    }

    public DelimiterBatchStreamReader(InputStream inputStream, byte[] delimiterBytes, boolean includeDelimiter) {
        super((InputStream)new BufferedInputStream(inputStream, delimiterBytes.length));
        this.delimiterBytes = delimiterBytes;
        this.includeDelimiter = includeDelimiter;
    }

    public byte[] getDelimiterBytes() {
        return this.delimiterBytes;
    }

    public void setDelimiterBytes(byte[] delimiterBytes) {
        this.delimiterBytes = delimiterBytes;
    }

    public boolean isIncludeDelimiter() {
        return this.includeDelimiter;
    }

    public void setIncludeDelimiter(boolean includeDelimiter) {
        this.includeDelimiter = includeDelimiter;
    }

    public byte[] checkForIntermediateMessage(ByteArrayOutputStream capturedBytes, List<Byte> endBytesBuffer, int lastByte) throws IOException {
        this.inputStream.mark(this.delimiterBytes.length);
        boolean delimiterFound = true;
        for (byte delimiterByte : this.delimiterBytes) {
            if (this.inputStream.read() == delimiterByte) continue;
            delimiterFound = false;
            break;
        }
        if (delimiterFound) {
            for (Byte bufferByte : endBytesBuffer) {
                capturedBytes.write(bufferByte.byteValue());
            }
            if (this.includeDelimiter) {
                for (byte delimiterByte : this.delimiterBytes) {
                    capturedBytes.write(delimiterByte);
                }
            }
            return capturedBytes.toByteArray();
        }
        this.inputStream.reset();
        return null;
    }
}

