/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.util.MessageMaps;
import com.mirth.connect.util.MirthSSLUtil;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.cookie.DefaultCookieSpecProvider;
import org.apache.http.impl.cookie.IgnoreSpecProvider;
import org.apache.http.impl.cookie.NetscapeDraftSpecProvider;
import org.apache.http.impl.cookie.RFC6265CookieSpecProvider;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpUtil {
    private static Logger logger = LogManager.getLogger(HttpUtil.class);

    public static void configureClientBuilder(HttpClientBuilder clientBuilder) {
        PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.getDefault();
        clientBuilder.setPublicSuffixMatcher(publicSuffixMatcher);
        RegistryBuilder cookieSpecBuilder = RegistryBuilder.create();
        DefaultCookieSpecProvider defaultProvider = new DefaultCookieSpecProvider();
        RFC6265CookieSpecProvider laxStandardProvider = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.RELAXED, publicSuffixMatcher);
        RFC6265CookieSpecProvider strictStandardProvider = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.STRICT, publicSuffixMatcher);
        cookieSpecBuilder.register("default", (Object)defaultProvider);
        cookieSpecBuilder.register("best-match", (Object)defaultProvider);
        cookieSpecBuilder.register("compatibility", (Object)defaultProvider);
        cookieSpecBuilder.register("standard", (Object)laxStandardProvider);
        cookieSpecBuilder.register("standard-strict", (Object)strictStandardProvider);
        cookieSpecBuilder.register("netscape", (Object)new NetscapeDraftSpecProvider());
        cookieSpecBuilder.register("ignoreCookies", (Object)new IgnoreSpecProvider());
        clientBuilder.setDefaultCookieSpecRegistry((Lookup)cookieSpecBuilder.build());
    }

    public static void closeVeryQuietly(CloseableHttpResponse response) {
        try {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Map<String, List<String>> getTableMap(boolean useVariable, String mapVariable, Map<String, List<String>> tableMap, MessageMaps messageMaps, ConnectorMessage connectorMessage) {
        if (useVariable) {
            return HttpUtil.getTableMap(mapVariable, messageMaps, connectorMessage);
        }
        return tableMap;
    }

    public static Map<String, List<String>> getTableMap(String mapVariable, MessageMaps messageMaps, ConnectorMessage connectorMessage) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        try {
            Map source = (Map)messageMaps.get(mapVariable, connectorMessage);
            if (source != null) {
                for (Map.Entry entry : source.entrySet()) {
                    try {
                        String key = String.valueOf(entry.getKey());
                        Object value = entry.getValue();
                        if (value instanceof List) {
                            ArrayList<String> validListEntries = new ArrayList<String>();
                            for (Object listEntry : (List)value) {
                                validListEntries.add(String.valueOf(listEntry));
                            }
                            if (validListEntries.size() > 0) {
                                map.put(key, validListEntries);
                                continue;
                            }
                            logger.trace("No values found for '" + key + "' from map '" + mapVariable + "'. Skipping.");
                            continue;
                        }
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(String.valueOf(value));
                        map.put(key, list);
                    }
                    catch (Exception e) {
                        logger.trace("Error getting map entry '" + entry.getKey().toString() + "' from map '" + mapVariable + "'. Skipping entry.", (Throwable)e);
                    }
                }
            } else {
                logger.warn("Map variable '" + mapVariable + "' not found.");
            }
        }
        catch (Exception e) {
            logger.warn("Error getting values from map '" + mapVariable + "'.", (Throwable)e);
        }
        return map;
    }

    public static String executeGetRequest(String url, int timeout, boolean hostnameVerification, String[] protocols, String[] cipherSuites) {
        return HttpUtil.executeGetRequest(url, timeout, hostnameVerification, protocols, cipherSuites, SSLContexts.createSystemDefault());
    }

    public static String executeGetRequest(String url, int timeout, boolean hostnameVerification, String[] protocols, String[] cipherSuites, SSLContext sslContext) {
        try {
            return HttpUtil.doExecuteGetRequest(url, timeout, hostnameVerification, protocols, cipherSuites, sslContext);
        }
        catch (Throwable t) {
            logger.error("Error executing GET request at URL " + url, t);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String doExecuteGetRequest(String url, int timeout, boolean hostnameVerification, String[] protocols, String[] cipherSuites, SSLContext sslContext) throws Exception {
        String string;
        block6: {
            CloseableHttpClient client = null;
            CloseableHttpResponse response = null;
            try {
                client = HttpUtil.getHttpClient(timeout, hostnameVerification, protocols, cipherSuites, sslContext);
                HttpGet get = new HttpGet(url);
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
                HttpClientContext getContext = HttpClientContext.create();
                getContext.setRequestConfig(requestConfig);
                response = client.execute((HttpUriRequest)get, (HttpContext)getContext);
                StatusLine statusLine = response.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                if (statusCode != 200) {
                    throw new Exception(statusLine.toString());
                }
                HttpEntity responseEntity = response.getEntity();
                Charset responseCharset = null;
                try {
                    responseCharset = ContentType.getOrDefault((HttpEntity)responseEntity).getCharset();
                }
                catch (Exception e) {
                    responseCharset = ContentType.TEXT_PLAIN.getCharset();
                }
                string = IOUtils.toString((InputStream)responseEntity.getContent(), (Charset)responseCharset).trim();
                if (client == null) break block6;
            }
            catch (Throwable throwable) {
                if (client != null) {
                    HttpClientUtils.closeQuietly(response);
                    HttpClientUtils.closeQuietly((HttpClient)client);
                }
                throw throwable;
            }
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            HttpClientUtils.closeQuietly((HttpClient)client);
        }
        return string;
    }

    public static CloseableHttpClient getHttpClient(int timeout, boolean hostnameVerification, String[] protocols, String[] cipherSuites, SSLContext sslContext) {
        NoopHostnameVerifier hostnameVerifier = hostnameVerification ? new DefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE;
        RegistryBuilder socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        String[] enabledProtocols = MirthSSLUtil.getEnabledHttpsProtocols(protocols);
        String[] enabledCipherSuites = MirthSSLUtil.getEnabledHttpsCipherSuites(cipherSuites);
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, enabledProtocols, enabledCipherSuites, (HostnameVerifier)hostnameVerifier);
        socketFactoryRegistry.register("https", (Object)sslConnectionSocketFactory);
        BasicHttpClientConnectionManager httpClientConnectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry.build());
        httpClientConnectionManager.setSocketConfig(SocketConfig.custom().setSoTimeout(timeout).build());
        HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager);
        HttpUtil.configureClientBuilder(clientBuilder);
        return clientBuilder.build();
    }
}

