/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import java.util.ArrayList;
import java.util.List;

public abstract class PaginatedList<T>
extends ArrayList<T> {
    private static final int DEFAULT_PAGE_SIZE = 100;
    private int pageSize = 0;
    private int pageNumber = 1;
    private boolean hasNextPage = false;

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize <= 0 ? 100 : pageSize;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageCount() {
        Long totalSize = this.getItemCount();
        if (totalSize != null) {
            return (int)Math.ceil((double)totalSize.longValue() / (double)this.pageSize);
        }
        return null;
    }

    public int getOffset(int pageNumber) {
        return this.pageSize * (pageNumber - 1);
    }

    public boolean loadPageNumber(int pageNumber) throws Exception {
        List<T> items;
        this.clear();
        this.hasNextPage = false;
        if (this.pageSize > 0 && (items = this.getItems(this.getOffset(pageNumber), this.pageSize + 1)) != null && !items.isEmpty()) {
            if (items.size() > this.pageSize) {
                this.hasNextPage = true;
            }
            for (int i = 0; i < Math.min(items.size(), this.pageSize); ++i) {
                this.add(items.get(i));
            }
            this.pageNumber = pageNumber;
            return true;
        }
        return false;
    }

    public boolean hasNextPage() {
        return this.hasNextPage;
    }

    public abstract Long getItemCount();

    protected abstract List<T> getItems(int var1, int var2) throws Exception;
}

