/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.MirthDim;
import org.mozilla.javascript.tools.debugger.MirthSwingGui;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.mozilla.javascript.tools.shell.Global;

public class MirthMain
extends Main {
    private static Map<String, MirthMain> mainInstanceMap = new ConcurrentHashMap<String, MirthMain>();

    public MirthMain(String title) {
        super(title);
        this.dim = new MirthDim();
        this.debugGui = new MirthSwingGui(this, this.dim, title);
    }

    private static MirthMain createInstance(String title, ContextFactory factory, Object scopeProvider, String scriptId) {
        MirthMain workingMain = null;
        String key = scriptId != null ? scriptId : title;
        workingMain = mainInstanceMap.get(key);
        if (workingMain != null) {
            if (workingMain.dim == null) {
                workingMain.dim = new MirthDim();
            }
            return workingMain;
        }
        workingMain = new MirthMain(key);
        workingMain.doBreak();
        workingMain.attachTo(factory);
        if (scopeProvider instanceof ScopeProvider) {
            workingMain.setScopeProvider((ScopeProvider)scopeProvider);
        } else {
            Scriptable scope = (Scriptable)scopeProvider;
            if (scope instanceof Global) {
                Global global = (Global)scope;
                global.setIn(workingMain.getIn());
                global.setOut(workingMain.getOut());
                global.setErr(workingMain.getErr());
            }
            workingMain.setScope(scope);
        }
        mainInstanceMap.put(key, workingMain);
        return workingMain;
    }

    public static MirthMain mirthMainEmbedded(ContextFactory factory, Object scopeProvider, String title, String scriptId, boolean showWindow) {
        if (title == null) {
            title = "Rhino JavaScript Debugger (embedded usage)";
        }
        MirthMain embeddedMain = MirthMain.createInstance(title, factory, scopeProvider, scriptId);
        embeddedMain.pack();
        embeddedMain.setSize(600, 460);
        embeddedMain.setVisible(showWindow);
        return embeddedMain;
    }

    public static MirthMain mirthMainEmbedded(ContextFactory factory, Object scopeProvider, String title, String scriptId) {
        return MirthMain.mirthMainEmbedded(factory, scopeProvider, title, scriptId, true);
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag) {
            if (this.debugGui != null) {
                MirthSwingGui mirthDebugGui = (MirthSwingGui)this.debugGui;
                mirthDebugGui.setStopping(!flag);
            }
            if (this.dim != null) {
                ((MirthDim)this.dim).setStopping(!flag);
            }
        }
        super.setVisible(flag);
    }

    @Override
    public void dispose() {
        this.finishScriptExecution();
        if (this.dim != null) {
            this.detach();
        }
        this.removeFromMap();
        if (this.debugGui != null) {
            this.debugGui.dispose();
        }
        this.dim = null;
    }

    public void finishScriptExecution() {
        if (this.debugGui != null) {
            ((MirthSwingGui)this.debugGui).setStopping(true);
        }
        if (this.dim != null) {
            ((MirthDim)this.dim).setStopping(true);
            this.dim.clearAllBreakpoints();
            this.dim.go();
        }
    }

    public void enableDebugging() {
        this.doBreak();
        if (this.debugGui != null) {
            ((MirthSwingGui)this.debugGui).setStopping(false);
        }
        if (this.dim != null) {
            ((MirthDim)this.dim).setStopping(false);
        }
    }

    private void removeFromMap() {
        if (this.debugGui != null) {
            String key = this.debugGui.getTitle();
            mainInstanceMap.remove(key);
        }
    }

    public static void closeDebugger(String channelId) {
        for (String key : mainInstanceMap.keySet()) {
            if (!key.contains(channelId)) continue;
            MirthMain closingMain = mainInstanceMap.get(key);
            closingMain.dispose();
        }
    }
}

