/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.bmp;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.bmp.BMPConstants;
import com.sun.media.imageioimpl.plugins.bmp.I18N;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class BMPMetadata
extends IIOMetadata
implements BMPConstants {
    static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_bmp_image_1.0";
    public String bmpVersion;
    public int width;
    public int height;
    public short bitsPerPixel;
    public int compression;
    public int imageSize;
    public int xPixelsPerMeter;
    public int yPixelsPerMeter;
    public int colorsUsed;
    public int colorsImportant;
    public int redMask;
    public int greenMask;
    public int blueMask;
    public int alphaMask;
    public int colorSpace;
    public double redX;
    public double redY;
    public double redZ;
    public double greenX;
    public double greenY;
    public double greenZ;
    public double blueX;
    public double blueY;
    public double blueZ;
    public int gammaRed;
    public int gammaGreen;
    public int gammaBlue;
    public int intent;
    public byte[] palette = null;
    public int paletteSize;
    public int red;
    public int green;
    public int blue;
    public List comments = null;

    public BMPMetadata() {
        super(true, nativeMetadataFormatName, "com.sun.media.imageioimpl.BMPMetadataFormat", null, null);
    }

    public boolean isReadOnly() {
        return true;
    }

    public Node getAsTree(String formatName) {
        if (formatName.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException(I18N.getString("BMPMetadata0"));
    }

    private String toISO8859(byte[] data) {
        try {
            return new String(data, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    private Node getNativeTree() {
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        this.addChildNode(root, "BMPVersion", this.bmpVersion);
        this.addChildNode(root, "Width", new Integer(this.width));
        this.addChildNode(root, "Height", new Integer(this.height));
        this.addChildNode(root, "BitsPerPixel", new Short(this.bitsPerPixel));
        this.addChildNode(root, "Compression", new Integer(this.compression));
        this.addChildNode(root, "ImageSize", new Integer(this.imageSize));
        IIOMetadataNode node = this.addChildNode(root, "PixelsPerMeter", null);
        this.addChildNode(node, "X", new Integer(this.xPixelsPerMeter));
        this.addChildNode(node, "Y", new Integer(this.yPixelsPerMeter));
        this.addChildNode(root, "ColorsUsed", new Integer(this.colorsUsed));
        this.addChildNode(root, "ColorsImportant", new Integer(this.colorsImportant));
        int version = 0;
        int i = 0;
        while (i < this.bmpVersion.length()) {
            if (Character.isDigit(this.bmpVersion.charAt(i))) {
                version = this.bmpVersion.charAt(i) - 48;
            }
            ++i;
        }
        if (version >= 4) {
            node = this.addChildNode(root, "Mask", null);
            this.addChildNode(node, "Red", new Integer(this.redMask));
            this.addChildNode(node, "Green", new Integer(this.greenMask));
            this.addChildNode(node, "Blue", new Integer(this.blueMask));
            this.addChildNode(node, "Alpha", new Integer(this.alphaMask));
            this.addChildNode(root, "ColorSpaceType", new Integer(this.colorSpace));
            node = this.addChildNode(root, "CIEXYZEndPoints", null);
            this.addXYZPoints(node, "Red", this.redX, this.redY, this.redZ);
            this.addXYZPoints(node, "Green", this.greenX, this.greenY, this.greenZ);
            this.addXYZPoints(node, "Blue", this.blueX, this.blueY, this.blueZ);
            node = this.addChildNode(root, "Intent", new Integer(this.intent));
        }
        if (this.palette != null && this.paletteSize > 0) {
            node = this.addChildNode(root, "Palette", null);
            int numComps = this.palette.length / this.paletteSize;
            int i2 = 0;
            int j = 0;
            while (i2 < this.paletteSize) {
                IIOMetadataNode entry = this.addChildNode(node, "PaletteEntry", null);
                this.red = this.palette[j++] & 0xFF;
                this.green = this.palette[j++] & 0xFF;
                this.blue = this.palette[j++] & 0xFF;
                this.addChildNode(entry, "Red", new Byte((byte)this.red));
                this.addChildNode(entry, "Green", new Byte((byte)this.green));
                this.addChildNode(entry, "Blue", new Byte((byte)this.blue));
                if (numComps == 4) {
                    this.addChildNode(entry, "Alpha", new Byte((byte)(this.palette[j++] & 0xFF)));
                }
                ++i2;
            }
        }
        return root;
    }

    protected IIOMetadataNode getStandardChromaNode() {
        if (this.palette != null && this.paletteSize > 0) {
            IIOMetadataNode node = new IIOMetadataNode("Chroma");
            IIOMetadataNode subNode = new IIOMetadataNode("Palette");
            int numComps = this.palette.length / this.paletteSize;
            subNode.setAttribute("value", "" + numComps);
            int i = 0;
            int j = 0;
            while (i < this.paletteSize) {
                IIOMetadataNode subNode1 = new IIOMetadataNode("PaletteEntry");
                subNode1.setAttribute("index", "" + i);
                subNode1.setAttribute("red", "" + this.palette[j++]);
                subNode1.setAttribute("green", "" + this.palette[j++]);
                subNode1.setAttribute("blue", "" + this.palette[j++]);
                if (numComps == 4 && this.palette[j] != 0) {
                    subNode1.setAttribute("alpha", "" + this.palette[j++]);
                }
                subNode.appendChild(subNode1);
                ++i;
            }
            node.appendChild(subNode);
            return node;
        }
        return null;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode node = new IIOMetadataNode("Compression");
        IIOMetadataNode subNode = new IIOMetadataNode("CompressionTypeName");
        subNode.setAttribute("value", BMPConstants.compressionTypeNames[this.compression]);
        node.appendChild(subNode);
        return node;
    }

    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode node = new IIOMetadataNode("Data");
        String bits = "";
        if (this.bitsPerPixel == 24) {
            bits = "8 8 8 ";
        } else if (this.bitsPerPixel == 16 || this.bitsPerPixel == 32) {
            bits = "" + this.countBits(this.redMask) + " " + this.countBits(this.greenMask) + this.countBits(this.blueMask) + "" + this.countBits(this.alphaMask);
        }
        IIOMetadataNode subNode = new IIOMetadataNode("BitsPerSample");
        subNode.setAttribute("value", bits);
        node.appendChild(subNode);
        return node;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        if ((float)this.yPixelsPerMeter > 0.0f && (float)this.xPixelsPerMeter > 0.0f) {
            IIOMetadataNode node = new IIOMetadataNode("Dimension");
            float ratio = this.yPixelsPerMeter / this.xPixelsPerMeter;
            IIOMetadataNode subNode = new IIOMetadataNode("PixelAspectRatio");
            subNode.setAttribute("value", "" + ratio);
            node.appendChild(subNode);
            subNode = new IIOMetadataNode("HorizontalPhysicalPixelSpacing");
            subNode.setAttribute("value", "" + 1 / this.xPixelsPerMeter * 1000);
            node.appendChild(subNode);
            subNode = new IIOMetadataNode("VerticalPhysicalPixelSpacing");
            subNode.setAttribute("value", "" + 1 / this.yPixelsPerMeter * 1000);
            node.appendChild(subNode);
            return node;
        }
        return null;
    }

    public void setFromTree(String formatName, Node root) {
        throw new IllegalStateException(I18N.getString("BMPMetadata1"));
    }

    public void mergeTree(String formatName, Node root) {
        throw new IllegalStateException(I18N.getString("BMPMetadata1"));
    }

    public void reset() {
        throw new IllegalStateException(I18N.getString("BMPMetadata1"));
    }

    private String countBits(int num) {
        int count = 0;
        while (num > 0) {
            if ((num & 1) == 1) {
                ++count;
            }
            num >>>= 1;
        }
        return count == 0 ? "" : "" + count;
    }

    private void addXYZPoints(IIOMetadataNode root, String name, double x, double y, double z) {
        IIOMetadataNode node = this.addChildNode(root, name, null);
        this.addChildNode(node, "X", new Double(x));
        this.addChildNode(node, "Y", new Double(y));
        this.addChildNode(node, "Z", new Double(z));
    }

    private IIOMetadataNode addChildNode(IIOMetadataNode root, String name, Object object) {
        IIOMetadataNode child = new IIOMetadataNode(name);
        if (object != null) {
            child.setUserObject(object);
            child.setNodeValue(ImageUtil.convertObjectToString(object));
        }
        root.appendChild(child);
        return child;
    }

    static {
        nativeMetadataFormatName = nativeMetadataFormatName;
    }
}

