/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.clib.CLibImageWriter;
import com.sun.media.imageioimpl.plugins.clib.OutputStreamAdapter;
import com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriteParam;
import com.sun.medialib.codec.jpeg.Encoder;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

final class CLibJPEGImageWriter
extends CLibImageWriter {
    private Encoder encoder = new Encoder();

    CLibJPEGImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
        this.encoder.setExtend(0);
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new CLibJPEGImageWriteParam(this.getLocale());
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        int jpegType;
        if (this.output == null) {
            throw new IllegalStateException("output == null");
        }
        OutputStreamAdapter stream = null;
        if (!(this.output instanceof ImageOutputStream)) {
            throw new IllegalArgumentException("!(output instanceof ImageOutputStream)");
        }
        stream = new OutputStreamAdapter((ImageOutputStream)this.output);
        RenderedImage renderedImage = image.getRenderedImage();
        ImageUtil.canEncodeImage(this, renderedImage.getColorModel(), renderedImage.getSampleModel());
        if (param != null && param.getCompressionMode() == 2) {
            if (param.isCompressionLossless()) {
                if (param.getCompressionType().equalsIgnoreCase("JPEG-LOSSLESS")) {
                    this.encoder.setMode(1);
                } else {
                    int bitDepth = renderedImage.getColorModel().getComponentSize(0);
                    if (bitDepth >= 2 && bitDepth <= 16 && bitDepth % 8 != 0) {
                        this.encoder.setDepth(bitDepth);
                    }
                    this.encoder.setMode(2);
                }
            } else {
                this.encoder.setQuality((int)(param.getCompressionQuality() * 100.0f));
            }
        } else {
            this.encoder.setMode(0);
            this.encoder.setQuality(75);
        }
        mediaLibImage mlibImage = this.getMediaLibImage(renderedImage, param, false);
        switch (mlibImage.getChannels()) {
            case 1: {
                jpegType = 1;
                break;
            }
            case 3: {
                jpegType = 2;
                break;
            }
            default: {
                jpegType = 0;
            }
        }
        this.encoder.setType(jpegType);
        this.encoder.encode((OutputStream)stream, mlibImage);
    }
}

