/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter;
import com.sun.medialib.codec.jiio.Util;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class CLibPNGImageWriterSpi
extends ImageWriterSpi {
    private static final String vendorName = "Sun Microsystems, Inc.";
    private static final String version = "0.5";
    private static final String[] names;
    private static final String[] suffixes;
    private static final String[] MIMETypes;
    private static final String writerClassName = "com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter";
    private static final String[] readerSpiNames;
    private boolean registered = false;

    public CLibPNGImageWriterSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, writerClassName, ImageWriterSpi.STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, true, null, null, null, null);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        if (!this.registered) {
            boolean isCodecLibAvailable;
            try {
                isCodecLibAvailable = Util.isCodecLibAvailable();
            }
            catch (Throwable e) {
                isCodecLibAvailable = false;
            }
            if (!isCodecLibAvailable) {
                registry.deregisterServiceProvider(this);
            }
            this.registered = true;
        }
    }

    public boolean canEncodeImage(ImageTypeSpecifier type) {
        SampleModel sampleModel = type.getSampleModel();
        ColorModel colorModel = type.getColorModel();
        int[] sampleSize = sampleModel.getSampleSize();
        int bitDepth = sampleSize[0];
        int i = 1;
        while (i < sampleSize.length) {
            if (sampleSize[i] != bitDepth) {
                return false;
            }
            ++i;
        }
        if (bitDepth != 1 && bitDepth != 8 && bitDepth != 16) {
            return false;
        }
        int numBands = sampleModel.getNumBands();
        if (numBands < 1 || numBands > 4) {
            return false;
        }
        if (colorModel instanceof IndexColorModel) {
            return true;
        }
        boolean hasAlpha = colorModel.hasAlpha();
        if ((numBands == 1 || numBands == 3) && hasAlpha) {
            return false;
        }
        return numBands != 2 && numBands != 4 || hasAlpha;
    }

    public String getDescription(Locale locale) {
        return "codecLib PNG image writer";
    }

    public ImageWriter createWriterInstance(Object extension) {
        return new CLibPNGImageWriter(this);
    }

    static {
        vendorName = vendorName;
        version = version;
        names = new String[]{"png", "PNG"};
        suffixes = new String[]{"png"};
        MIMETypes = new String[]{"image/png", "image/x-png"};
        writerClassName = writerClassName;
        readerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.png.CLibPNGImageReaderSpi"};
    }
}

