/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.dto.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;

public class CacheStatistics {
    private final boolean statsSupported;
    private final String evictionPolicy;
    private final int currentEntryCount;
    private final int configuredMaxEntries;
    private final long hitCount;
    private final long missCount;
    private final long loadSuccessCount;
    private final long loadExceptionCount;
    private final long totalLoadTime;
    private final long evictionCount;
    private final double hitRatio;
    private final double missRatio;
    private final String totalLoadTimeFormatted;

    @JsonCreator
    public CacheStatistics(@JsonProperty(value="statsSupported") boolean bl, @JsonProperty(value="evictionPolicy") String string, @JsonProperty(value="currentEntryCount") int n, @JsonProperty(value="configuredMaxEntries") int n2, @JsonProperty(value="hitCount") long l, @JsonProperty(value="missCount") long l2, @JsonProperty(value="loadSuccessCount") long l3, @JsonProperty(value="loadExceptionCount") long l4, @JsonProperty(value="totalLoadTime") long l5, @JsonProperty(value="evictionCount") long l6) {
        this.statsSupported = bl;
        this.evictionPolicy = string != null ? string.toUpperCase() : "UNKNOWN";
        this.currentEntryCount = n;
        this.configuredMaxEntries = n2;
        this.hitCount = l;
        this.missCount = l2;
        this.loadSuccessCount = l3;
        this.loadExceptionCount = l4;
        this.totalLoadTime = l5;
        this.evictionCount = l6;
        long l7 = l + l2;
        this.hitRatio = l7 > 0L ? (double)l / (double)l7 : 0.0;
        this.missRatio = l7 > 0L ? (double)l2 / (double)l7 : 0.0;
        this.totalLoadTimeFormatted = this.formatLoadTime(l5);
    }

    private String formatLoadTime(long l) {
        long l2 = TimeUnit.NANOSECONDS.toMillis(l);
        return l2 < 1000L ? l2 + " ms" : l2 / 1000L + " sec";
    }

    public boolean isStatsSupported() {
        return this.statsSupported;
    }

    public String getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public int getCurrentEntryCount() {
        return this.currentEntryCount;
    }

    public int getConfiguredMaxEntries() {
        return this.configuredMaxEntries;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public long getLoadSuccessCount() {
        return this.loadSuccessCount;
    }

    public long getLoadExceptionCount() {
        return this.loadExceptionCount;
    }

    public long getTotalLoadTime() {
        return this.totalLoadTime;
    }

    public long getEvictionCount() {
        return this.evictionCount;
    }

    public double getHitRatio() {
        return this.hitRatio;
    }

    public double getMissRatio() {
        return this.missRatio;
    }

    public String getTotalLoadTimeFormatted() {
        return this.totalLoadTimeFormatted;
    }
}

