/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.dto.response;

import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupValue;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExportGroupPagedResponse {
    private Integer groupId;
    private Integer totalCount;
    private Pagination pagination;
    private Map<String, String> values;
    private Date exportDate;

    public ExportGroupPagedResponse() {
    }

    public ExportGroupPagedResponse(Integer n, Integer n2, Pagination pagination, Map<String, String> map, Date date) {
        this.groupId = n;
        this.totalCount = n2;
        this.pagination = pagination;
        this.values = map;
        this.exportDate = date;
    }

    public static ExportGroupPagedResponse fromResult(Integer n, int n2, int n3, int n4, List<LookupValue> list) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (LookupValue lookupValue : list) {
            linkedHashMap.put(lookupValue.getKeyValue(), lookupValue.getValueData());
        }
        Pagination pagination = new Pagination();
        pagination.setOffset(n2);
        pagination.setLimit(n3);
        pagination.setHasMore(n2 + n3 < n4);
        return new ExportGroupPagedResponse(n, n4, pagination, linkedHashMap, new Date());
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer n) {
        this.groupId = n;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer n) {
        this.totalCount = n;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public void setValues(Map<String, String> map) {
        this.values = map;
    }

    public Date getExportDate() {
        return this.exportDate;
    }

    public void setExportDate(Date date) {
        this.exportDate = date;
    }

    public static class Pagination {
        private int offset;
        private int limit;
        private boolean hasMore;

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int n) {
            this.offset = n;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int n) {
            this.limit = n;
        }

        public boolean isHasMore() {
            return this.hasMore;
        }

        public void setHasMore(boolean bl) {
            this.hasMore = bl;
        }
    }
}

