/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.model;

import com.mirth.connect.plugins.dynamiclookup.shared.util.JsonUtils;
import java.util.Objects;

public class ValueFilterState {
    private String keyFilter;
    private String valueFilter;
    private KeyFilterMode keyFilterMode = KeyFilterMode.PREFIX;

    public static ValueFilterState empty() {
        return new ValueFilterState("", "", KeyFilterMode.PREFIX);
    }

    public ValueFilterState() {
    }

    public ValueFilterState(String string, String string2, KeyFilterMode keyFilterMode) {
        this.keyFilter = this.normalize(string);
        this.valueFilter = this.normalize(string2);
        this.keyFilterMode = keyFilterMode != null ? keyFilterMode : KeyFilterMode.PREFIX;
    }

    public String getKeyFilter() {
        return this.keyFilter;
    }

    public void setKeyFilter(String string) {
        this.keyFilter = this.normalize(string);
    }

    public KeyFilterMode getKeyFilterMode() {
        return this.keyFilterMode;
    }

    public void setKeyFilterMode(KeyFilterMode keyFilterMode) {
        this.keyFilterMode = keyFilterMode != null ? keyFilterMode : KeyFilterMode.PREFIX;
    }

    public String getValueFilter() {
        return this.valueFilter;
    }

    public void setValueFilter(String string) {
        this.valueFilter = this.normalize(string);
    }

    private String normalize(String string) {
        return string == null ? "" : string.trim();
    }

    public boolean isEmpty() {
        return this.isNullOrEmpty(this.keyFilter) && this.isNullOrEmpty(this.valueFilter);
    }

    private boolean isNullOrEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public String toJson() throws Exception {
        return JsonUtils.toJson(this);
    }

    public static ValueFilterState fromJson(String string) throws Exception {
        return JsonUtils.fromJson(string, ValueFilterState.class);
    }

    public void clearAll() {
        this.keyFilter = null;
        this.keyFilterMode = KeyFilterMode.PREFIX;
        this.valueFilter = null;
    }

    public static String toDisplay(KeyFilterMode keyFilterMode) {
        switch (keyFilterMode) {
            case EXACT: {
                return "Exact match";
            }
            case PREFIX: {
                return "Starts with";
            }
            case CONTAINS: {
                return "Contains";
            }
            case PATTERN: {
                return "Pattern (SQL wildcards)";
            }
        }
        return keyFilterMode.name();
    }

    public String toString() {
        return "ValueFilterState{keyFilter='" + this.keyFilter + "', valueFilter='" + this.valueFilter + "'}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValueFilterState)) {
            return false;
        }
        ValueFilterState valueFilterState = (ValueFilterState)object;
        return Objects.equals(this.keyFilter, valueFilterState.keyFilter) && Objects.equals(this.valueFilter, valueFilterState.valueFilter) && this.keyFilterMode == valueFilterState.keyFilterMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keyFilter, this.valueFilter, this.keyFilterMode});
    }

    public static enum KeyFilterMode {
        CONTAINS,
        PREFIX,
        EXACT,
        PATTERN;

    }
}

