/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.dimse;

import com.mirth.connect.connectors.dimse.DICOMConfiguration;
import com.mirth.connect.connectors.dimse.DICOMDispatcherProperties;
import com.mirth.connect.connectors.dimse.DefaultDICOMConfiguration;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.util.ErrorMessageBuilder;
import java.io.File;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.UserIdentity;
import org.dcm4che2.tool.dcmsnd.CustomDimseRSPHandler;
import org.dcm4che2.tool.dcmsnd.MirthDcmSnd;
import org.dcm4che2.util.StringUtils;

public class DICOMDispatcher
extends DestinationConnector {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private DICOMDispatcherProperties connectorProperties;
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    protected DICOMConfiguration configuration = null;

    public void onDeploy() throws ConnectorTaskException {
        this.connectorProperties = (DICOMDispatcherProperties)this.getConnectorProperties();
        String configurationClass = this.configurationController.getProperty(this.connectorProperties.getProtocol(), "dicomConfigurationClass");
        try {
            this.configuration = (DICOMConfiguration)Class.forName(configurationClass).newInstance();
        }
        catch (Throwable t) {
            this.logger.trace("could not find custom configuration class, using default");
            this.configuration = new DefaultDICOMConfiguration();
        }
        try {
            this.configuration.configureConnectorDeploy((Connector)this);
        }
        catch (Exception e) {
            throw new ConnectorTaskException((Throwable)e);
        }
    }

    public void onUndeploy() throws ConnectorTaskException {
    }

    public void onStart() throws ConnectorTaskException {
    }

    public void onStop() throws ConnectorTaskException {
    }

    public void onHalt() throws ConnectorTaskException {
    }

    public void replaceConnectorProperties(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage) {
        DICOMDispatcherProperties dicomDispatcherProperties = (DICOMDispatcherProperties)connectorProperties;
        dicomDispatcherProperties.setHost(this.replacer.replaceValues(dicomDispatcherProperties.getHost(), connectorMessage));
        dicomDispatcherProperties.setPort(this.replacer.replaceValues(dicomDispatcherProperties.getPort(), connectorMessage));
        dicomDispatcherProperties.setLocalHost(this.replacer.replaceValues(dicomDispatcherProperties.getLocalHost(), connectorMessage));
        dicomDispatcherProperties.setLocalPort(this.replacer.replaceValues(dicomDispatcherProperties.getLocalPort(), connectorMessage));
        dicomDispatcherProperties.setApplicationEntity(this.replacer.replaceValues(dicomDispatcherProperties.getApplicationEntity(), connectorMessage));
        dicomDispatcherProperties.setLocalApplicationEntity(this.replacer.replaceValues(dicomDispatcherProperties.getLocalApplicationEntity(), connectorMessage));
        dicomDispatcherProperties.setUsername(this.replacer.replaceValues(dicomDispatcherProperties.getUsername(), connectorMessage));
        dicomDispatcherProperties.setPasscode(this.replacer.replaceValues(dicomDispatcherProperties.getPasscode(), connectorMessage));
        dicomDispatcherProperties.setTemplate(this.replacer.replaceValues(dicomDispatcherProperties.getTemplate(), connectorMessage));
        dicomDispatcherProperties.setKeyStore(this.replacer.replaceValues(dicomDispatcherProperties.getKeyStore(), connectorMessage));
        dicomDispatcherProperties.setKeyStorePW(this.replacer.replaceValues(dicomDispatcherProperties.getKeyStorePW(), connectorMessage));
        dicomDispatcherProperties.setTrustStore(this.replacer.replaceValues(dicomDispatcherProperties.getTrustStore(), connectorMessage));
        dicomDispatcherProperties.setTrustStorePW(this.replacer.replaceValues(dicomDispatcherProperties.getTrustStorePW(), connectorMessage));
        dicomDispatcherProperties.setKeyPW(this.replacer.replaceValues(dicomDispatcherProperties.getKeyPW(), connectorMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response send(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage) {
        DICOMDispatcherProperties dicomDispatcherProperties = (DICOMDispatcherProperties)connectorProperties;
        String info = "Host: " + dicomDispatcherProperties.getHost();
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.WRITING, info));
        String responseData = null;
        String responseError = null;
        Object responseStatusMessage = null;
        Status responseStatus = Status.QUEUED;
        File tempFile = null;
        MirthDcmSnd dcmSnd = this.getDcmSnd(this.configuration);
        try {
            tempFile = File.createTempFile("temp", "tmp");
            FileUtils.writeByteArrayToFile((File)tempFile, (byte[])this.getAttachmentHandlerProvider().reAttachMessage(dicomDispatcherProperties.getTemplate(), connectorMessage, null, true, dicomDispatcherProperties.getDestinationConnectorProperties().isReattachAttachments()));
            dcmSnd.setCalledAET("DCMRCV");
            dcmSnd.setRemoteHost(dicomDispatcherProperties.getHost());
            dcmSnd.setRemotePort(NumberUtils.toInt((String)dicomDispatcherProperties.getPort()));
            if (dicomDispatcherProperties.getApplicationEntity() != null && !dicomDispatcherProperties.getApplicationEntity().equals("")) {
                dcmSnd.setCalledAET(dicomDispatcherProperties.getApplicationEntity());
            }
            if (dicomDispatcherProperties.getLocalApplicationEntity() != null && !dicomDispatcherProperties.getLocalApplicationEntity().equals("")) {
                dcmSnd.setCalling(dicomDispatcherProperties.getLocalApplicationEntity());
            }
            if (dicomDispatcherProperties.getLocalHost() != null && !dicomDispatcherProperties.getLocalHost().equals("")) {
                dcmSnd.setLocalHost(dicomDispatcherProperties.getLocalHost());
                dcmSnd.setLocalPort(NumberUtils.toInt((String)dicomDispatcherProperties.getLocalPort()));
            }
            dcmSnd.addFile(tempFile);
            int value = NumberUtils.toInt((String)dicomDispatcherProperties.getAcceptTo());
            if (value != 5) {
                dcmSnd.setAcceptTimeout(value);
            }
            if ((value = NumberUtils.toInt((String)dicomDispatcherProperties.getAsync())) > 0) {
                dcmSnd.setMaxOpsInvoked(value);
            }
            if ((value = NumberUtils.toInt((String)dicomDispatcherProperties.getBufSize())) != 1) {
                dcmSnd.setTranscoderBufferSize(value);
            }
            if ((value = NumberUtils.toInt((String)dicomDispatcherProperties.getConnectTo())) > 0) {
                dcmSnd.setConnectTimeout(value);
            }
            if (dicomDispatcherProperties.getPriority().equals("med")) {
                dcmSnd.setPriority(0);
            } else if (dicomDispatcherProperties.getPriority().equals("low")) {
                dcmSnd.setPriority(1);
            } else if (dicomDispatcherProperties.getPriority().equals("high")) {
                dcmSnd.setPriority(2);
            }
            if (dicomDispatcherProperties.getUsername() != null && !dicomDispatcherProperties.getUsername().equals("")) {
                UserIdentity.Username userId;
                String username = dicomDispatcherProperties.getUsername();
                if (dicomDispatcherProperties.getPasscode() != null && !dicomDispatcherProperties.getPasscode().equals("")) {
                    String passcode = dicomDispatcherProperties.getPasscode();
                    userId = new UserIdentity.UsernamePasscode(username, passcode.toCharArray());
                } else {
                    userId = new UserIdentity.Username(username);
                }
                userId.setPositiveResponseRequested(dicomDispatcherProperties.isUidnegrsp());
                dcmSnd.setUserIdentity((UserIdentity)userId);
            }
            dcmSnd.setPackPDV(dicomDispatcherProperties.isPdv1());
            value = NumberUtils.toInt((String)dicomDispatcherProperties.getRcvpdulen());
            if (value != 16) {
                dcmSnd.setMaxPDULengthReceive(value);
            }
            if ((value = NumberUtils.toInt((String)dicomDispatcherProperties.getReaper())) != 10) {
                dcmSnd.setAssociationReaperPeriod(value);
            }
            if ((value = NumberUtils.toInt((String)dicomDispatcherProperties.getReleaseTo())) != 5) {
                dcmSnd.setReleaseTimeout(value);
            }
            if ((value = NumberUtils.toInt((String)dicomDispatcherProperties.getRspTo())) != 60) {
                dcmSnd.setDimseRspTimeout(value);
            }
            if ((value = NumberUtils.toInt((String)dicomDispatcherProperties.getShutdownDelay())) != 1000) {
                dcmSnd.setShutdownDelay(value);
            }
            if ((value = NumberUtils.toInt((String)dicomDispatcherProperties.getSndpdulen())) != 16) {
                dcmSnd.setMaxPDULengthSend(value);
            }
            if ((value = NumberUtils.toInt((String)dicomDispatcherProperties.getSoCloseDelay())) != 50) {
                dcmSnd.setSocketCloseDelay(value);
            }
            if ((value = NumberUtils.toInt((String)dicomDispatcherProperties.getSorcvbuf())) > 0) {
                dcmSnd.setReceiveBufferSize(value);
            }
            if ((value = NumberUtils.toInt((String)dicomDispatcherProperties.getSosndbuf())) > 0) {
                dcmSnd.setSendBufferSize(value);
            }
            dcmSnd.setStorageCommitment(dicomDispatcherProperties.isStgcmt());
            dcmSnd.setTcpNoDelay(!dicomDispatcherProperties.isTcpDelay());
            this.configuration.configureDcmSnd(dcmSnd, this, dicomDispatcherProperties);
            dcmSnd.setOfferDefaultTransferSyntaxInSeparatePresentationContext(dicomDispatcherProperties.isTs1());
            dcmSnd.configureTransferCapability();
            dcmSnd.start();
            dcmSnd.open();
            CommandDataDimseRSPHandler rspHandler = new CommandDataDimseRSPHandler();
            dcmSnd.send(rspHandler);
            boolean storageCommitmentFailed = false;
            String storageCommitmentFailureReason = "Unknown";
            if (dcmSnd.isStorageCommitment()) {
                if (dcmSnd.commit()) {
                    DicomObject cmtrslt = dcmSnd.waitForStgCmtResult();
                    DicomElement failedSOPSq = cmtrslt.get(528792);
                    if (failedSOPSq != null && failedSOPSq.countItems() > 0) {
                        storageCommitmentFailed = true;
                        DicomObject failedSOPItem = failedSOPSq.getDicomObject();
                        int failureReason = failedSOPItem.getInt(528791);
                        if (failureReason != 0) {
                            storageCommitmentFailureReason = String.valueOf(failureReason);
                        }
                    }
                } else {
                    storageCommitmentFailed = true;
                }
            }
            dcmSnd.close();
            int status = rspHandler.getStatus();
            if (status == 0) {
                responseStatusMessage = "DICOM message successfully sent";
                responseStatus = Status.SENT;
            } else if (status == 45056 || status == 45062 || status == 45063) {
                responseStatusMessage = "DICOM message successfully sent with warning status code: 0x" + StringUtils.shortToHex((int)status);
                responseStatus = Status.SENT;
            } else {
                responseStatusMessage = "Error status code received from DICOM server: 0x" + StringUtils.shortToHex((int)status);
                responseStatus = Status.QUEUED;
            }
            if (storageCommitmentFailed && responseStatus == Status.SENT) {
                responseStatusMessage = (String)responseStatusMessage + " but Storage Commitment failed with reason: " + storageCommitmentFailureReason;
                responseStatus = Status.QUEUED;
            }
            responseData = rspHandler.getCommandData();
        }
        catch (Exception e) {
            responseStatusMessage = ErrorMessageBuilder.buildErrorResponse((String)e.getMessage(), (Throwable)e);
            responseError = ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)e.getMessage(), null);
            this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(connectorMessage.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), connectorProperties.getName(), e.getMessage(), null));
        }
        finally {
            dcmSnd.stop();
            if (tempFile != null) {
                tempFile.delete();
            }
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
        }
        return new Response(responseStatus, responseData, (String)responseStatusMessage, responseError);
    }

    protected MirthDcmSnd getDcmSnd(DICOMConfiguration configuration) {
        return new MirthDcmSnd(configuration);
    }

    protected class CommandDataDimseRSPHandler
    extends CustomDimseRSPHandler {
        private DicomObject cmd;

        protected CommandDataDimseRSPHandler() {
        }

        @Override
        public void onDimseRSP(Association as, DicomObject cmd, DicomObject data) {
            this.cmd = cmd;
        }

        public int getStatus() {
            if (this.cmd != null) {
                return this.cmd.getInt(2304);
            }
            return 0;
        }

        public String getCommandData() {
            if (this.cmd instanceof BasicDicomObject) {
                try {
                    DonkeyElement dicom = new DonkeyElement("<dicom/>");
                    Iterator it = ((BasicDicomObject)this.cmd).commandIterator();
                    while (it.hasNext()) {
                        DicomElement element = (DicomElement)it.next();
                        String tag = StringUtils.shortToHex((int)(element.tag() >> 16)) + StringUtils.shortToHex((int)element.tag());
                        DonkeyElement child = dicom.addChildElement("tag" + tag, element.getValueAsString(null, 0));
                        child.setAttribute("len", String.valueOf(element.length()));
                        child.setAttribute("tag", tag);
                        child.setAttribute("vr", String.valueOf(element.vr()));
                    }
                    return dicom.toXml();
                }
                catch (Throwable t) {
                    DICOMDispatcher.this.logger.error("Unable to extract DICOM command data from response", t);
                }
            }
            return null;
        }
    }
}

