/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.vm;

import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class VmDispatcherProperties
extends ConnectorProperties
implements DestinationConnectorPropertiesInterface {
    private DestinationConnectorProperties destinationConnectorProperties;
    private String channelId;
    private String channelTemplate;
    private List<String> mapVariables;

    public VmDispatcherProperties() {
        this.destinationConnectorProperties = new DestinationConnectorProperties(false);
        this.channelId = "none";
        this.channelTemplate = "${message.encodedData}";
        this.mapVariables = new ArrayList<String>();
    }

    public VmDispatcherProperties(VmDispatcherProperties props) {
        super((ConnectorProperties)props);
        this.destinationConnectorProperties = new DestinationConnectorProperties(props.getDestinationConnectorProperties());
        this.channelId = props.getChannelId();
        this.channelTemplate = props.getChannelTemplate();
        this.mapVariables = props.getMapVariables();
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getChannelTemplate() {
        return this.channelTemplate;
    }

    public void setChannelTemplate(String channelTemplate) {
        this.channelTemplate = channelTemplate;
    }

    public List<String> getMapVariables() {
        return this.mapVariables;
    }

    public void setMapVariables(List<String> sourceMap) {
        this.mapVariables = sourceMap;
    }

    public String getName() {
        return "Channel Writer";
    }

    public String getProtocol() {
        return "VM";
    }

    public String toFormattedString() {
        StringBuilder builder = new StringBuilder();
        String newLine = "\n";
        builder.append("CHANNEL ID: ");
        builder.append(this.channelId);
        builder.append(newLine);
        builder.append(newLine);
        builder.append("[MAP VARIABLES]");
        if (this.mapVariables != null) {
            for (String variable : this.mapVariables) {
                builder.append(newLine);
                builder.append(variable);
            }
        }
        builder.append(newLine);
        builder.append(newLine);
        builder.append("[CONTENT]");
        builder.append(newLine);
        builder.append(this.channelTemplate);
        return builder.toString();
    }

    public DestinationConnectorProperties getDestinationConnectorProperties() {
        return this.destinationConnectorProperties;
    }

    public ConnectorProperties clone() {
        return new VmDispatcherProperties(this);
    }

    public boolean canValidateResponse() {
        return true;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        super.migrate3_1_0(element);
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("destinationConnectorProperties", this.destinationConnectorProperties.getPurgedProperties());
        purgedProperties.put("channelTemplateLines", PurgeUtil.countLines((String)this.channelTemplate));
        return purgedProperties;
    }
}

