/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.tcp;

import com.mirth.connect.donkey.model.channel.ConnectorPluginProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.ListenerConnectorProperties;
import com.mirth.connect.donkey.model.channel.ListenerConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.channel.SourceConnectorProperties;
import com.mirth.connect.donkey.model.channel.SourceConnectorPropertiesInterface;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.transmission.TransmissionModeProperties;
import com.mirth.connect.model.transmission.framemode.FrameModeProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class TcpReceiverProperties
extends ConnectorProperties
implements ListenerConnectorPropertiesInterface,
SourceConnectorPropertiesInterface {
    private ListenerConnectorProperties listenerConnectorProperties = new ListenerConnectorProperties("6661");
    private SourceConnectorProperties sourceConnectorProperties = new SourceConnectorProperties("Auto-generate (After source transformer)");
    public static final String PROTOCOL = "TCP";
    public static final String NAME = "TCP Listener";
    public static final int SAME_CONNECTION = 0;
    public static final int NEW_CONNECTION = 1;
    public static final int NEW_CONNECTION_ON_RECOVERY = 2;
    private TransmissionModeProperties transmissionModeProperties;
    private boolean serverMode;
    private String remoteAddress;
    private String remotePort;
    private boolean overrideLocalBinding;
    private String reconnectInterval;
    private String receiveTimeout;
    private String bufferSize;
    private String maxConnections;
    private boolean keepConnectionOpen;
    private boolean dataTypeBinary;
    private String charsetEncoding;
    private int respondOnNewConnection;
    private String responseAddress;
    private String responsePort;
    private Set<ConnectorPluginProperties> responseConnectorPluginProperties;

    public TcpReceiverProperties() {
        this.sourceConnectorProperties.setFirstResponse(true);
        FrameModeProperties frameModeProperties = new FrameModeProperties("MLLP");
        frameModeProperties.setStartOfMessageBytes("0B");
        frameModeProperties.setEndOfMessageBytes("1C0D");
        this.transmissionModeProperties = frameModeProperties;
        this.serverMode = true;
        this.remoteAddress = "";
        this.remotePort = "";
        this.overrideLocalBinding = false;
        this.reconnectInterval = "5000";
        this.receiveTimeout = "0";
        this.bufferSize = "65536";
        this.maxConnections = "10";
        this.keepConnectionOpen = true;
        this.dataTypeBinary = false;
        this.charsetEncoding = "DEFAULT_ENCODING";
        this.respondOnNewConnection = 0;
        this.responseAddress = "";
        this.responsePort = "";
    }

    public SourceConnectorProperties getSourceConnectorProperties() {
        return this.sourceConnectorProperties;
    }

    public void setSourceConnectorProperties(SourceConnectorProperties sourceConnectorProperties) {
        this.sourceConnectorProperties = sourceConnectorProperties;
    }

    public ListenerConnectorProperties getListenerConnectorProperties() {
        return this.listenerConnectorProperties;
    }

    public void setListenerConnectorProperties(ListenerConnectorProperties listenerConnectorProperties) {
        this.listenerConnectorProperties = listenerConnectorProperties;
    }

    public TransmissionModeProperties getTransmissionModeProperties() {
        return this.transmissionModeProperties;
    }

    public void setTransmissionModeProperties(TransmissionModeProperties transmissionModeProperties) {
        this.transmissionModeProperties = transmissionModeProperties;
    }

    public boolean isServerMode() {
        return this.serverMode;
    }

    public void setServerMode(boolean serverMode) {
        this.serverMode = serverMode;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public String getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(String remotePort) {
        this.remotePort = remotePort;
    }

    public boolean isOverrideLocalBinding() {
        return this.overrideLocalBinding;
    }

    public void setOverrideLocalBinding(boolean overrideLocalBinding) {
        this.overrideLocalBinding = overrideLocalBinding;
    }

    public String getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(String reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public String getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(String receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(String maxConnections) {
        this.maxConnections = maxConnections;
    }

    public boolean isKeepConnectionOpen() {
        return this.keepConnectionOpen;
    }

    public void setKeepConnectionOpen(boolean keepConnectionOpen) {
        this.keepConnectionOpen = keepConnectionOpen;
    }

    public boolean isDataTypeBinary() {
        return this.dataTypeBinary;
    }

    public void setDataTypeBinary(boolean dataTypeBinary) {
        this.dataTypeBinary = dataTypeBinary;
    }

    public String getCharsetEncoding() {
        return this.charsetEncoding;
    }

    public void setCharsetEncoding(String charsetEncoding) {
        this.charsetEncoding = charsetEncoding;
    }

    public int getRespondOnNewConnection() {
        return this.respondOnNewConnection;
    }

    public void setRespondOnNewConnection(int respondOnNewConnection) {
        this.respondOnNewConnection = respondOnNewConnection;
    }

    public String getResponseAddress() {
        return this.responseAddress;
    }

    public void setResponseAddress(String responseAddress) {
        this.responseAddress = responseAddress;
    }

    public String getResponsePort() {
        return this.responsePort;
    }

    public void setResponsePort(String responsePort) {
        this.responsePort = responsePort;
    }

    public Set<ConnectorPluginProperties> getResponseConnectorPluginProperties() {
        return this.responseConnectorPluginProperties;
    }

    public void setResponseConnectorPluginProperties(Set<ConnectorPluginProperties> responseConnectorPluginProperties) {
        this.responseConnectorPluginProperties = responseConnectorPluginProperties;
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public String getName() {
        return NAME;
    }

    public String toFormattedString() {
        return null;
    }

    public boolean canBatch() {
        return true;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
        String remoteAddress = "";
        String remotePort = "";
        if (!Boolean.parseBoolean(element.getChildElement("serverMode").getTextContent())) {
            DonkeyElement listenerConnectorProperties = element.getChildElement("listenerConnectorProperties");
            DonkeyElement host = listenerConnectorProperties.getChildElement("host");
            DonkeyElement port = listenerConnectorProperties.getChildElement("port");
            remoteAddress = host.getTextContent();
            remotePort = port.getTextContent();
            host.setTextContent("0.0.0.0");
            port.setTextContent("0");
        }
        element.addChildElementIfNotExists("remoteAddress", remoteAddress);
        element.addChildElementIfNotExists("remotePort", remotePort);
        element.addChildElementIfNotExists("overrideLocalBinding", "false");
    }

    public void migrate3_1_0(DonkeyElement element) {
        super.migrate3_1_0(element);
        DonkeyElement processBatchElement = element.removeChild("processBatch");
        DonkeyElement sourcePropertiesElement = element.getChildElement("sourceConnectorProperties");
        if (processBatchElement != null && sourcePropertiesElement != null) {
            sourcePropertiesElement.addChildElementIfNotExists("processBatch", processBatchElement.getTextContent());
            sourcePropertiesElement.addChildElementIfNotExists("firstResponse", "true");
        }
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("sourceConnectorProperties", this.sourceConnectorProperties.getPurgedProperties());
        purgedProperties.put("transmissionModeProperties", this.transmissionModeProperties.getPurgedProperties());
        purgedProperties.put("serverMode", this.serverMode);
        purgedProperties.put("overrideLocalBinding", this.overrideLocalBinding);
        purgedProperties.put("reconnectInterval", PurgeUtil.getNumericValue((String)this.reconnectInterval));
        purgedProperties.put("receiveTimeout", PurgeUtil.getNumericValue((String)this.receiveTimeout));
        purgedProperties.put("bufferSize", PurgeUtil.getNumericValue((String)this.bufferSize));
        purgedProperties.put("maxConnections", PurgeUtil.getNumericValue((String)this.maxConnections));
        purgedProperties.put("keepConnectionOpen", this.keepConnectionOpen);
        purgedProperties.put("dataTypeBinary", this.dataTypeBinary);
        purgedProperties.put("charsetEncoding", this.charsetEncoding);
        purgedProperties.put("respondOnNewConnection", this.respondOnNewConnection);
        if (this.responseConnectorPluginProperties != null) {
            HashSet<Map> purgedPluginProperties = new HashSet<Map>();
            for (ConnectorPluginProperties cpp : this.responseConnectorPluginProperties) {
                purgedPluginProperties.add(cpp.getPurgedProperties());
            }
            purgedProperties.put("responseConnectorPluginProperties", purgedPluginProperties);
        }
        return purgedProperties;
    }
}

