/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.http;

import com.mirth.connect.connectors.http.HttpConfiguration;
import com.mirth.connect.connectors.http.HttpDispatcher;
import com.mirth.connect.connectors.http.HttpDispatcherProperties;
import com.mirth.connect.connectors.http.HttpReceiver;
import com.mirth.connect.donkey.model.channel.ConnectorPluginProperties;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.util.MirthSSLUtil;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.servlet.ServletRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContexts;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ServerConnector;

public class DefaultHttpConfiguration
implements HttpConfiguration {
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();

    @Override
    public void configureConnectorDeploy(com.mirth.connect.donkey.server.channel.Connector connector) throws Exception {
        if (connector instanceof HttpDispatcher) {
            this.configureSocketFactoryRegistry(null, ((HttpDispatcher)connector).getSocketFactoryRegistry());
        }
    }

    @Override
    public void configureConnectorUndeploy(com.mirth.connect.donkey.server.channel.Connector connector) {
    }

    @Override
    public void configureReceiver(HttpReceiver connector) throws Exception {
        org.eclipse.jetty.server.HttpConfiguration httpConfig = new org.eclipse.jetty.server.HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendXPoweredBy(false);
        ServerConnector listener = new ServerConnector(connector.getServer(), new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        listener.setHost(connector.getHost());
        listener.setPort(connector.getPort());
        listener.setIdleTimeout((long)connector.getTimeout());
        connector.getServer().addConnector((Connector)listener);
    }

    @Override
    public void configureDispatcher(HttpDispatcher connector, HttpDispatcherProperties connectorProperties) throws Exception {
    }

    @Override
    public void configureSocketFactoryRegistry(ConnectorPluginProperties properties, RegistryBuilder<ConnectionSocketFactory> registry) throws Exception {
        String[] enabledProtocols = MirthSSLUtil.getEnabledHttpsProtocols((String[])this.configurationController.getHttpsClientProtocols());
        String[] enabledCipherSuites = MirthSSLUtil.getEnabledHttpsCipherSuites((String[])this.configurationController.getHttpsCipherSuites());
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(SSLContexts.createSystemDefault(), enabledProtocols, enabledCipherSuites, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        registry.register("https", (Object)sslConnectionSocketFactory);
    }

    @Override
    public Map<String, Object> getRequestInformation(ServletRequest request) {
        return new HashMap<String, Object>();
    }
}

