/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jdbc;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.connectors.jdbc.Table;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Set;
import java.util.SortedSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/connectors/jdbc")
@Tag(name="Connector Services")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface DatabaseConnectorServletInterface
extends BaseServletInterface {
    public static final String PLUGIN_POINT = "Database Connector Service";

    @POST
    @Path(value="/_getTables")
    @Operation(summary="Executes a query to retrieve database table metadata.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="table_set", ref="../apiexamples/table_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="table_set", ref="../apiexamples/table_set_json")})})
    @MirthOperation(name="getTables", display="Get Tables", type=Operation.ExecuteType.ASYNC, auditable=false)
    public SortedSet<Table> getTables(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @QueryParam(value="channelId") String var1, @Param(value="channelName") @Parameter(description="The name of the channel.", required=true) @QueryParam(value="channelName") String var2, @Param(value="driver") @Parameter(description="The JDBC driver class to use. (ex: org.postgresql.Driver)", required=true) @QueryParam(value="driver") String var3, @Param(value="url") @Parameter(description="The JDBC connection URL to use. (ex: jdbc:postgresql://localhost:5432/mirthdb)", required=true) @QueryParam(value="url") String var4, @Param(value="username") @Parameter(description="The username to authenticate with.") @DefaultValue(value="") @QueryParam(value="username") String var5, @Param(value="password", excludeFromAudit=true) @Parameter(description="The password to authenticate with.", schema=@Schema(format="password")) @DefaultValue(value="") @QueryParam(value="password") String var6, @Param(value="tableNamePatterns") @Parameter(description="If specified, filters by table name. Wildcards (* or %) are allowed.") @QueryParam(value="tableNamePattern") Set<String> var7, @Param(value="selectLimit") @Parameter(description="A simple query to use to retrieve database metadata information.", schema=@Schema(defaultValue="SELECT * FROM ? LIMIT 1")) @DefaultValue(value="SELECT * FROM ? LIMIT 1") @QueryParam(value="selectLimit") String var8, @Param(value="resourceIds") @Parameter(description="Library resource IDs to use, if a custom driver is necessary.") @QueryParam(value="resourceId") Set<String> var9) throws ClientException;
}

