/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.destinationsetfilter;

import com.mirth.connect.client.ui.CenterCellRenderer;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.editors.EditorPanel;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.Step;
import com.mirth.connect.plugins.destinationsetfilter.DestinationSetFilterStep;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class DestinationSetFilterPanel
extends EditorPanel<Step> {
    private ActionListener nameActionListener;
    private JPanel behaviorPanel;
    private JLabel behaviorLabel;
    private JLabel behaviorRemoveLabel;
    private JComboBox<DestinationSetFilterStep.Behavior> behaviorComboBox;
    private JLabel selectAllLabel;
    private JLabel separatorLabel;
    private JLabel deselectAllLabel;
    private JLabel behaviorDestinationsLabel;
    private JLabel destinationsLabel;
    private MirthTable destinationsTable;
    private JScrollPane destinationsScrollPane;
    private JLabel fieldLabel;
    private JTextField fieldField;
    private JLabel conditionLabel;
    private Map<DestinationSetFilterStep.Condition, JRadioButton> conditionRadioMap;
    private JLabel valuesLabel;
    private MirthTable valuesTable;
    private JScrollPane valuesScrollPane;
    private JButton newButton;
    private JButton deleteButton;

    public DestinationSetFilterPanel() {
        this.initComponents();
        this.initLayout();
    }

    public Step getDefaults() {
        return new DestinationSetFilterStep();
    }

    public Step getProperties() {
        DestinationSetFilterStep props = new DestinationSetFilterStep();
        props.setBehavior((DestinationSetFilterStep.Behavior)this.behaviorComboBox.getSelectedItem());
        for (int row = 0; row < this.destinationsTable.getModel().getRowCount(); ++row) {
            if (!((Boolean)this.destinationsTable.getModel().getValueAt(row, 0)).booleanValue()) continue;
            props.getMetaDataIds().add((Integer)this.destinationsTable.getModel().getValueAt(row, 2));
        }
        props.setField(this.fieldField.getText());
        props.setCondition(this.getSelectedCondition());
        props.setValues(this.getValues());
        return props;
    }

    public void setProperties(Step properties) {
        DestinationSetFilterStep props = (DestinationSetFilterStep)properties;
        this.behaviorComboBox.setSelectedItem(props.getBehavior());
        this.resetDestinationTable();
        for (int row = 0; row < this.destinationsTable.getModel().getRowCount(); ++row) {
            boolean selected = props.getMetaDataIds().contains((Integer)this.destinationsTable.getModel().getValueAt(row, 2));
            this.destinationsTable.getModel().setValueAt(selected, row, 0);
        }
        this.fieldField.setText(props.getField());
        this.conditionRadioMap.get(props.getCondition()).setSelected(true);
        this.conditionRadioActionPerformed(props.getCondition());
        this.setValues(props.getValues());
        properties.setName(this.updateName());
    }

    private void resetDestinationTable() {
        List destinations = PlatformUI.MIRTH_FRAME.channelEditPanel.currentChannel.getDestinationConnectors();
        Object[][] data = new Object[destinations.size()][3];
        int i = 0;
        for (Connector destination : destinations) {
            data[i][0] = false;
            data[i][1] = destination.getName();
            data[i][2] = destination.getMetaDataId();
            ++i;
        }
        ((RefreshTableModel)this.destinationsTable.getModel()).refreshDataVector(data);
    }

    public String checkProperties(Step properties, boolean highlight) {
        DestinationSetFilterStep props = (DestinationSetFilterStep)properties;
        Object errors = "";
        if (StringUtils.isBlank((CharSequence)props.getField())) {
            errors = (String)errors + "The field cannot be blank.\n";
            if (highlight) {
                this.fieldField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return errors;
    }

    public void resetInvalidProperties() {
        this.fieldField.setBackground(null);
    }

    public void setNameActionListener(ActionListener actionListener) {
        this.nameActionListener = actionListener;
    }

    public void stopEditing() {
        if (this.destinationsTable.isEditing()) {
            this.destinationsTable.getCellEditor(this.destinationsTable.getEditingRow(), this.destinationsTable.getEditingColumn()).stopCellEditing();
        }
        if (this.valuesTable.isEditing()) {
            this.valuesTable.getCellEditor(this.valuesTable.getEditingRow(), this.valuesTable.getEditingColumn()).stopCellEditing();
        }
    }

    public void setValues(List<String> values) {
        Object[][] tableData = new Object[values.size()][1];
        for (int i = 0; i < values.size(); ++i) {
            tableData[i][0] = values.get(i);
        }
        ((RefreshTableModel)this.valuesTable.getModel()).refreshDataVector(tableData);
    }

    public List<String> getValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < this.valuesTable.getRowCount(); ++i) {
            if (((String)this.valuesTable.getValueAt(i, 0)).length() <= 0) continue;
            values.add((String)this.valuesTable.getValueAt(i, 0));
        }
        return values;
    }

    public void deselectRows() {
        this.valuesTable.clearSelection();
        this.deleteButton.setEnabled(false);
    }

    public int getSelectedRow() {
        if (this.valuesTable.isEditing()) {
            return this.valuesTable.getEditingRow();
        }
        return this.valuesTable.getSelectedRow();
    }

    private void setValuesEnabled(boolean enabled) {
        if (this.valuesTable.isEditing()) {
            this.valuesTable.getCellEditor().stopCellEditing();
        }
        this.valuesScrollPane.setEnabled(enabled);
        this.valuesTable.setEnabled(enabled);
        this.valuesLabel.setEnabled(enabled);
        this.newButton.setEnabled(enabled);
        this.deselectRows();
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.behaviorPanel = new JPanel();
        this.behaviorPanel.setBackground(this.getBackground());
        this.behaviorLabel = new JLabel("Behavior:");
        this.behaviorRemoveLabel = new JLabel("Remove");
        this.behaviorComboBox = new JComboBox<DestinationSetFilterStep.Behavior>(DestinationSetFilterStep.Behavior.values());
        this.behaviorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DestinationSetFilterPanel.this.behaviorComboBoxActionPerformed();
            }
        });
        this.behaviorDestinationsLabel = new JLabel(" destinations:");
        this.selectAllLabel = new JLabel("<html><u>Select All</u></html>");
        this.selectAllLabel.setForeground(Color.BLUE);
        this.selectAllLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.selectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (((Component)evt.getSource()).isEnabled()) {
                    DestinationSetFilterPanel.this.setDestinationsSelected(true);
                }
            }
        });
        this.separatorLabel = new JLabel("|");
        this.deselectAllLabel = new JLabel("<html><u>Deselect All</u></html>");
        this.deselectAllLabel.setForeground(Color.BLUE);
        this.deselectAllLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.deselectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (((Component)evt.getSource()).isEnabled()) {
                    DestinationSetFilterPanel.this.setDestinationsSelected(false);
                }
            }
        });
        this.destinationsLabel = new JLabel("Destinations:");
        this.destinationsTable = new MirthTable();
        this.destinationsTable.setModel((TableModel)new RefreshTableModel(new String[]{"", "Name", "Id"}, 0){

            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }
        });
        this.destinationsTable.setRowSelectionAllowed(false);
        this.destinationsTable.setRowHeight(20);
        this.destinationsTable.setDragEnabled(false);
        this.destinationsTable.setOpaque(true);
        this.destinationsTable.setSortable(false);
        this.destinationsTable.setFocusable(false);
        this.destinationsTable.getTableHeader().setReorderingAllowed(false);
        this.destinationsTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.destinationsTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.destinationsTable.getColumnExt(0).setMinWidth(18);
        this.destinationsTable.getColumnExt(0).setMaxWidth(18);
        this.destinationsTable.getColumnExt(2).setMinWidth(30);
        this.destinationsTable.getColumnExt(2).setMaxWidth(30);
        this.destinationsTable.getColumnExt(2).setCellRenderer((TableCellRenderer)new CenterCellRenderer());
        this.destinationsScrollPane = new JScrollPane((Component)this.destinationsTable);
        this.fieldLabel = new JLabel("Field:");
        this.fieldField = new JTextField();
        this.fieldField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.documentChanged(evt);
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.documentChanged(evt);
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                this.documentChanged(evt);
            }

            private void documentChanged(DocumentEvent evt) {
                try {
                    DestinationSetFilterPanel.this.updateName(evt.getDocument().getText(0, evt.getDocument().getLength()));
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        });
        this.conditionLabel = new JLabel("Condition:");
        this.conditionRadioMap = new LinkedHashMap<DestinationSetFilterStep.Condition, JRadioButton>();
        ButtonGroup conditionButtonGroup = new ButtonGroup();
        for (final DestinationSetFilterStep.Condition condition : DestinationSetFilterStep.Condition.values()) {
            JRadioButton radio = new JRadioButton(condition.toString());
            radio.setBackground(this.getBackground());
            radio.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DestinationSetFilterPanel.this.conditionRadioActionPerformed(condition);
                }
            });
            conditionButtonGroup.add(radio);
            this.conditionRadioMap.put(condition, radio);
        }
        this.valuesLabel = new JLabel("Values:");
        this.valuesTable = new MirthTable();
        this.valuesTable.setModel((TableModel)new RefreshTableModel(new String[]{"Value"}, 0){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{true};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.valuesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DestinationSetFilterPanel.this.deleteButton.setEnabled(DestinationSetFilterPanel.this.getSelectedRow() >= 0);
            }
        });
        class RegExTableCellEditor
        extends TextFieldCellEditor {
            RegExTableCellEditor() {
            }

            public boolean stopCellEditing() {
                DestinationSetFilterPanel.this.deleteButton.setEnabled(true);
                return super.stopCellEditing();
            }

            public boolean isCellEditable(EventObject evt) {
                boolean editable = super.isCellEditable(evt);
                if (editable) {
                    DestinationSetFilterPanel.this.deleteButton.setEnabled(false);
                }
                return editable;
            }

            protected boolean valueChanged(String value) {
                return true;
            }
        }
        this.valuesTable.getColumnExt(0).setCellEditor((TableCellEditor)((Object)new RegExTableCellEditor()));
        this.valuesTable.setCustomEditorControls(true);
        this.valuesTable.setSelectionMode(0);
        this.valuesTable.setRowSelectionAllowed(true);
        this.valuesTable.setRowHeight(20);
        this.valuesTable.setDragEnabled(false);
        this.valuesTable.setOpaque(true);
        this.valuesTable.setSortable(false);
        this.valuesTable.getTableHeader().setReorderingAllowed(false);
        this.valuesTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.valuesTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.valuesTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DestinationSetFilterPanel.this.updateName();
                    }
                });
            }
        });
        this.valuesScrollPane = new JScrollPane((Component)this.valuesTable);
        this.valuesScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DestinationSetFilterPanel.this.deselectRows();
            }
        });
        this.newButton = new JButton("New");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DestinationSetFilterPanel.this.newButtonActionPerformed(evt);
            }
        });
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DestinationSetFilterPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setEnabled(false);
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, fill, gap 6"));
        this.add(this.behaviorLabel, "right, gapafter 6");
        this.behaviorPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 6"));
        this.behaviorPanel.add((Component)this.behaviorRemoveLabel, "split 3");
        this.behaviorPanel.add(this.behaviorComboBox);
        this.behaviorPanel.add(this.behaviorDestinationsLabel);
        this.behaviorPanel.add((Component)this.selectAllLabel, "right, split 3");
        this.behaviorPanel.add(this.separatorLabel);
        this.behaviorPanel.add((Component)this.deselectAllLabel, "gapafter 3");
        this.add(this.behaviorPanel, "growx, sx");
        this.add(this.destinationsLabel, "newline, top, right, gapafter 6");
        this.add(this.destinationsScrollPane, "grow, sx, h :80");
        this.add(this.fieldLabel, "newline, right, gapafter 6");
        this.add(this.fieldField, "sx, growx");
        this.add(this.conditionLabel, "newline, right, gapafter 6");
        for (JRadioButton radio : this.conditionRadioMap.values()) {
            this.add(radio, "split " + this.conditionRadioMap.size());
        }
        this.add(this.valuesLabel, "newline, top, right, gapafter 6");
        this.add(this.valuesScrollPane, "grow, push, sy, h :80");
        this.add(this.newButton, "top, flowy, split 2, sgx");
        this.add(this.deleteButton, "top, sgx");
    }

    private void behaviorComboBoxActionPerformed() {
        boolean removeAll = (DestinationSetFilterStep.Behavior)this.behaviorComboBox.getSelectedItem() == DestinationSetFilterStep.Behavior.REMOVE_ALL;
        this.destinationsLabel.setEnabled(!removeAll);
        this.destinationsTable.setEnabled(!removeAll);
        this.selectAllLabel.setEnabled(!removeAll);
        this.separatorLabel.setEnabled(!removeAll);
        this.deselectAllLabel.setEnabled(!removeAll);
        if (removeAll) {
            this.setDestinationsSelected(true);
        }
    }

    private void setDestinationsSelected(boolean selected) {
        for (int row = 0; row < this.destinationsTable.getModel().getRowCount(); ++row) {
            this.destinationsTable.getModel().setValueAt(selected, row, 0);
        }
    }

    private void conditionRadioActionPerformed(DestinationSetFilterStep.Condition condition) {
        this.setValuesEnabled(condition.isValuesEnabled());
        this.updateName(condition);
    }

    private DestinationSetFilterStep.Condition getSelectedCondition() {
        for (Map.Entry<DestinationSetFilterStep.Condition, JRadioButton> entry : this.conditionRadioMap.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            return entry.getKey();
        }
        return DestinationSetFilterStep.Condition.values()[0];
    }

    private String updateName() {
        return this.updateName(this.fieldField.getText(), this.getSelectedCondition());
    }

    private String updateName(String fieldText) {
        return this.updateName(fieldText, this.getSelectedCondition());
    }

    private String updateName(DestinationSetFilterStep.Condition condition) {
        return this.updateName(this.fieldField.getText(), condition);
    }

    private String updateName(String fieldText, DestinationSetFilterStep.Condition condition) {
        StringBuilder builder = new StringBuilder("Filter destination(s) if \"").append(fieldText).append("\" ");
        if (condition.isValuesEnabled()) {
            boolean first = true;
            for (String value : this.getValues()) {
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                if (first) {
                    builder.append(condition.getPresentTense()).append(' ');
                } else {
                    builder.append(" or ");
                }
                builder.append(value);
                first = false;
            }
            if (first) {
                if (condition == DestinationSetFilterStep.Condition.EQUALS) {
                    builder.append("is blank");
                } else if (condition == DestinationSetFilterStep.Condition.NOT_EQUAL) {
                    builder.append("is not blank");
                } else {
                    builder.append(condition.getPresentTense()).append(" \"\"");
                }
            }
        } else {
            builder.append(condition.getPresentTense());
        }
        String name = builder.toString();
        if (this.nameActionListener != null) {
            this.nameActionListener.actionPerformed(new ActionEvent((Object)this, 1001, name));
        }
        return name;
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.getSelectedRow();
        if (selectedRow >= 0 && !this.valuesTable.isEditing()) {
            ((RefreshTableModel)this.valuesTable.getModel()).removeRow(this.valuesTable.convertRowIndexToModel(selectedRow));
            if (this.valuesTable.getRowCount() > 0) {
                if (selectedRow < this.valuesTable.getRowCount()) {
                    this.valuesTable.setRowSelectionInterval(selectedRow, selectedRow);
                } else {
                    this.valuesTable.setRowSelectionInterval(this.valuesTable.getRowCount() - 1, this.valuesTable.getRowCount() - 1);
                }
            }
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        ((RefreshTableModel)this.valuesTable.getModel()).addRow(new Object[]{""});
        this.valuesTable.setRowSelectionInterval(this.valuesTable.getRowCount() - 1, this.valuesTable.getRowCount() - 1);
    }
}

