/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.edi;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.model.datatype.DataTypePropertyDescriptor;
import com.mirth.connect.model.datatype.PropertyEditorType;
import com.mirth.connect.model.datatype.SerializationProperties;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class EDISerializationProperties
extends SerializationProperties {
    private String segmentDelimiter = "~";
    private String elementDelimiter = "*";
    private String subelementDelimiter = ":";
    private boolean inferX12Delimiters = true;

    public EDISerializationProperties() {
    }

    public EDISerializationProperties(EDISerializationProperties properties) {
        this.segmentDelimiter = properties.getSegmentDelimiter();
        this.elementDelimiter = properties.getElementDelimiter();
        this.subelementDelimiter = properties.getSubelementDelimiter();
        this.inferX12Delimiters = properties.isInferX12Delimiters();
    }

    public Map<String, DataTypePropertyDescriptor> getPropertyDescriptors() {
        LinkedHashMap<String, DataTypePropertyDescriptor> properties = new LinkedHashMap<String, DataTypePropertyDescriptor>();
        properties.put("segmentDelimiter", new DataTypePropertyDescriptor((Object)this.segmentDelimiter, "Segment Delimiter", "Characters that delimit the segments in the message.", PropertyEditorType.STRING));
        properties.put("elementDelimiter", new DataTypePropertyDescriptor((Object)this.elementDelimiter, "Element Delimiter", "Characters that delimit the elements in the message.", PropertyEditorType.STRING));
        properties.put("subelementDelimiter", new DataTypePropertyDescriptor((Object)this.subelementDelimiter, "Subelement Delimiter", "Characters that delimit the subelements in the message.", PropertyEditorType.STRING));
        properties.put("inferX12Delimiters", new DataTypePropertyDescriptor((Object)this.inferX12Delimiters, "Infer X12 Delimiters", "This property only applies to X12 messages. If checked, the delimiters are inferred from the incoming message and the delimiter properties will not be used. ", PropertyEditorType.BOOLEAN));
        return properties;
    }

    public void setProperties(Map<String, Object> properties) {
        if (properties != null) {
            if (properties.get("segmentDelimiter") != null) {
                this.segmentDelimiter = (String)properties.get("segmentDelimiter");
            }
            if (properties.get("elementDelimiter") != null) {
                this.elementDelimiter = (String)properties.get("elementDelimiter");
            }
            if (properties.get("subelementDelimiter") != null) {
                this.subelementDelimiter = (String)properties.get("subelementDelimiter");
            }
            if (properties.get("inferX12Delimiters") != null) {
                this.inferX12Delimiters = (Boolean)properties.get("inferX12Delimiters");
            }
        }
    }

    public String getSegmentDelimiter() {
        return this.segmentDelimiter;
    }

    public void setSegmentDelimiter(String segmentDelimiter) {
        this.segmentDelimiter = segmentDelimiter;
    }

    public String getElementDelimiter() {
        return this.elementDelimiter;
    }

    public void setElementDelimiter(String elementDelimiter) {
        this.elementDelimiter = elementDelimiter;
    }

    public String getSubelementDelimiter() {
        return this.subelementDelimiter;
    }

    public void setSubelementDelimiter(String subelementDelimiter) {
        this.subelementDelimiter = subelementDelimiter;
    }

    public boolean isInferX12Delimiters() {
        return this.inferX12Delimiters;
    }

    public void setInferX12Delimiters(boolean inferX12Delimiters) {
        this.inferX12Delimiters = inferX12Delimiters;
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("inferX12Delimiters", this.inferX12Delimiters);
        return purgedProperties;
    }
}

