/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datapruner;

import com.mirth.connect.donkey.model.channel.PollConnectorProperties;
import com.mirth.connect.donkey.util.PollConnectorJobHandler;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.plugins.datapruner.DataPruner;
import com.mirth.connect.plugins.datapruner.DataPrunerController;
import com.mirth.connect.plugins.datapruner.DataPrunerException;
import com.mirth.connect.plugins.datapruner.DataPrunerInterface;
import com.mirth.connect.plugins.datapruner.DataPrunerJob;
import com.mirth.connect.plugins.datapruner.DataPrunerStatus;
import com.mirth.connect.util.messagewriter.MessageWriterOptions;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.Scheduler;

public class DefaultDataPrunerController
extends DataPrunerController {
    private static final int MIN_PRUNING_BLOCK_SIZE = 50;
    private static final int MAX_PRUNING_BLOCK_SIZE = 10000;
    private static final int MAX_ARCHIVING_BLOCK_SIZE = 1000;
    private static final String DATE_FORMAT = "MM/dd/yyyy hh:mm aa";
    public static DataPruner pruner = new DataPruner();
    private boolean isEnabled;
    private Scheduler scheduler;
    private PollConnectorJobHandler handler;
    private ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
    private boolean isPrunerInterfaceRegistered = false;
    private Logger logger = LogManager.getLogger(this.getClass());

    @Override
    public void init(Properties properties) throws DataPrunerException {
        try {
            this.applyPrunerSettings(properties);
            this.handler = new PollConnectorJobHandler(pruner.getPollingProperties(), "DataPruner", false);
            this.handler.configureJob(DataPrunerJob.class, null, "DataPruner");
            if (!this.isEnabled) {
                this.logger.debug("Data pruner disabled");
            } else {
                this.handler.scheduleJob(false);
                this.scheduler = this.handler.getScheduler();
                this.logger.debug("Scheduling data pruner job");
            }
        }
        catch (Exception e) {
            throw new DataPrunerException(e);
        }
    }

    @Override
    public void update(Properties properties) throws DataPrunerException {
        try {
            if (this.scheduler != null && this.scheduler.checkExists(this.handler.getJob().getKey())) {
                this.stop(true);
            }
            this.applyPrunerSettings(properties);
            this.handler = new PollConnectorJobHandler(pruner.getPollingProperties(), "DataPruner", false);
            this.handler.configureJob(DataPrunerJob.class, null, "DataPruner");
            if (this.isEnabled) {
                this.handler.scheduleJob(true);
                this.scheduler = this.handler.getScheduler();
                this.logger.debug("Scheduled job to " + this.handler.getNextFireTime());
            }
        }
        catch (Exception e) {
            throw new DataPrunerException(e);
        }
    }

    @Override
    public void start() throws DataPrunerException {
        if (this.scheduler != null) {
            try {
                this.scheduler.start();
            }
            catch (Exception e) {
                throw new DataPrunerException(e);
            }
        }
    }

    @Override
    public void stop(boolean waitForJobsToComplete) throws DataPrunerException {
        if (this.scheduler != null) {
            try {
                this.scheduler.shutdown(waitForJobsToComplete);
                this.scheduler = null;
            }
            catch (Exception e) {
                throw new DataPrunerException(e);
            }
        }
    }

    @Override
    public boolean isStarted() throws DataPrunerException {
        try {
            return this.scheduler != null && this.scheduler.isStarted();
        }
        catch (Exception e) {
            throw new DataPrunerException(e);
        }
    }

    @Override
    public void startPruner() {
        pruner.start();
    }

    @Override
    public void stopPruner() throws InterruptedException {
        pruner.stop();
    }

    @Override
    public DataPrunerStatus getPrunerStatus() {
        return pruner.getPrunerStatus();
    }

    @Override
    public boolean isPrunerRunning() throws DataPrunerException {
        return pruner.isRunning();
    }

    @Override
    public Map<String, String> getStatusMap() {
        HashMap<String, String> statusMap = new HashMap<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        DataPrunerStatus status = pruner.getPrunerStatus();
        if (pruner.isRunning()) {
            statusMap.put("isRunning", "true");
            if (status.isArchiving()) {
                stringBuilder.append("Archiving");
            } else if (status.isPruning()) {
                stringBuilder.append("Pruning");
            } else if (status.isPruningEvents()) {
                stringBuilder.append("Pruning events");
            } else {
                stringBuilder.append("Processing");
            }
            if (status.getCurrentChannelName() != null) {
                stringBuilder.append(" channel \"" + status.getCurrentChannelName() + "\"");
                if (status.isArchiving()) {
                    int count;
                    stringBuilder.append(", " + count + " message" + ((count = pruner.getNumExported()) != 1 ? "s" : "") + " archived");
                }
                stringBuilder.append(", " + this.getElapsedTimeText(status.getTaskStartTime(), Calendar.getInstance()) + " elapsed");
            }
            statusMap.put("currentState", stringBuilder.toString());
            int processedCount = status.getProcessedChannelIds().size();
            int failedCount = status.getFailedChannelIds().size();
            int totalCount = status.getPendingChannelIds().size() + processedCount + failedCount;
            stringBuilder = new StringBuilder();
            stringBuilder.append("Initiated " + new SimpleDateFormat(DATE_FORMAT).format(status.getStartTime().getTime()));
            stringBuilder.append(", " + processedCount + " of " + totalCount + " channel" + (totalCount == 1 ? "" : "s") + " processed");
            if (failedCount > 0) {
                stringBuilder.append(", " + failedCount + " channel" + (failedCount == 1 ? "" : "s") + " failed");
            }
            stringBuilder.append(", " + this.getElapsedTimeText(status.getStartTime(), Calendar.getInstance()) + " elapsed");
            statusMap.put("currentProcess", stringBuilder.toString());
        } else {
            statusMap.put("isRunning", "false");
            statusMap.put("currentState", "Not running");
            statusMap.put("currentProcess", "-");
        }
        DataPrunerStatus lastStatus = pruner.getLastPrunerStatus();
        if (lastStatus == null) {
            statusMap.put("lastProcess", "-");
        } else {
            stringBuilder = new StringBuilder();
            int processedCount = lastStatus.getProcessedChannelIds().size();
            int failedCount = lastStatus.getFailedChannelIds().size();
            int totalCount = lastStatus.getPendingChannelIds().size() + processedCount + failedCount;
            int skippedCount = totalCount - processedCount - failedCount;
            stringBuilder.append("Initiated " + new SimpleDateFormat(DATE_FORMAT).format(lastStatus.getStartTime().getTime()));
            stringBuilder.append(", " + processedCount + " of " + totalCount + " channel" + (totalCount == 1 ? "" : "s") + " processed");
            if (failedCount > 0) {
                stringBuilder.append(", " + failedCount + " channel" + (failedCount == 1 ? "" : "s") + " failed");
            }
            if (skippedCount > 0) {
                stringBuilder.append(", " + skippedCount + " channel" + (skippedCount == 1 ? "" : "s") + " skipped");
            }
            stringBuilder.append(", " + this.getElapsedTimeText(lastStatus.getStartTime(), lastStatus.getEndTime()) + " duration");
            statusMap.put("lastProcess", stringBuilder.toString());
        }
        statusMap.put("nextProcess", "Not scheduled");
        String nextFireTime = this.handler.getNextFireTime();
        if (!StringUtils.isEmpty((CharSequence)nextFireTime)) {
            statusMap.put("nextProcess", "Scheduled " + nextFireTime);
        }
        return statusMap;
    }

    private void applyPrunerSettings(Properties properties) {
        if (StringUtils.isNotEmpty((CharSequence)properties.getProperty("pruningBlockSize"))) {
            int blockSize = NumberUtils.toInt((String)properties.getProperty("pruningBlockSize"));
            if (blockSize < 50) {
                blockSize = 50;
            } else if (blockSize > 10000) {
                blockSize = 1000;
            }
            pruner.setPrunerBlockSize(blockSize);
        } else {
            pruner.setPrunerBlockSize(1000);
        }
        this.isEnabled = Boolean.parseBoolean(properties.getProperty("enabled"));
        if (properties.containsKey("pollingProperties")) {
            pruner.setPollingProperties((PollConnectorProperties)this.serializer.deserialize(properties.getProperty("pollingProperties"), PollConnectorProperties.class));
        } else {
            PollConnectorProperties defaultProperties = new PollConnectorProperties();
            defaultProperties.setPollingFrequency(3600000);
            pruner.setPollingProperties(defaultProperties);
        }
        pruner.setArchiveEnabled(Boolean.parseBoolean(properties.getProperty("archiveEnabled", Boolean.FALSE.toString())));
        if (pruner.isArchiveEnabled()) {
            if (properties.contains("archiverOptions")) {
                pruner.setArchiverOptions(new MessageWriterOptions());
            } else {
                pruner.setArchiverOptions((MessageWriterOptions)this.serializer.deserialize(properties.getProperty("archiverOptions"), MessageWriterOptions.class));
            }
        }
        if (Boolean.parseBoolean(properties.getProperty("pruneEvents", Boolean.FALSE.toString()))) {
            pruner.setPruneEvents(true);
            pruner.setMaxEventAge(Integer.parseInt(properties.getProperty("maxEventAge")));
        } else {
            pruner.setPruneEvents(false);
            pruner.setMaxEventAge(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)properties.getProperty("archiverBlockSize"))) {
            int blockSize = NumberUtils.toInt((String)properties.getProperty("archiverBlockSize"));
            if (blockSize <= 0 || blockSize > 1000) {
                blockSize = 50;
            }
            pruner.setArchiverBlockSize(blockSize);
        } else {
            pruner.setArchiverBlockSize(50);
        }
    }

    private String getElapsedTimeText(Calendar startTime, Calendar endTime) {
        long minsElapsed;
        return minsElapsed + " minute" + ((minsElapsed = (endTime.getTimeInMillis() - startTime.getTimeInMillis()) / 60000L) != 1L ? "s" : "");
    }

    @Override
    public void registerPrunerListener(DataPrunerInterface dataPrunerInterface) {
        pruner.registerDataPrunerInterface(dataPrunerInterface);
        this.setPrunerInterfaceRegistered(true);
    }

    public DataPruner getPruner() {
        return pruner;
    }

    public boolean isPrunerInterfaceRegistered() {
        return this.isPrunerInterfaceRegistered;
    }

    public void setPrunerInterfaceRegistered(boolean isPrunerInterfaceRegistered) {
        this.isPrunerInterfaceRegistered = isPrunerInterfaceRegistered;
    }
}

