/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.dialog;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.UIConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class AdvancedSearchCodeSnippetDialog
extends MirthDialog {
    private JLabel snippetLabel;
    private RSyntaxTextArea snippetTextArea;
    private RTextScrollPane snippetScrollPane;
    private JButton copyButton;
    private JButton closeButton;
    private Frame parent;
    private String snippet;

    public AdvancedSearchCodeSnippetDialog(Frame frame, String string) {
        super((Window)frame, true);
        this.parent = frame;
        this.snippet = string != null ? string : "";
        this.initComponents();
        this.initLayout();
        this.setDefaultCloseOperation(2);
        this.setTitle("Advanced Search Code Snippet");
        this.setPreferredSize(new Dimension(800, 600));
        this.pack();
        this.setLocationRelativeTo((Component)frame);
        this.setVisible(true);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        this.snippetLabel = new JLabel("Code Snippet:");
        this.snippetTextArea = new RSyntaxTextArea(20, 60);
        this.snippetTextArea.setSyntaxEditingStyle("text/javascript");
        this.snippetTextArea.setCodeFoldingEnabled(true);
        this.snippetTextArea.setAntiAliasingEnabled(true);
        this.snippetTextArea.setEditable(true);
        this.snippetTextArea.setText(this.snippet);
        this.snippetScrollPane = new RTextScrollPane((Component)this.snippetTextArea);
        this.snippetScrollPane.setVerticalScrollBarPolicy(20);
        this.snippetScrollPane.setHorizontalScrollBarPolicy(30);
        this.snippetScrollPane.setFoldIndicatorEnabled(true);
        this.copyButton = new JButton("Copy");
        this.copyButton.addActionListener(actionEvent -> this.copyToClipboard());
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(actionEvent -> this.close());
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, hidemode 0, align center, insets 0 0 0 0, fill", "25[right][grow,fill]", ""));
        jPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add((Component)this.snippetLabel, "right");
        jPanel.add((Component)this.snippetScrollPane, "wmin 300, hmin 200, grow, push");
        this.add(jPanel, "grow, push");
        this.add(new JSeparator(), "newline, sx, growx");
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel2.add(this.copyButton);
        jPanel2.add(this.closeButton);
        this.add(jPanel2, "newline, sx, growx");
    }

    private void copyToClipboard() {
        StringSelection stringSelection = new StringSelection(this.snippetTextArea.getText());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        JOptionPane.showMessageDialog((Component)((Object)this), "Code snippet copied to clipboard.", "Copied", 1);
    }

    private void close() {
        this.dispose();
    }
}

