/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.dialog;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupProperties;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupSettingDialog
extends MirthDialog {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private JCheckBox pruneEnabledCheck;
    private JSpinner retentionDaysSpinner;
    private JLabel retentionDaysLabel;
    private JButton saveButton;
    private JButton cancelButton;
    private Frame parent;
    private LookupProperties currentProperties;

    public LookupSettingDialog(Frame frame) {
        super((Window)frame, true);
        this.parent = frame;
        this.initComponents();
        this.initLayout();
        this.setDefaultCloseOperation(2);
        this.setTitle("Lookup Settings");
        this.pack();
        this.setLocationRelativeTo((Component)frame);
        this.loadSettingsFromServer();
        this.setVisible(true);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        this.pruneEnabledCheck = new JCheckBox("Enabled");
        this.pruneEnabledCheck.setOpaque(false);
        this.pruneEnabledCheck.setSelected(false);
        this.pruneEnabledCheck.addActionListener(actionEvent -> this.handlePruneEnabledChanged());
        this.retentionDaysLabel = new JLabel("Retention days:");
        this.retentionDaysSpinner = new JSpinner(new SpinnerNumberModel(30, 1, 3650, 1));
        this.retentionDaysSpinner.setEnabled(this.pruneEnabledCheck.isSelected());
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(actionEvent -> this.save());
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(actionEvent -> this.close());
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, hidemode 0, align center, insets 0 0 0 0, fill", "25[right][grow,fill]"));
        jPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add((Component)new JLabel("Purge Old Audit History:"), "gapbottom 8");
        jPanel.add((Component)this.pruneEnabledCheck, "wrap, gapbottom 8");
        jPanel.add((Component)this.retentionDaysLabel, "gapbottom 8");
        jPanel.add((Component)this.retentionDaysSpinner, "wrap, w 60!, gapbottom 8");
        this.add(jPanel, "grow, push");
        this.add(new JSeparator(), "newline, sx, growx");
        this.add(this.saveButton, "newline, sx, right, split 2");
        this.add(this.cancelButton);
    }

    private void save() {
        boolean bl = this.pruneEnabledCheck.isSelected();
        int n = (Integer)this.retentionDaysSpinner.getValue();
        if (bl && n < 1) {
            this.showError("Retention days must be >= 1 when purge is enabled.");
            return;
        }
        if (this.currentProperties == null) {
            this.currentProperties = LookupProperties.getDefault();
        }
        LookupProperties lookupProperties = this.currentProperties;
        lookupProperties.setAuditPruneEnabled(bl);
        lookupProperties.setAuditPruneRetentionDays(n);
        this.saveButton.setEnabled(false);
        this.pruneEnabledCheck.setEnabled(false);
        this.retentionDaysSpinner.setEnabled(false);
        try {
            this.parent.mirthClient.setPluginProperties("Lookup Table Management System", lookupProperties.toAuditPruneProperties(), true);
            this.close();
        }
        catch (Exception exception) {
            this.logger.error("Unexpected error while saving settings", (Throwable)exception);
            this.showError("Unexpected error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage());
            return;
        }
    }

    private void close() {
        this.dispose();
    }

    private void loadSettingsFromServer() {
        this.pruneEnabledCheck.setEnabled(false);
        this.retentionDaysSpinner.setEnabled(false);
        this.saveButton.setEnabled(false);
        SwingWorker<LookupProperties, Void> swingWorker = new SwingWorker<LookupProperties, Void>(){

            @Override
            public LookupProperties doInBackground() throws Exception {
                Properties properties = LookupSettingDialog.this.parent.mirthClient.getPluginProperties("Lookup Table Management System");
                return LookupProperties.fromProperties((Properties)properties);
            }

            @Override
            public void done() {
                try {
                    LookupSettingDialog.this.currentProperties = (LookupProperties)this.get();
                }
                catch (Exception exception) {
                    LookupSettingDialog.this.showError("Failed to load settings.\n" + exception.getMessage());
                    LookupSettingDialog.this.currentProperties = LookupProperties.getDefault();
                }
                finally {
                    LookupSettingDialog.this.pruneEnabledCheck.setEnabled(true);
                    LookupSettingDialog.this.retentionDaysSpinner.setEnabled(LookupSettingDialog.this.pruneEnabledCheck.isSelected());
                    LookupSettingDialog.this.saveButton.setEnabled(true);
                    LookupSettingDialog.this.applyPropertiesToUI(LookupSettingDialog.this.currentProperties);
                }
            }
        };
        swingWorker.execute();
    }

    private void applyPropertiesToUI(LookupProperties lookupProperties) {
        if (lookupProperties == null) {
            lookupProperties = LookupProperties.getDefault();
        }
        boolean bl = lookupProperties.isAuditPruneEnabled();
        int n = lookupProperties.getAuditPruneRetentionDays();
        this.pruneEnabledCheck.setSelected(bl);
        this.retentionDaysSpinner.setValue(Math.max(1, n));
        this.handlePruneEnabledChanged();
    }

    private void handlePruneEnabledChanged() {
        boolean bl = this.pruneEnabledCheck.isSelected();
        this.retentionDaysSpinner.setEnabled(bl);
        this.retentionDaysLabel.setEnabled(bl);
    }

    protected void showInformation(String string) {
        PlatformUI.MIRTH_FRAME.alertInformation((Component)((Object)this), string);
    }

    protected void showError(String string) {
        PlatformUI.MIRTH_FRAME.alertError((Component)((Object)this), string);
    }
}

