/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.model;

import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.GroupAuditEntriesResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class LookupAuditTableModel
extends AbstractTableModel {
    private final String[] columnNames = new String[]{"Key", "Action", "Old Value", "New Value", "User", "Timestamp"};
    private final List<GroupAuditEntriesResponse.AuditEntryResponse> values = new ArrayList<GroupAuditEntriesResponse.AuditEntryResponse>();
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public int getRowCount() {
        return this.values.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        GroupAuditEntriesResponse.AuditEntryResponse auditEntryResponse = this.values.get(n);
        switch (n2) {
            case 0: {
                return auditEntryResponse.getKeyValue();
            }
            case 1: {
                return auditEntryResponse.getAction();
            }
            case 2: {
                return auditEntryResponse.getOldValue();
            }
            case 3: {
                return auditEntryResponse.getNewValue();
            }
            case 4: {
                return auditEntryResponse.getUserName();
            }
            case 5: {
                Date date = auditEntryResponse.getTimestamp();
                return date != null ? this.formatter.format(date) : "";
            }
        }
        return null;
    }

    public GroupAuditEntriesResponse.AuditEntryResponse getValue(int n) {
        return this.values.get(n);
    }

    public void setValues(List<GroupAuditEntriesResponse.AuditEntryResponse> list) {
        this.values.clear();
        this.values.addAll(list);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.values.clear();
        this.fireTableDataChanged();
    }
}

