/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.panel;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.plugins.dynamiclookup.client.panel.NoGroupSelectedPanel;
import com.mirth.connect.plugins.dynamiclookup.shared.constant.LookupConstants;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroupExtra;
import com.mirth.connect.plugins.dynamiclookup.shared.util.JsonUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DetailsPanel
extends JPanel {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm a");
    private final Frame parent = PlatformUI.MIRTH_FRAME;
    private JPanel noGroupSelectedPanel;
    private JPanel contentPanel;
    private JTextArea detailsTextArea;
    private LookupGroup selectedGroup;

    public DetailsPanel() {
        this.initComponents();
        this.initLayout();
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.noGroupSelectedPanel = new NoGroupSelectedPanel();
        this.detailsTextArea = new JTextArea();
        this.detailsTextArea.setEditable(false);
        this.detailsTextArea.setFont(new Font("Monospaced", 0, 12));
        this.detailsTextArea.setBackground(UIConstants.BACKGROUND_COLOR);
        this.detailsTextArea.setLineWrap(false);
        this.detailsTextArea.setWrapStyleWord(false);
        this.detailsTextArea.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
    }

    private void initLayout() {
        this.setLayout(new CardLayout());
        this.contentPanel = new JPanel((LayoutManager)new MigLayout("insets 8, wrap 1, fillx", "[grow]", "[]"));
        this.contentPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        JScrollPane jScrollPane = new JScrollPane(this.detailsTextArea);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setPreferredSize(new Dimension(600, 300));
        this.contentPanel.add((Component)jScrollPane, "aligny top, growx, wrap");
        this.add((Component)this.contentPanel, "content");
        this.add((Component)this.noGroupSelectedPanel, "noGroup");
    }

    public void updateDetails(LookupGroup lookupGroup) {
        boolean bl = lookupGroup != null;
        this.contentPanel.setVisible(bl);
        this.noGroupSelectedPanel.setVisible(!bl);
        this.selectedGroup = lookupGroup;
        if (bl) {
            this.refreshUI();
        }
    }

    private void refreshUI() {
        Object object;
        if (this.selectedGroup == null) {
            this.detailsTextArea.setText("");
            return;
        }
        String string = String.format("%-20s: %s%n%-20s: %s%n%-20s: %s%n%-20s: %s%n%-20s: %s%n%-20s: %s%n%-20s: %s%n%-20s: %s%n", "ID", this.selectedGroup.getId(), "Name", this.selectedGroup.getName(), "Description", this.selectedGroup.getDescription() != null ? this.selectedGroup.getDescription() : "", "Version", this.selectedGroup.getVersion() != null ? this.selectedGroup.getVersion() : "", "Cache Size", this.selectedGroup.getCacheSize(), "Cache Policy", this.selectedGroup.getCachePolicy() != null ? this.selectedGroup.getCachePolicy() : "", "Statistics Enabled", this.selectedGroup.isStatisticsEnabled() ? "Yes" : "No", "Value Type", this.selectedGroup.getValueType() != null ? this.selectedGroup.getValueType() : "TEXT");
        Object object2 = string;
        if (LookupConstants.isJsonValueType((String)this.selectedGroup.getValueType())) {
            object = this.selectedGroup.getExtra();
            String string2 = this.buildExtraDetails((LookupGroupExtra)object);
            object2 = (String)object2 + string2;
        }
        object = String.format("%-20s: %s%n%-20s: %s%n", "Created Date", this.formatter.format(this.selectedGroup.getCreatedDate()), "Updated Date", this.formatter.format(this.selectedGroup.getUpdatedDate()));
        object2 = (String)object2 + (String)object;
        this.detailsTextArea.setText((String)object2);
    }

    private String buildExtraDetails(LookupGroupExtra lookupGroupExtra) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = lookupGroupExtra != null && lookupGroupExtra.getJsonIndexMode() != null ? lookupGroupExtra.getJsonIndexMode() : "NONE";
        stringBuilder.append(String.format("%-20s: %s%n", "JSON Index", string));
        if (LookupConstants.isFieldMode((String)string) && lookupGroupExtra != null && lookupGroupExtra.getIndexedJsonFields() != null) {
            String string2 = "";
            try {
                List list = (List)JsonUtils.getMapper().readValue(lookupGroupExtra.getIndexedJsonFields(), (TypeReference)new TypeReference<List<String>>(){});
                if (!list.isEmpty()) {
                    string2 = String.join((CharSequence)", ", list);
                }
            }
            catch (Exception exception) {
                string2 = "(invalid JSON)";
            }
            if (!string2.isEmpty()) {
                stringBuilder.append(String.format("%-20s: %s%n", "Index JSON Fields", string2));
            }
        }
        return stringBuilder.toString();
    }
}

