/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.util;

import com.mirth.connect.plugins.dynamiclookup.shared.builder.AdvancedJsonFilterBuilder;
import com.mirth.connect.plugins.dynamiclookup.shared.model.AdvancedJsonFilterState;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;

public final class AdvancedSearchSnippetHelper {
    private AdvancedSearchSnippetHelper() {
    }

    public static String buildJavaScriptSnippetForAdvancedState(LookupGroup lookupGroup, AdvancedJsonFilterState advancedJsonFilterState) {
        if (lookupGroup == null) {
            throw new IllegalArgumentException("LookupGroup cannot be null");
        }
        if (advancedJsonFilterState == null) {
            throw new IllegalArgumentException("AdvancedJsonFilterState cannot be null");
        }
        String string = AdvancedJsonFilterBuilder.toConditionsJsonArray((AdvancedJsonFilterState)advancedJsonFilterState);
        if (string == null || string.trim().isEmpty()) {
            string = "[]";
        }
        String string2 = advancedJsonFilterState.getKeyPattern();
        return AdvancedSearchSnippetHelper.buildJavaScriptSnippet(lookupGroup.getName(), string2, string);
    }

    private static String buildJavaScriptSnippet(String string, String string2, String string3) {
        String string4 = AdvancedSearchSnippetHelper.escapeJs(string);
        String string5 = string2 != null ? AdvancedSearchSnippetHelper.escapeJs(string2) : null;
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append("// JavaScript snippet for Dynamic Lookup (Advanced Search)\n");
        stringBuilder.append("var groupName = \"").append(string4).append("\";\n\n");
        if (string5 != null && !string5.isEmpty()) {
            stringBuilder.append("// Optional KEY pattern filter (SQL LIKE)\n");
            stringBuilder.append("var keyPattern = \"").append(string5).append("\";\n\n");
        } else {
            stringBuilder.append("// No KEY pattern filter\n");
            stringBuilder.append("var keyPattern = null;\n\n");
        }
        stringBuilder.append("// JSON field filters (array form; easy to edit)\n");
        stringBuilder.append("// NOTE: The server normalizes \"value\" to text; valueType controls validation and casting (STRING/NUMBER/BOOLEAN).\n");
        stringBuilder.append("var filterObj = ").append(string3).append(";\n");
        stringBuilder.append("var filterJson = JSON.stringify(filterObj);\n\n");
        stringBuilder.append("// NOTE:\n");
        stringBuilder.append("// The lookup returns only the FIRST 1000 matching entries.\n");
        stringBuilder.append("// This limit is applied to protect performance.\n\n");
        stringBuilder.append("var start = new Date().getTime();\n");
        stringBuilder.append("var results = LookupHelper.searchValuesByJsonFields(\n");
        stringBuilder.append("    groupName,\n");
        stringBuilder.append("    keyPattern,\n");
        stringBuilder.append("    filterJson\n");
        stringBuilder.append(");\n");
        stringBuilder.append("var elapsed = new Date().getTime() - start;\n\n");
        stringBuilder.append("// DEBUG OUTPUT (remove or comment out in production)\n");
        stringBuilder.append("if (results == null) {\n");
        stringBuilder.append("    logger.error(\"Lookup failed for group: \" + groupName);\n");
        stringBuilder.append("} else if (results.isEmpty()) {\n");
        stringBuilder.append("    logger.info(\"No matching entries (elapsed=\" + elapsed + \" ms) in group=\" + groupName);\n");
        stringBuilder.append("} else {\n");
        stringBuilder.append("    logger.info(\"Sample results (showing up to 2 entries):\");\n");
        stringBuilder.append("    var iter = results.keySet().iterator();\n");
        stringBuilder.append("    var count = 0;\n\n");
        stringBuilder.append("    while (iter.hasNext() && count < 2) {\n");
        stringBuilder.append("        var key = iter.next();\n");
        stringBuilder.append("        var value = results.get(key);\n");
        stringBuilder.append("        logger.info(\"  key=\" + key + \", value=\" + value);\n");
        stringBuilder.append("        count++;\n");
        stringBuilder.append("    }\n\n");
        stringBuilder.append("    logger.info(\n");
        stringBuilder.append("        \"Found \" + results.size() + \" matching entries (elapsed=\" + elapsed + \" ms) in group=\" + groupName\n");
        stringBuilder.append("    );\n");
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private static String escapeJs(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
        block7: for (char c : string.toCharArray()) {
            switch (c) {
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block7;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

