/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.util;

import com.mirth.connect.client.ui.Frame;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public class FileChooser {
    public File createFileForExport(Frame frame, String string, String string2) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        if (string != null) {
            jFileChooser.setSelectedFile(new File(string));
        }
        if (string2 != null) {
            jFileChooser.setFileFilter(new CustomFileFilter(string2));
        }
        if ((file = new File(Frame.userPreferences.get("currentDirectory", ""))).exists()) {
            jFileChooser.setCurrentDirectory(file);
        }
        if (jFileChooser.showSaveDialog((Component)frame) != 0) {
            return null;
        }
        Frame.userPreferences.put("currentDirectory", jFileChooser.getCurrentDirectory().getPath());
        File file2 = jFileChooser.getSelectedFile();
        if (file2.getName().length() < 4 || !FilenameUtils.getExtension((String)file2.getName()).equalsIgnoreCase(string2)) {
            file2 = new File(file2.getAbsolutePath() + "." + string2.toLowerCase());
        }
        return file2.exists() && !frame.alertOption((Component)frame, "This file already exists.  Would you like to overwrite it?") ? null : file2;
    }

    private class CustomFileFilter
    extends FileFilter {
        private String fileExtension;

        public CustomFileFilter(String string) {
            this.fileExtension = string;
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase(this.fileExtension);
        }

        @Override
        public String getDescription() {
            if (this.fileExtension.equalsIgnoreCase("csv")) {
                return "CSV files";
            }
            if (this.fileExtension.equalsIgnoreCase("json")) {
                return "JSON files";
            }
            return "All Files";
        }
    }
}

