/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.ncpdp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class NCPDPReference {
    private static final String VERSION_D0 = "D0";
    private Map<String, String> NCPDPD0map = new HashMap<String, String>();
    private Map<String, String> segmentD0Map = new HashMap<String, String>();
    private ArrayList<String> repeatingFieldsD0 = new ArrayList();
    private Map<String, String> NCPDP51map = new HashMap<String, String>();
    private Map<String, String> segment51Map = new HashMap<String, String>();
    private ArrayList<String> repeatingFields51 = new ArrayList();
    private Map<String, String> transactionMap = new HashMap<String, String>();
    private static NCPDPReference instance = null;

    private NCPDPReference() {
        this.populateNCPDPD0(this.NCPDPD0map);
        this.populateSegmentsD0(this.segmentD0Map);
        this.populateRepFieldsD0(this.repeatingFieldsD0);
        this.populateNCPDP51(this.NCPDP51map);
        this.populateSegments51(this.segment51Map);
        this.populateRepFields51(this.repeatingFields51);
        this.populateTransactionType(this.transactionMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NCPDPReference getInstance() {
        Class<NCPDPReference> clazz = NCPDPReference.class;
        synchronized (NCPDPReference.class) {
            if (instance == null) {
                instance = new NCPDPReference();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getTransactionName(String key) {
        return MapUtils.getString(this.transactionMap, (Object)key, (String)key);
    }

    public String getSegment(String key, String version) {
        if (StringUtils.equals((CharSequence)version, (CharSequence)VERSION_D0)) {
            return MapUtils.getString(this.segmentD0Map, (Object)key, (String)key);
        }
        return MapUtils.getString(this.segment51Map, (Object)key, (String)key);
    }

    public String getDescription(String key, String version) {
        if (StringUtils.equals((CharSequence)version, (CharSequence)VERSION_D0)) {
            return MapUtils.getString(this.NCPDPD0map, (Object)key, (String)"");
        }
        return MapUtils.getString(this.NCPDP51map, (Object)key, (String)"");
    }

    public String getCodeByName(String description, String version) {
        if (StringUtils.equals((CharSequence)version, (CharSequence)VERSION_D0)) {
            for (String key : this.NCPDPD0map.keySet()) {
                if (!this.NCPDPD0map.get(key).equals(description)) continue;
                return key;
            }
        } else {
            for (String key : this.NCPDP51map.keySet()) {
                if (!this.NCPDP51map.get(key).equals(description)) continue;
                return key;
            }
        }
        return description;
    }

    public String getSegmentIdByName(String description, String version) {
        if (StringUtils.equals((CharSequence)version, (CharSequence)VERSION_D0)) {
            for (String key : this.segmentD0Map.keySet()) {
                if (!this.segmentD0Map.get(key).equals(description)) continue;
                return key;
            }
        } else {
            for (String key : this.segment51Map.keySet()) {
                if (!this.segment51Map.get(key).equals(description)) continue;
                return key;
            }
        }
        return description;
    }

    public boolean isRepeatingField(String description, String version) {
        return StringUtils.equals((CharSequence)version, (CharSequence)VERSION_D0) && this.repeatingFieldsD0.contains(description) || this.repeatingFields51.contains(description);
    }

    private void populateNCPDP51(Map<String, String> messages) {
        messages.put("28", "UnitOfMeasure");
        messages.put("1C", "SmokerNon-SmokerCode");
        messages.put("1E", "PrescriberLocationCode");
        messages.put("2C", "PregnancyIndicator");
        messages.put("2E", "PrimaryCareProviderIdQualifier");
        messages.put("2F", "NetworkReimbursementId");
        messages.put("4C", "CoordinationOfBenefitsOtherPaymentsCount");
        messages.put("4E", "PrimaryCareProviderLastName");
        messages.put("4F", "RejectFieldOccurrenceIndicator");
        messages.put("5C", "OtherPayerCoverageType");
        messages.put("5E", "OtherPayerRejectCount");
        messages.put("5F", "ApprovedMessageCodeCount");
        messages.put("6C", "OtherPayerIdQualifier");
        messages.put("6E", "OtherPayerRejectCode");
        messages.put("6F", "ApprovedMessageCode");
        messages.put("7C", "OtherPayerId");
        messages.put("7E", "DurPpsCodeCounter");
        messages.put("7F", "HelpDeskPhoneNumberQualifier");
        messages.put("8C", "FacilityId");
        messages.put("8E", "DurPpsLevelOfEffort");
        messages.put("8F", "HelpDeskPhoneNumber");
        messages.put("9F", "PreferredProductCount");
        messages.put("A1", "BinNumber");
        messages.put("A2", "VersionReleaseNumber");
        messages.put("A3", "TransactionCode");
        messages.put("A4", "ProcessorControlNumber");
        messages.put("A9", "TransactionCount");
        messages.put("AK", "SoftwareVendorCertificationId");
        messages.put("AM", "SegmentIdentification");
        messages.put("AN", "TransactionResponseStatus");
        messages.put("AP", "PreferredProductIdQualifier");
        messages.put("AR", "PreferredProductId");
        messages.put("AS", "PreferredProductIncentive");
        messages.put("AT", "PreferredProductCopayIncentive");
        messages.put("AU", "PreferredProductDescription");
        messages.put("AV", "TaxExemptIndicator");
        messages.put("AW", "FlatSalesTaxAmountPaid");
        messages.put("AX", "PercentageSalesTaxAmountPaid");
        messages.put("AY", "PercentageSalesTaxRatePaid");
        messages.put("AZ", "PercentageSalesTaxBasisPaid");
        messages.put("B1", "ServiceProviderId");
        messages.put("B2", "ServiceProviderIdQualifier");
        messages.put("BE", "ProfessionalServiceFeeSubmitted");
        messages.put("C1", "GroupId");
        messages.put("C2", "CardholderId");
        messages.put("C3", "PersonCode");
        messages.put("C4", "DateOfBirth");
        messages.put("C5", "PatientGenderCode");
        messages.put("C6", "PatientRelationshipCode");
        messages.put("C7", "PatientLocation");
        messages.put("C8", "OtherCoverageCode");
        messages.put("C9", "EligibilityClarificationCode");
        messages.put("CA", "PatientFirstName");
        messages.put("CB", "PatientLastName");
        messages.put("CC", "CardholderFirstName");
        messages.put("CD", "CardholderLastName");
        messages.put("CE", "HomePlan");
        messages.put("CF", "EmployerName");
        messages.put("CG", "EmployerStreetAddress");
        messages.put("CH", "EmployerCityAddress");
        messages.put("CI", "EmployerStateProvinceAddress");
        messages.put("CJ", "EmployerZipPostalZone");
        messages.put("CK", "EmployerPhoneNumber");
        messages.put("CL", "EmployerContactName");
        messages.put("CM", "PatientStreetAddress");
        messages.put("CN", "PatientCityAddress");
        messages.put("CO", "PatientStateProvinceAddress");
        messages.put("CP", "PatientZipPostalZone");
        messages.put("CQ", "PatientPhoneNumber");
        messages.put("CR", "CarrierId");
        messages.put("CW", "AlternateId");
        messages.put("CX", "PatientIdQualifier");
        messages.put("CY", "PatientId");
        messages.put("CZ", "EmployerId");
        messages.put("D1", "DateOfService");
        messages.put("D2", "PrescriptionServiceReferenceNumber");
        messages.put("D3", "FillNumber");
        messages.put("D5", "DaysSupply");
        messages.put("D6", "CompoundCode");
        messages.put("D7", "ProductServiceId");
        messages.put("D8", "DispenseAsWrittenProductSelectionCode");
        messages.put("D9", "IngredientCostSubmitted");
        messages.put("DB", "PrescriberId");
        messages.put("DC", "DispensingFeeSubmitted");
        messages.put("DE", "DatePrescriptionWritten");
        messages.put("DF", "NumberOfRefillsAuthorized");
        messages.put("DI", "LevelOfService");
        messages.put("DJ", "PrescriptionOriginCode");
        messages.put("DK", "SubmissionClarificationCode");
        messages.put("DL", "PrimaryCareProviderId");
        messages.put("DN", "BasisOfCostDetermination");
        messages.put("DO", "DiagnosisCode");
        messages.put("DQ", "UsualAndCustomaryCharge");
        messages.put("DR", "PrescriberLastName");
        messages.put("DT", "UnitDoseIndicator");
        messages.put("DU", "GrossAmountDue");
        messages.put("DV", "OtherPayerAmountPaid");
        messages.put("DX", "PatientPaidAmountSubmitted");
        messages.put("DY", "DateOfInjury");
        messages.put("DZ", "ClaimReferenceId");
        messages.put("E1", "ProductServiceIdQualifier");
        messages.put("E3", "IncentiveAmountSubmitted");
        messages.put("E4", "ReasonForServiceCode");
        messages.put("E5", "ProfessionalServiceCode");
        messages.put("E6", "ResultOfServiceCode");
        messages.put("E7", "QuantityDispensed");
        messages.put("E8", "OtherPayerDate");
        messages.put("E9", "ProviderId");
        messages.put("EA", "OriginallyPrescribedProductServiceCode");
        messages.put("EB", "OriginallyPrescribedQuantity");
        messages.put("EC", "CompoundIngredientComponentCount");
        messages.put("ED", "CompoundIngredientQuantity");
        messages.put("EE", "CompoundIngredientDrugCost");
        messages.put("EF", "CompoundDosageFormDescriptionCode");
        messages.put("EG", "CompoundDispensingUnitFormIndicator");
        messages.put("EH", "CompoundRouteOfAdministration");
        messages.put("EJ", "OrigPrescribedProductServiceIdQualifier");
        messages.put("EK", "ScheduledPrescriptionIdNumber");
        messages.put("EM", "PrescriptionServiceReferenceNumberQualifier");
        messages.put("EN", "AssociatedPrescriptionServiceReferenceNumber");
        messages.put("EP", "AssociatedPrescriptionServiceDate");
        messages.put("ER", "ProcedureModifierCode");
        messages.put("ET", "QuantityPrescribed");
        messages.put("EU", "PriorAuthorizationTypeCode");
        messages.put("EV", "PriorAuthorizationNumberSubmitted");
        messages.put("EW", "IntermediaryAuthorizationTypeId");
        messages.put("EX", "IntermediaryAuthorizationId");
        messages.put("EY", "ProviderIdQualifier");
        messages.put("EZ", "PrescriberIdQualifier");
        messages.put("F1", "HeaderResponseStatus");
        messages.put("F3", "AuthorizationNumber");
        messages.put("F4", "Message");
        messages.put("F5", "PatientPayAmount");
        messages.put("F6", "IngredientCostPaid");
        messages.put("F7", "DispensingFeePaid");
        messages.put("F9", "TotalAmountPaid");
        messages.put("FA", "RejectCount");
        messages.put("FB", "RejectCode");
        messages.put("FC", "AccumulatedDeductibleAmount");
        messages.put("FD", "RemainingDeductibleAmount");
        messages.put("FE", "RemainingBenefitAmount");
        messages.put("FH", "AmountAppliedToPeriodicDeductible");
        messages.put("FI", "AmountOfCopayCo-Insurance");
        messages.put("FJ", "AmountAttributedToProductSelection");
        messages.put("FK", "AmountExceedingPeriodicBenefitMaximum");
        messages.put("FL", "IncentiveAmountPaid");
        messages.put("FM", "BasisOfReimbursementDetermination");
        messages.put("FN", "AmountAttributedToSalesTax");
        messages.put("FO", "PlanId");
        messages.put("FQ", "AdditionalMessageInformation");
        messages.put("FS", "ClinicalSignificanceCode");
        messages.put("FT", "OtherPharmacyIndicator");
        messages.put("FU", "PreviousDateOfFill");
        messages.put("FV", "QuantityOfPreviousFill");
        messages.put("FW", "DatabaseIndicator");
        messages.put("FX", "OtherPrescriberIndicator");
        messages.put("FY", "DurFreeTextMessage");
        messages.put("GE", "PercentageSalesTaxAmountSubmitted");
        messages.put("H1", "MeasurementTime");
        messages.put("H2", "MeasurementDimension");
        messages.put("H3", "MeasurementUnit");
        messages.put("H4", "MeasurementValue");
        messages.put("H5", "PrimaryCareProviderLocationCode");
        messages.put("H6", "DurCo-AgentId");
        messages.put("H7", "OtherAmountClaimedSubmittedCount");
        messages.put("H8", "OtherAmountClaimedSubmittedQualifier");
        messages.put("H9", "OtherAmountClaimedSubmitted");
        messages.put("HA", "FlatSalesTaxAmountSubmitted");
        messages.put("HB", "OtherPayerAmountPaidCount");
        messages.put("HC", "OtherPayerAmountPaidQualifier");
        messages.put("HD", "DispensingStatus");
        messages.put("HE", "PercentageSalesTaxRateSubmitted");
        messages.put("HF", "QuantityIntendedToBeDispensed");
        messages.put("HG", "DaysSupplyIntendedToBeDispensed");
        messages.put("HH", "BasisOfCalculationDispensingFee");
        messages.put("HJ", "BasisOfCalculationCopay");
        messages.put("HK", "BasisOfCalculationFlatSalesTax");
        messages.put("HM", "BasisOfCalculationPercentageSalesTax");
        messages.put("J1", "ProfessionalServiceFeePaid");
        messages.put("J2", "OtherAmountPaidCount");
        messages.put("J3", "OtherAmountPaidQualifier");
        messages.put("J4", "OtherAmountPaid");
        messages.put("J5", "OtherPayerAmountRecognized");
        messages.put("J6", "DurPpsResponseCodeCounter");
        messages.put("J7", "PayerIdQualifier");
        messages.put("J8", "PayerId");
        messages.put("J9", "DurCo-AgentIdQualifier");
        messages.put("JE", "PercentageSalesTaxBasisSubmitted");
        messages.put("KE", "CouponType");
        messages.put("ME", "CouponNumber");
        messages.put("NE", "CouponValueAmount");
        messages.put("PA", "RequestType");
        messages.put("PB", "RequestPeriodDate-Begin");
        messages.put("PC", "RequestPeriodDate-End");
        messages.put("PD", "BasisOfRequest");
        messages.put("PE", "AuthorizedRepresentativeFirstName");
        messages.put("PF", "AuthorizedRepresentativeLastName");
        messages.put("PG", "AuthorizedRepresentativeStreetAddress");
        messages.put("PH", "AuthorizedRepresentativeCityAddress");
        messages.put("PJ", "AuthorizedRepresentativeStateProvinceAddress");
        messages.put("PK", "AuthorizedRepresentativeZipPostalZone");
        messages.put("PM", "PrescriberPhoneNumber");
        messages.put("PP", "PriorAuthorizationSupportingDocumentation");
        messages.put("PR", "PriorAuthorizationProcessedDate");
        messages.put("PS", "PriorAuthorizationEffectiveDate");
        messages.put("PT", "PriorAuthorizationExpirationDate");
        messages.put("PW", "PriorAuthorizationNumberOfRefillsAuthorized");
        messages.put("PX", "PriorAuthorizationQuantityAccumulated");
        messages.put("PY", "PriorAuthorizationNumber-Assigned");
        messages.put("RA", "PriorAuthorizationQuantity");
        messages.put("RB", "PriorAuthorizationDollarsAuthorized");
        messages.put("RE", "CompoundProductIdQualifier");
        messages.put("SE", "ProcedureModifierCodeCount");
        messages.put("TE", "CompoundProductId");
        messages.put("UE", "CompoundIngredientBasisOfCostDetermination");
        messages.put("VE", "DiagnosisCodeCount");
        messages.put("WE", "DiagnosisCodeQualifier");
        messages.put("XE", "ClinicalInformationCounter");
        messages.put("ZE", "MeasurementDate");
    }

    private void populateNCPDPD0(Map<String, String> messages) {
        messages.put("28", "UnitOfMeasure");
        messages.put("1C", "SmokerNon-SmokerCode");
        messages.put("1E", "PrescriberLocationCode");
        messages.put("2A", "MedigapId");
        messages.put("2B", "MedicaidIndicator");
        messages.put("2C", "PregnancyIndicator");
        messages.put("2D", "ProviderAcceptAssignmentIndicator");
        messages.put("2E", "PrimaryCareProviderIdQualifier");
        messages.put("2F", "NetworkReimbursementId");
        messages.put("2G", "CompoundIngredientModifierCodeCount");
        messages.put("2H", "CompoundIngredientModifierCode");
        messages.put("2J", "PrescriberFirstName");
        messages.put("2K", "PrescriberStreetAddress");
        messages.put("2M", "PrescriberCityAddress");
        messages.put("2N", "PrescriberStateAddress");
        messages.put("2P", "PrescriberZipAddress");
        messages.put("2Q", "AdditionalDocumentationTypeId");
        messages.put("2R", "LengthOfNeed");
        messages.put("2S", "LengthOfNeedQualifier");
        messages.put("2T", "PrescriberSupplierDateSigned");
        messages.put("2U", "RequestStatus");
        messages.put("2V", "RequestPeriodBeginDate");
        messages.put("2W", "RequestPeriodRecertDate");
        messages.put("2X", "SupportingDocumentation");
        messages.put("2Y", "PlanSalesTaxAmount");
        messages.put("2Z", "QuestionNumberLetterCount");
        messages.put("3Q", "FacilityName");
        messages.put("3U", "FacilityStreetAddress");
        messages.put("3V", "FacilityStateAddress");
        messages.put("4B", "QuestionNumberLetter");
        messages.put("4C", "CoordinationOfBenefitsOtherPaymentsCount");
        messages.put("4D", "QuestionPercentResponse");
        messages.put("4E", "PrimaryCareProviderLastName");
        messages.put("4F", "RejectFieldOccurrenceIndicator");
        messages.put("4G", "QuestionDateResponse");
        messages.put("4H", "QuestionDollarAmountResponse");
        messages.put("4J", "QuestionNumericResponse");
        messages.put("4K", "QuestionAlphaNumericResponse");
        messages.put("4U", "AmountOfCoinsurance");
        messages.put("4V", "BasisOfCalculationCoinsurance");
        messages.put("4X", "PatientResidence");
        messages.put("5C", "OtherPayerCoverageType");
        messages.put("5E", "OtherPayerRejectCount");
        messages.put("5F", "ApprovedMessageCodeCount");
        messages.put("5J", "FacilityCityAddress");
        messages.put("6C", "OtherPayerIdQualifier");
        messages.put("6D", "FacilityZipAddress");
        messages.put("6E", "OtherPayerRejectCode");
        messages.put("6F", "ApprovedMessageCode");
        messages.put("7C", "OtherPayerId");
        messages.put("7E", "DurPpsCodeCounter");
        messages.put("7F", "HelpDeskPhoneNumberQualifier");
        messages.put("8C", "FacilityId");
        messages.put("8E", "DurPpsLevelOfEffort");
        messages.put("8F", "HelpDeskPhoneNumber");
        messages.put("9F", "PreferredProductCount");
        messages.put("A1", "BinNumber");
        messages.put("A2", "VersionReleaseNumber");
        messages.put("A3", "TransactionCode");
        messages.put("A4", "ProcessorControlNumber");
        messages.put("A7", "InternalControlNumber");
        messages.put("A9", "TransactionCount");
        messages.put("AK", "SoftwareVendorCertificationId");
        messages.put("AM", "SegmentIdentification");
        messages.put("AN", "TransactionResponseStatus");
        messages.put("AP", "PreferredProductIdQualifier");
        messages.put("AR", "PreferredProductId");
        messages.put("AS", "PreferredProductIncentive");
        messages.put("AT", "PreferredProductCopayIncentive");
        messages.put("AU", "PreferredProductDescription");
        messages.put("AV", "TaxExemptIndicator");
        messages.put("AW", "FlatSalesTaxAmountPaid");
        messages.put("AX", "PercentageSalesTaxAmountPaid");
        messages.put("AY", "PercentageSalesTaxRatePaid");
        messages.put("AZ", "PercentageSalesTaxBasisPaid");
        messages.put("B1", "ServiceProviderId");
        messages.put("B2", "ServiceProviderIdQualifier");
        messages.put("BE", "ProfessionalServiceFeeSubmitted");
        messages.put("BM", "NarrativeMessage");
        messages.put("C1", "GroupId");
        messages.put("C2", "CardholderId");
        messages.put("C3", "PersonCode");
        messages.put("C4", "DateOfBirth");
        messages.put("C5", "PatientGenderCode");
        messages.put("C6", "PatientRelationshipCode");
        messages.put("C7", "PlaceOfService");
        messages.put("C8", "OtherCoverageCode");
        messages.put("C9", "EligibilityClarificationCode");
        messages.put("CA", "PatientFirstName");
        messages.put("CB", "PatientLastName");
        messages.put("CC", "CardholderFirstName");
        messages.put("CD", "CardholderLastName");
        messages.put("CE", "HomePlan");
        messages.put("CF", "EmployerName");
        messages.put("CG", "EmployerStreetAddress");
        messages.put("CH", "EmployerCityAddress");
        messages.put("CI", "EmployerStateProvinceAddress");
        messages.put("CJ", "EmployerZipPostalZone");
        messages.put("CK", "EmployerPhoneNumber");
        messages.put("CL", "EmployerContactName");
        messages.put("CM", "PatientStreetAddress");
        messages.put("CN", "PatientCityAddress");
        messages.put("CO", "PatientStateProvinceAddress");
        messages.put("CP", "PatientZipPostalZone");
        messages.put("CQ", "PatientPhoneNumber");
        messages.put("CR", "CarrierId");
        messages.put("CW", "AlternateId");
        messages.put("CX", "PatientIdQualifier");
        messages.put("CY", "PatientId");
        messages.put("CZ", "EmployerId");
        messages.put("D1", "DateOfService");
        messages.put("D2", "PrescriptionServiceReferenceNumber");
        messages.put("D3", "FillNumber");
        messages.put("D5", "DaysSupply");
        messages.put("D6", "CompoundCode");
        messages.put("D7", "ProductServiceId");
        messages.put("D8", "DispenseAsWrittenProductSelectionCode");
        messages.put("D9", "IngredientCostSubmitted");
        messages.put("DB", "PrescriberId");
        messages.put("DC", "DispensingFeeSubmitted");
        messages.put("DE", "DatePrescriptionWritten");
        messages.put("DF", "NumberOfRefillsAuthorized");
        messages.put("DI", "LevelOfService");
        messages.put("DJ", "PrescriptionOriginCode");
        messages.put("DK", "SubmissionClarificationCode");
        messages.put("DL", "PrimaryCareProviderId");
        messages.put("DN", "BasisOfCostDetermination");
        messages.put("DO", "DiagnosisCode");
        messages.put("DQ", "UsualAndCustomaryCharge");
        messages.put("DR", "PrescriberLastName");
        messages.put("DT", "SpecialPackagingIndicator");
        messages.put("DU", "GrossAmountDue");
        messages.put("DV", "OtherPayerAmountPaid");
        messages.put("DX", "PatientPaidAmountSubmitted");
        messages.put("DY", "DateOfInjury");
        messages.put("DZ", "ClaimReferenceId");
        messages.put("E1", "ProductServiceIdQualifier");
        messages.put("E2", "RouteOfAdministration");
        messages.put("E3", "IncentiveAmountSubmitted");
        messages.put("E4", "ReasonForServiceCode");
        messages.put("E5", "ProfessionalServiceCode");
        messages.put("E6", "ResultOfServiceCode");
        messages.put("E7", "QuantityDispensed");
        messages.put("E8", "OtherPayerDate");
        messages.put("E9", "ProviderId");
        messages.put("EA", "OriginallyPrescribedProductServiceCode");
        messages.put("EB", "OriginallyPrescribedQuantity");
        messages.put("EC", "CompoundIngredientComponentCount");
        messages.put("ED", "CompoundIngredientQuantity");
        messages.put("EE", "CompoundIngredientDrugCost");
        messages.put("EF", "CompoundDosageFormDescriptionCode");
        messages.put("EG", "CompoundDispensingUnitFormIndicator");
        messages.put("EH", "CompoundRouteOfAdministration");
        messages.put("EJ", "OrigPrescribedProductServiceIdQualifier");
        messages.put("EK", "ScheduledPrescriptionIdNumber");
        messages.put("EM", "PrescriptionServiceReferenceNumberQualifier");
        messages.put("EN", "AssociatedPrescriptionServiceReferenceNumber");
        messages.put("EP", "AssociatedPrescriptionServiceDate");
        messages.put("EQ", "PatientSalesTaxAmount");
        messages.put("ER", "ProcedureModifierCode");
        messages.put("ET", "QuantityPrescribed");
        messages.put("EU", "PriorAuthorizationTypeCode");
        messages.put("EV", "PriorAuthorizationNumberSubmitted");
        messages.put("EW", "IntermediaryAuthorizationTypeId");
        messages.put("EX", "IntermediaryAuthorizationId");
        messages.put("EY", "ProviderIdQualifier");
        messages.put("EZ", "PrescriberIdQualifier");
        messages.put("F1", "HeaderResponseStatus");
        messages.put("F3", "AuthorizationNumber");
        messages.put("F4", "Message");
        messages.put("F5", "PatientPayAmount");
        messages.put("F6", "IngredientCostPaid");
        messages.put("F7", "DispensingFeePaid");
        messages.put("F9", "TotalAmountPaid");
        messages.put("FA", "RejectCount");
        messages.put("FB", "RejectCode");
        messages.put("FC", "AccumulatedDeductibleAmount");
        messages.put("FD", "RemainingDeductibleAmount");
        messages.put("FE", "RemainingBenefitAmount");
        messages.put("FF", "FormularyId");
        messages.put("FH", "AmountAppliedToPeriodicDeductible");
        messages.put("FI", "AmountOfCopayCo-Insurance");
        messages.put("FJ", "AmountAttributedToProductSelection");
        messages.put("FK", "AmountExceedingPeriodicBenefitMaximum");
        messages.put("FL", "IncentiveAmountPaid");
        messages.put("FM", "BasisOfReimbursementDetermination");
        messages.put("FN", "AmountAttributedToSalesTax");
        messages.put("FO", "PlanId");
        messages.put("FQ", "AdditionalMessageInformation");
        messages.put("FS", "ClinicalSignificanceCode");
        messages.put("FT", "OtherPharmacyIndicator");
        messages.put("FU", "PreviousDateOfFill");
        messages.put("FV", "QuantityOfPreviousFill");
        messages.put("FW", "DatabaseIndicator");
        messages.put("FX", "OtherPrescriberIndicator");
        messages.put("FY", "DurFreeTextMessage");
        messages.put("G1", "CompoundType");
        messages.put("G2", "CMSPartDDefinedQualifiedFacility");
        messages.put("G3", "EstimatedGenericSavings");
        messages.put("GE", "PercentageSalesTaxAmountSubmitted");
        messages.put("H1", "MeasurementTime");
        messages.put("H2", "MeasurementDimension");
        messages.put("H3", "MeasurementUnit");
        messages.put("H4", "MeasurementValue");
        messages.put("H5", "PrimaryCareProviderLocationCode");
        messages.put("H6", "DurCo-AgentId");
        messages.put("H7", "OtherAmountClaimedSubmittedCount");
        messages.put("H8", "OtherAmountClaimedSubmittedQualifier");
        messages.put("H9", "OtherAmountClaimedSubmitted");
        messages.put("HA", "FlatSalesTaxAmountSubmitted");
        messages.put("HB", "OtherPayerAmountPaidCount");
        messages.put("HC", "OtherPayerAmountPaidQualifier");
        messages.put("HD", "DispensingStatus");
        messages.put("HE", "PercentageSalesTaxRateSubmitted");
        messages.put("HF", "QuantityIntendedToBeDispensed");
        messages.put("HG", "DaysSupplyIntendedToBeDispensed");
        messages.put("HH", "BasisOfCalculationDispensingFee");
        messages.put("HJ", "BasisOfCalculationCopay");
        messages.put("HK", "BasisOfCalculationFlatSalesTax");
        messages.put("HM", "BasisOfCalculationPercentageSalesTax");
        messages.put("HN", "PatientEmailAddress");
        messages.put("J1", "ProfessionalServiceFeePaid");
        messages.put("J2", "OtherAmountPaidCount");
        messages.put("J3", "OtherAmountPaidQualifier");
        messages.put("J4", "OtherAmountPaid");
        messages.put("J5", "OtherPayerAmountRecognized");
        messages.put("J6", "DurPpsResponseCodeCounter");
        messages.put("J7", "PayerIdQualifier");
        messages.put("J8", "PayerId");
        messages.put("J9", "DurCo-AgentIdQualifier");
        messages.put("JE", "PercentageSalesTaxBasisSubmitted");
        messages.put("K5", "TransactionReferenceNumber");
        messages.put("KE", "CouponType");
        messages.put("MA", "URL");
        messages.put("ME", "CouponNumber");
        messages.put("MG", "OtherPayerBinNumber");
        messages.put("MH", "OtherPayerProcessorControlNumber");
        messages.put("MJ", "OtherPayerGroupId");
        messages.put("MQ", "AmountAttributedToProductSelectionQualifier");
        messages.put("MT", "PatientAssignmentIndicator");
        messages.put("MU", "BenefitStageCount");
        messages.put("MV", "BenefitStageQualifier");
        messages.put("MW", "BenefitStageAmount");
        messages.put("N3", "MedicaidPaidAmount");
        messages.put("N4", "MedicaidSubrogationInternalControlNumber");
        messages.put("N5", "MedicaidIdNumber");
        messages.put("N6", "MedicaidAgencyNumber");
        messages.put("NE", "CouponValueAmount");
        messages.put("NP", "OtherPayerPatientRespAmountPaidQualifier");
        messages.put("NQ", "OtherPayerPatientRespAmount");
        messages.put("NR", "OtherPayerPatientRespAmountPaidCount");
        messages.put("NT", "OtherPayerIdCount");
        messages.put("NU", "OtherPayerCardholderId");
        messages.put("NV", "DelayReasonCode");
        messages.put("NX", "SubmissionClarificationCodeCount");
        messages.put("PA", "RequestType");
        messages.put("PB", "RequestPeriodDate-Begin");
        messages.put("PC", "RequestPeriodDate-End");
        messages.put("PD", "BasisOfRequest");
        messages.put("PE", "AuthorizedRepresentativeFirstName");
        messages.put("PF", "AuthorizedRepresentativeLastName");
        messages.put("PG", "AuthorizedRepresentativeStreetAddress");
        messages.put("PH", "AuthorizedRepresentativeCityAddress");
        messages.put("PJ", "AuthorizedRepresentativeStateProvinceAddress");
        messages.put("PK", "AuthorizedRepresentativeZipPostalZone");
        messages.put("PM", "PrescriberPhoneNumber");
        messages.put("PP", "PriorAuthorizationSupportingDocumentation");
        messages.put("PR", "PriorAuthorizationProcessedDate");
        messages.put("PS", "PriorAuthorizationEffectiveDate");
        messages.put("PT", "PriorAuthorizationExpirationDate");
        messages.put("PW", "PriorAuthorizationNumberOfRefillsAuthorized");
        messages.put("PX", "PriorAuthorizationQuantityAccumulated");
        messages.put("PY", "PriorAuthorizationNumber-Assigned");
        messages.put("RA", "PriorAuthorizationQuantity");
        messages.put("RB", "PriorAuthorizationDollarsAuthorized");
        messages.put("RE", "CompoundProductIdQualifier");
        messages.put("SE", "ProcedureModifierCodeCount");
        messages.put("TE", "CompoundProductId");
        messages.put("TR", "BillingEntityTypeIndicator");
        messages.put("TS", "PayToQualifier");
        messages.put("TT", "PayToId");
        messages.put("TU", "PayToName");
        messages.put("TV", "PayToStreetAddress");
        messages.put("TW", "PayToCityAddress");
        messages.put("TX", "PayToStateAddress");
        messages.put("TY", "PayToZipAddress");
        messages.put("TZ", "GenericEquivalentProductIdQualifier");
        messages.put("U1", "ContractNumber");
        messages.put("U6", "BenefitId");
        messages.put("U7", "PharmacyServiceType");
        messages.put("U8", "IngredientCostContractedAmount");
        messages.put("U9", "DispensingFeeContractedAmount");
        messages.put("UA", "GenericEquivalentProductId");
        messages.put("UB", "OtherPayerHelpDeskPhone");
        messages.put("UC", "SpendingAccountAmountRemaining");
        messages.put("UD", "HealthPlanFundedAssistanceAmount");
        messages.put("UE", "CompoundIngredientBasisOfCostDetermination");
        messages.put("UF", "AdditionalMessageInformationCount");
        messages.put("UG", "AdditionalMessageInformationContinuity");
        messages.put("UH", "AdditionalMessageInformationQualifier");
        messages.put("UJ", "AmountAttributedToProviderNetworkSelection");
        messages.put("UK", "AmountAttributedToProductSelectionBrandDrug");
        messages.put("UM", "AmountAttributedToProductSelectionNonPreferredSelection");
        messages.put("UN", "AmountAttributedToProductSelectionBrandNonPreferredSelection");
        messages.put("UP", "AmountAttributedToCoverageGap");
        messages.put("UQ", "CmsLowIncomeCostSharingLevel");
        messages.put("UR", "MedicarePartDCoverageCode");
        messages.put("US", "NextMedicarePartDEffecticeDate");
        messages.put("UT", "NextMedicarePartDTerminationDate");
        messages.put("UV", "OtherPayerPersonCode");
        messages.put("UW", "OtherPayerPatientRelationshipCode");
        messages.put("UX", "OtherPayerBenefitEffectiveDate");
        messages.put("UY", "OtherPayerBenefitTerminationDate");
        messages.put("VE", "DiagnosisCodeCount");
        messages.put("WE", "DiagnosisCodeQualifier");
        messages.put("XE", "ClinicalInformationCounter");
        messages.put("ZE", "MeasurementDate");
    }

    private void populateSegments51(Map<String, String> segments) {
        segments.put("AM01", "Patient");
        segments.put("AM02", "PharmacyProvider");
        segments.put("AM03", "Prescriber");
        segments.put("AM04", "Insurance");
        segments.put("AM05", "CoordinationOfBenefitsOtherPayments");
        segments.put("AM06", "WorkersCompensation");
        segments.put("AM07", "Claim");
        segments.put("AM08", "DURPPS");
        segments.put("AM09", "Coupon");
        segments.put("AM10", "Compound");
        segments.put("AM11", "Pricing");
        segments.put("AM12", "PriorAuthorization");
        segments.put("AM13", "Clinical");
        segments.put("AM20", "ResponseMessage");
        segments.put("AM21", "ResponseStatus");
        segments.put("AM22", "ResponseClaim");
        segments.put("AM23", "ResponsePricing");
        segments.put("AM24", "ResponseDURPPS");
        segments.put("AM25", "ResponseInsurance");
        segments.put("AM26", "ResponsePriorAuthorization");
    }

    private void populateSegmentsD0(Map<String, String> segments) {
        segments.put("AM01", "Patient");
        segments.put("AM02", "PharmacyProvider");
        segments.put("AM03", "Prescriber");
        segments.put("AM04", "Insurance");
        segments.put("AM05", "CoordinationOfBenefitsOtherPayments");
        segments.put("AM06", "WorkersCompensation");
        segments.put("AM07", "Claim");
        segments.put("AM08", "DURPPS");
        segments.put("AM09", "Coupon");
        segments.put("AM10", "Compound");
        segments.put("AM11", "Pricing");
        segments.put("AM12", "PriorAuthorization");
        segments.put("AM13", "Clinical");
        segments.put("AM14", "AdditionalDocumentation");
        segments.put("AM15", "Facility");
        segments.put("AM16", "Narrative");
        segments.put("AM20", "ResponseMessage");
        segments.put("AM21", "ResponseStatus");
        segments.put("AM22", "ResponseClaim");
        segments.put("AM23", "ResponsePricing");
        segments.put("AM24", "ResponseDURPPS");
        segments.put("AM25", "ResponseInsurance");
        segments.put("AM26", "ResponsePriorAuthorization");
    }

    private void populateTransactionType(Map<String, String> types) {
        types.put("E1", "EligibilityVerification");
        types.put("B1", "Billing");
        types.put("B2", "Reversal");
        types.put("B3", "Rebill");
        types.put("P1", "PARequestBilling");
        types.put("P2", "PAReversal");
        types.put("P3", "PAInquiry");
        types.put("P4", "PARequestOnly");
        types.put("N1", "InformationReporting");
        types.put("N2", "InformationReportingReversal");
        types.put("N3", "InformationReportingRebill");
        types.put("C1", "ControlledSubstanceReporting");
        types.put("C2", "ControlledSubstanceReportingReversal");
        types.put("C3", "ControlledSubstanceReportingRebill");
    }

    private void populateRepFields51(List<String> fields) {
        fields.add("ProcedureModifierCode");
        fields.add("OtherPayerCoverageType");
        fields.add("OtherPayerIdQualifier");
        fields.add("OtherPayerId");
        fields.add("OtherPayerDate");
        fields.add("OtherPayerAmountPaidQualifier");
        fields.add("OtherPayerAmountPaid");
        fields.add("OtherPayerRejectCode");
        fields.add("OtherAmountClaimedSubmittedQualifier");
        fields.add("OtherAmountClaimedSubmitted");
        fields.add("CompoundProductIdQualifier");
        fields.add("CompoundProductId");
        fields.add("CompoundIngredientQuantity");
        fields.add("CompoundIngredientDrugCost");
        fields.add("CompoundIngredientBasisOfCostDetermination");
        fields.add("DiagnosisCodeQualifier");
        fields.add("DiagnosisCode");
        fields.add("RejectCode");
        fields.add("RejectFieldOccurrenceIndicator");
        fields.add("ApprovedMessageCode");
        fields.add("PreferredProductIdQualifier");
        fields.add("PreferredProductId");
        fields.add("PreferredProductIncentive");
        fields.add("PreferredProductCopayIncentive");
        fields.add("PreferredProductDescription");
        fields.add("OtherAmountPaidQualifier");
        fields.add("OtherAmountPaid");
    }

    private void populateRepFieldsD0(List<String> fields) {
        fields.add("ProcedureModifierCode");
        fields.add("OtherPayerCoverageType");
        fields.add("OtherPayerIdQualifier");
        fields.add("OtherPayerId");
        fields.add("OtherPayerDate");
        fields.add("OtherPayerAmountPaidQualifier");
        fields.add("OtherPayerAmountPaid");
        fields.add("OtherPayerRejectCode");
        fields.add("OtherAmountClaimedSubmittedQualifier");
        fields.add("OtherAmountClaimedSubmitted");
        fields.add("CompoundProductIdQualifier");
        fields.add("CompoundProductId");
        fields.add("CompoundIngredientQuantity");
        fields.add("CompoundIngredientDrugCost");
        fields.add("CompoundIngredientBasisOfCostDetermination");
        fields.add("DiagnosisCodeQualifier");
        fields.add("DiagnosisCode");
        fields.add("RejectCode");
        fields.add("RejectFieldOccurrenceIndicator");
        fields.add("ApprovedMessageCode");
        fields.add("PreferredProductIdQualifier");
        fields.add("PreferredProductId");
        fields.add("PreferredProductIncentive");
        fields.add("PreferredProductCopayIncentive");
        fields.add("PreferredProductDescription");
        fields.add("OtherAmountPaidQualifier");
        fields.add("OtherAmountPaid");
        fields.add("SubmissionClarificationCode");
        fields.add("BenefitStageAmount");
        fields.add("BenefitStageQualifier");
        fields.add("OtherPayerPatientRespAmount");
        fields.add("OtherPayerPatientRespAmountPaidQualifier");
        fields.add("InternalControlNumber");
        fields.add("OtherPayerAmountPaidCount");
        fields.add("CompoundIngredientModifierCode");
        fields.add("QuestionNumberLetter");
        fields.add("QuestionPercentResponse");
        fields.add("QuestionDateResponse");
        fields.add("QuestionDollarAmountResponse");
        fields.add("QuestionNumericResponse");
        fields.add("QuestionAlphaNumericResponse");
        fields.add("AdditionalMessageInformation");
        fields.add("AdditionalMessageInformationContinuity");
        fields.add("AdditionalMessageInformationQualifier");
        fields.add("OtherPayerProcessorControlNumber");
        fields.add("OtherPayerCardholderId");
        fields.add("OtherPayerGroupId");
        fields.add("OtherPayerPersonCode");
        fields.add("OtherPayerHelpDeskPhone");
        fields.add("OtherPayerPatientRelationshipCode");
        fields.add("OtherPayerBenefitEffectiveDate");
        fields.add("OtherPayerBenefitTerminationDate");
    }
}

