/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.util.Iterator;
import org.dcm4che2.data.DicomElement;

public class DicomElementCombineIterator
implements Iterator<DicomElement> {
    Iterator<DicomElement> it1;
    Iterator<DicomElement> it2;
    DicomElement next1;
    DicomElement next2;

    public DicomElementCombineIterator(Iterator<DicomElement> it1, Iterator<DicomElement> it2) {
        this.it1 = it1;
        this.it2 = it2;
    }

    protected void fill() {
        if (this.next1 == null && this.it1.hasNext()) {
            this.next1 = this.it1.next();
        }
        if (this.next2 == null && this.it2.hasNext()) {
            this.next2 = this.it2.next();
        }
        if (this.next2 != null && this.next1 != null && this.next1.tag() == this.next2.tag()) {
            this.next2 = null;
        }
    }

    @Override
    public boolean hasNext() {
        this.fill();
        return this.next1 != null || this.next2 != null;
    }

    @Override
    public DicomElement next() {
        this.fill();
        if (this.next1 == null) {
            DicomElement ret = this.next2;
            this.next2 = null;
            return ret;
        }
        if (this.next2 == null) {
            DicomElement ret = this.next1;
            this.next1 = null;
            return ret;
        }
        if (this.next1.tag() < this.next2.tag()) {
            DicomElement ret = this.next1;
            this.next1 = null;
            return ret;
        }
        DicomElement ret = this.next2;
        this.next2 = null;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

