/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jdbc;

import com.mirth.connect.connectors.jdbc.DatabaseDispatcher;
import com.mirth.connect.connectors.jdbc.DatabaseDispatcherDelegate;
import com.mirth.connect.connectors.jdbc.DatabaseDispatcherException;
import com.mirth.connect.connectors.jdbc.DatabaseDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.server.MirthScopeProvider;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.util.javascript.JavaScriptScopeUtil;
import com.mirth.connect.server.util.javascript.JavaScriptTask;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import com.mirth.connect.userutil.ImmutableConnectorMessage;
import com.mirth.connect.userutil.Response;
import com.mirth.connect.userutil.Status;
import com.mirth.connect.util.ErrorMessageBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.tools.debugger.MirthMain;

public class DatabaseDispatcherScript
implements DatabaseDispatcherDelegate {
    private String scriptId;
    private DatabaseDispatcher connector;
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ContextFactoryController contextFactoryController = this.getContextFactoryController();
    private Logger scriptLogger = LogManager.getLogger((String)"db-connector");
    private Logger logger = LogManager.getLogger(this.getClass());
    private List<String> contextFactoryIdList = new ArrayList<String>();
    private volatile String contextFactoryId;
    private boolean debug = false;
    private MirthMain debugger;
    private boolean ignoreBreakpoints = false;
    private MirthScopeProvider scopeProvider = new MirthScopeProvider();

    public DatabaseDispatcherScript(DatabaseDispatcher connector) {
        this.connector = connector;
    }

    @Override
    public void deploy() throws ConnectorTaskException {
        Channel channel = this.connector.getChannel();
        DebugOptions debugOptions = channel.getDebugOptions();
        DatabaseDispatcherProperties connectorProperties = (DatabaseDispatcherProperties)this.connector.getConnectorProperties();
        this.debug = debugOptions != null && debugOptions.isDestinationConnectorScripts();
        this.scriptId = ScriptController.getScriptId((String)("Database_Writer_" + this.connector.getMetaDataId()), (String)this.connector.getChannelId());
        try {
            MirthContextFactory contextFactory = null;
            HashMap<String, MirthContextFactory> contextFactories = new HashMap<String, MirthContextFactory>();
            if (this.debug) {
                contextFactory = this.contextFactoryController.getDebugContextFactory(this.connector.getResourceIds(), this.connector.getChannelId(), this.scriptId);
                this.contextFactoryIdList.add(contextFactory.getId());
                contextFactory.setContextType(ContextType.DESTINATION_DISPATCHER);
                contextFactory.setScriptText(connectorProperties.getQuery());
                contextFactory.setDebugType(Boolean.valueOf(true));
                contextFactories.put(this.scriptId, contextFactory);
                this.debugger = this.getDebugger(channel, contextFactory);
            } else {
                contextFactory = this.contextFactoryController.getContextFactory(this.connector.getResourceIds());
            }
            this.contextFactoryId = contextFactory.getId();
            this.compileAndAddScript(connectorProperties, contextFactory);
        }
        catch (Exception e) {
            throw new ConnectorTaskException("Error compiling script " + this.scriptId + ".", (Throwable)e);
        }
    }

    @Override
    public void undeploy() throws ConnectorTaskException {
        this.removeScriptFromCache();
        if (this.debug && this.debugger != null) {
            this.contextFactoryController.removeDebugContextFactory(this.connector.getResourceIds(), this.connector.getChannelId(), this.scriptId);
            this.debugger.dispose();
            this.debugger = null;
        }
    }

    @Override
    public void start() throws ConnectorTaskException {
        this.ignoreBreakpoints = false;
        if (this.debug && this.debugger != null) {
            this.debugger.enableDebugging();
        }
    }

    @Override
    public void stop() throws ConnectorTaskException {
        if (this.debug && this.debugger != null) {
            this.debugger.finishScriptExecution();
        }
    }

    @Override
    public void halt() throws ConnectorTaskException {
    }

    protected void compileAndAddScript(DatabaseDispatcherProperties connectorProperties, MirthContextFactory contextFactory) throws Exception {
        JavaScriptUtil.compileAndAddScript((String)this.connector.getChannelId(), (MirthContextFactory)contextFactory, (String)this.scriptId, (String)connectorProperties.getQuery(), (ContextType)ContextType.DESTINATION_DISPATCHER, null, null);
    }

    protected MirthMain getDebugger(Channel channel, MirthContextFactory contextFactory) {
        return JavaScriptUtil.getDebugger((MirthContextFactory)contextFactory, (MirthScopeProvider)this.scopeProvider, (Channel)channel, (String)this.scriptId);
    }

    public ContextFactoryController getContextFactoryController() {
        return ControllerFactory.getFactory().createContextFactoryController();
    }

    protected void removeScriptFromCache() {
        JavaScriptUtil.removeScriptFromCache((String)this.scriptId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.mirth.connect.donkey.model.message.Response send(DatabaseDispatcherProperties connectorProperties, ConnectorMessage connectorMessage) throws DatabaseDispatcherException, InterruptedException {
        try {
            MirthContextFactory contextFactory;
            MirthContextFactory mirthContextFactory = contextFactory = this.debug ? this.contextFactoryController.getDebugContextFactory(this.connector.getResourceIds(), this.connector.getChannelId(), this.scriptId) : this.contextFactoryController.getContextFactory(this.connector.getResourceIds());
            if (!this.contextFactoryId.equals(contextFactory.getId())) {
                DatabaseDispatcherScript databaseDispatcherScript = this;
                synchronized (databaseDispatcherScript) {
                    MirthContextFactory mirthContextFactory2 = contextFactory = this.debug ? this.contextFactoryController.getDebugContextFactory(this.connector.getResourceIds(), this.connector.getChannelId(), this.scriptId) : this.contextFactoryController.getContextFactory(this.connector.getResourceIds());
                    if (this.contextFactoryId.equals(contextFactory.getId())) {
                        JavaScriptUtil.recompileGeneratedScript((MirthContextFactory)contextFactory, (String)this.scriptId);
                        this.contextFactoryId = contextFactory.getId();
                    }
                }
            }
            return (com.mirth.connect.donkey.model.message.Response)JavaScriptUtil.execute((JavaScriptTask)new DatabaseDispatcherTask(contextFactory, connectorMessage));
        }
        catch (Exception e) {
            throw new DatabaseDispatcherException("Error executing script " + this.scriptId, e);
        }
    }

    private class DatabaseDispatcherTask
    extends JavaScriptTask<Object> {
        private ConnectorMessage connectorMessage;

        public DatabaseDispatcherTask(MirthContextFactory contextFactory, ConnectorMessage connectorMessage) {
            super(contextFactory, (DestinationConnector)DatabaseDispatcherScript.this.connector);
            this.connectorMessage = connectorMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object doCall() {
            String responseData = null;
            String responseError = null;
            String responseStatusMessage = "Database write success";
            com.mirth.connect.donkey.model.message.Status responseStatus = com.mirth.connect.donkey.model.message.Status.SENT;
            try {
                Object result;
                Scriptable scope = JavaScriptScopeUtil.getMessageDispatcherScope((ContextFactory)this.getContextFactory(), (Object)DatabaseDispatcherScript.this.scriptLogger, (String)DatabaseDispatcherScript.this.connector.getChannelId(), (ImmutableConnectorMessage)new ImmutableConnectorMessage(this.connectorMessage, true, DatabaseDispatcherScript.this.connector.getDestinationIdMap()));
                if (DatabaseDispatcherScript.this.debug) {
                    DatabaseDispatcherScript.this.scopeProvider.setScope(scope);
                    if (DatabaseDispatcherScript.this.debugger != null && !DatabaseDispatcherScript.this.ignoreBreakpoints) {
                        DatabaseDispatcherScript.this.debugger.doBreak();
                        if (!DatabaseDispatcherScript.this.debugger.isVisible()) {
                            DatabaseDispatcherScript.this.debugger.setVisible(true);
                        }
                    }
                }
                if ((result = JavaScriptUtil.executeScript((JavaScriptTask)this, (String)DatabaseDispatcherScript.this.scriptId, (Scriptable)scope, (String)DatabaseDispatcherScript.this.connector.getChannelId(), (String)DatabaseDispatcherScript.this.connector.getDestinationName())) != null && !(result instanceof Undefined)) {
                    if (result instanceof NativeJavaObject) {
                        Object object = ((NativeJavaObject)result).unwrap();
                        if (object instanceof Response) {
                            com.mirth.connect.donkey.model.message.Response response = JavaScriptUtil.convertToDonkeyResponse((Object)object);
                            return response;
                        }
                        if (object instanceof Status) {
                            responseStatus = JavaScriptUtil.convertToDonkeyStatus((Status)((Status)object));
                        } else {
                            responseData = object.toString();
                        }
                    } else {
                        if (result instanceof Response) {
                            com.mirth.connect.donkey.model.message.Response response = JavaScriptUtil.convertToDonkeyResponse((Object)result);
                            return response;
                        }
                        if (result instanceof Status) {
                            responseStatus = JavaScriptUtil.convertToDonkeyStatus((Status)((Status)result));
                        } else {
                            responseData = (String)Context.jsToJava((Object)result, String.class);
                        }
                    }
                }
            }
            catch (Exception e) {
                ConnectorProperties connectorProperties = DatabaseDispatcherScript.this.connector.getConnectorProperties();
                responseStatusMessage = ErrorMessageBuilder.buildErrorResponse((String)("Error evaluating " + connectorProperties.getName()), (Throwable)e);
                responseError = ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)("Error evaluating " + DatabaseDispatcherScript.this.connector.getConnectorProperties().getName()), (Throwable)e);
                responseStatus = com.mirth.connect.donkey.model.message.Status.QUEUED;
                DatabaseDispatcherScript.this.logger.error("Error evaluating " + connectorProperties.getName() + " (" + connectorProperties.getName() + " \"" + DatabaseDispatcherScript.this.connector.getDestinationName() + "\" on channel " + DatabaseDispatcherScript.this.connector.getChannelId() + ").", (Throwable)e);
                DatabaseDispatcherScript.this.eventController.dispatchEvent((Event)new ErrorEvent(DatabaseDispatcherScript.this.connector.getChannelId(), Integer.valueOf(DatabaseDispatcherScript.this.connector.getMetaDataId()), Long.valueOf(this.connectorMessage.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, DatabaseDispatcherScript.this.connector.getDestinationName(), connectorProperties.getName(), "Error evaluating " + connectorProperties.getName(), (Throwable)e));
            }
            finally {
                Context.exit();
            }
            return new com.mirth.connect.donkey.model.message.Response(responseStatus, responseData, responseStatusMessage, responseError);
        }
    }
}

