/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.delimited;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.model.datatype.DataTypePropertyDescriptor;
import com.mirth.connect.model.datatype.PropertyEditorType;
import com.mirth.connect.model.datatype.SerializationProperties;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DelimitedSerializationProperties
extends SerializationProperties {
    private transient Logger logger;
    private String columnDelimiter = ",";
    private String recordDelimiter = "\\n";
    private Integer[] columnWidths = null;
    private String quoteToken = "\"";
    private boolean escapeWithDoubleQuote = true;
    private String quoteEscapeToken = "\\";
    private String[] columnNames = null;
    private boolean numberedRows = false;
    private boolean ignoreCR = true;

    public Map<String, DataTypePropertyDescriptor> getPropertyDescriptors() {
        LinkedHashMap<String, DataTypePropertyDescriptor> properties = new LinkedHashMap<String, DataTypePropertyDescriptor>();
        properties.put("columnDelimiter", new DataTypePropertyDescriptor((Object)this.columnDelimiter, "Column Delimiter", "If column values are delimited, enter the characters that separate columns.  For example, this is a comma in a CSV file.", PropertyEditorType.STRING));
        properties.put("recordDelimiter", new DataTypePropertyDescriptor((Object)this.recordDelimiter, "Record Delimiter", "Enter the characters that separate each record (a message may contain multiple records).  For example, this is a newline (\\n) in a CSV file.", PropertyEditorType.STRING));
        properties.put("columnWidths", new DataTypePropertyDescriptor((Object)this.toCommaSeparatedString(this.columnWidths), "Column Widths", "If the column values are fixed width, enter a comma separated list of fixed column widths.  By default, column values are assumed to be delimited.", PropertyEditorType.STRING));
        properties.put("quoteToken", new DataTypePropertyDescriptor((Object)this.quoteToken, "Quote Token", "Enter the quote characters that are used to bracket delimit column values containing embedded special characters like column delimiters, record delimiters, quote characters and/or message delimiters.    For example, this is a double quote (\") in a CSV file.", PropertyEditorType.STRING));
        properties.put("escapeWithDoubleQuote", new DataTypePropertyDescriptor((Object)this.escapeWithDoubleQuote, "Double Quote Escaping", "By default, two consecutive quote tokens within a quoted value are treated as an embedded quote token.  Uncheck to enable escaped quote token processing (and specify the Escape Tokens).", PropertyEditorType.BOOLEAN));
        properties.put("quoteEscapeToken", new DataTypePropertyDescriptor((Object)this.quoteEscapeToken, "Escape Token", "Enter the characters used to escape embedded quote tokens.  By default, this is a back slash.  This option has no effect unless Double Quote Escaping is unchecked.", PropertyEditorType.STRING));
        properties.put("columnNames", new DataTypePropertyDescriptor((Object)this.toCommaSeparatedString(this.columnNames), "Column Names", "To override the default column names (column1, ..., columnN), enter a comma separated list of column names.", PropertyEditorType.STRING));
        properties.put("numberedRows", new DataTypePropertyDescriptor((Object)this.numberedRows, "Numbered Rows", "Check to number each row in the XML representation of the message.", PropertyEditorType.BOOLEAN));
        properties.put("ignoreCR", new DataTypePropertyDescriptor((Object)this.ignoreCR, "Ignore Carriage Returns", "Ignores carriage return (\\r) characters.  These are read over and skipped without processing them.", PropertyEditorType.BOOLEAN));
        return properties;
    }

    public void setProperties(Map<String, Object> properties) {
        if (properties != null) {
            if (StringUtils.isNotEmpty((CharSequence)((String)properties.get("columnDelimiter")))) {
                this.columnDelimiter = (String)properties.get("columnDelimiter");
            }
            if (StringUtils.isNotEmpty((CharSequence)((String)properties.get("recordDelimiter")))) {
                this.recordDelimiter = (String)properties.get("recordDelimiter");
            }
            if (properties.get("columnWidths") != null) {
                String widths = (String)properties.get("columnWidths");
                if (widths.isEmpty()) {
                    this.columnWidths = null;
                } else {
                    String[] temp = widths.split(",");
                    Integer[] columnWidths = new Integer[temp.length];
                    boolean error = false;
                    for (int i = 0; i < temp.length; ++i) {
                        try {
                            columnWidths[i] = Integer.parseInt(temp[i]);
                            if (columnWidths[i] > 0) continue;
                            error = true;
                            this.logError("Fixed column width must be positive integer: " + columnWidths[i]);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            error = true;
                            this.logError("Invalid number format in Column Widths: " + temp[i]);
                        }
                    }
                    if (!error) {
                        this.columnWidths = columnWidths;
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)((String)properties.get("quoteToken")))) {
                this.quoteToken = (String)properties.get("quoteToken");
            }
            if (properties.get("escapeWithDoubleQuote") != null) {
                this.escapeWithDoubleQuote = (Boolean)properties.get("escapeWithDoubleQuote");
            }
            if (StringUtils.isNotEmpty((CharSequence)((String)properties.get("quoteEscapeToken")))) {
                this.quoteEscapeToken = (String)properties.get("quoteEscapeToken");
            }
            if (properties.get("columnNames") != null) {
                String names = (String)properties.get("columnNames");
                if (names.isEmpty()) {
                    this.columnNames = null;
                } else {
                    String[] columnNames = names.split(",");
                    boolean error = false;
                    for (int i = 0; i < columnNames.length; ++i) {
                        if (this.validXMLElementName(columnNames[i])) continue;
                        error = true;
                        this.logError("Invalid column name: " + columnNames[i] + " (must be a combination of letters, digits, periods, dashes, underscores and colons that begins with a letter, underscore or colon)");
                    }
                    if (!error) {
                        this.columnNames = columnNames;
                    }
                }
            }
            if (properties.get("numberedRows") != null) {
                this.numberedRows = (Boolean)properties.get("numberedRows");
            }
            if (properties.get("ignoreCR") != null) {
                this.ignoreCR = (Boolean)properties.get("ignoreCR");
            }
        }
    }

    private void logError(String error) {
        if (this.logger == null) {
            this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        }
        this.logger.error(error);
    }

    private String toCommaSeparatedString(Object[] objects) {
        StringBuilder builder = new StringBuilder();
        if (objects != null && objects.length > 0) {
            builder.append(objects[0]);
            for (int i = 1; i < objects.length; ++i) {
                builder.append(",");
                builder.append(objects[i]);
            }
        }
        return builder.toString();
    }

    private boolean validXMLElementName(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char ch = s.charAt(0);
        if (!Character.isLetter(ch) && ch != '_' && ch != ':') {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            ch = s.charAt(i);
            if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '.' || ch == '-' || ch == '_' || ch == ':') continue;
            return false;
        }
        return true;
    }

    public String getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public void setColumnDelimiter(String columnDelimiter) {
        this.columnDelimiter = columnDelimiter;
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setRecordDelimiter(String recordDelimiter) {
        this.recordDelimiter = recordDelimiter;
    }

    public Integer[] getColumnWidths() {
        return this.columnWidths;
    }

    public void setColumnWidths(Integer[] columnWidths) {
        this.columnWidths = columnWidths;
    }

    public String getQuoteToken() {
        return this.quoteToken;
    }

    public void setQuoteToken(String quoteToken) {
        this.quoteToken = quoteToken;
    }

    public boolean isEscapeWithDoubleQuote() {
        return this.escapeWithDoubleQuote;
    }

    public void setEscapeWithDoubleQuote(boolean escapeWithDoubleQuote) {
        this.escapeWithDoubleQuote = escapeWithDoubleQuote;
    }

    public String getQuoteEscapeToken() {
        return this.quoteEscapeToken;
    }

    public void setQuoteEscapeToken(String quoteEscapeToken) {
        this.quoteEscapeToken = quoteEscapeToken;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public boolean isNumberedRows() {
        return this.numberedRows;
    }

    public void setNumberedRows(boolean numberedRows) {
        this.numberedRows = numberedRows;
    }

    public boolean isIgnoreCR() {
        return this.ignoreCR;
    }

    public void setIgnoreCR(boolean ignoreCR) {
        this.ignoreCR = ignoreCR;
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
        DonkeyElement childElement = element.getChildElement("quoteChar");
        if (childElement != null) {
            childElement.setNodeName("quoteToken");
        }
        if ((childElement = element.getChildElement("quoteEscapeChar")) != null) {
            childElement.setNodeName("quoteEscapeToken");
        }
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("columnWidths", this.columnWidths);
        purgedProperties.put("escapeWithDoubleQuote", this.escapeWithDoubleQuote);
        purgedProperties.put("columnNameCount", ArrayUtils.getLength((Object)this.columnNames));
        purgedProperties.put("numberedRows", this.numberedRows);
        purgedProperties.put("ignoreCR", this.ignoreCR);
        return purgedProperties;
    }
}

