/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.server.maintenance;

import com.mirth.connect.plugins.messagetrends.server.maintenance.RollKey;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageStatisticsTimeseries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class QueuedBackfillHelper {
    private final QueueReader queueReader;
    private final Set<QKey> positiveQueued = ConcurrentHashMap.newKeySet();

    public QueuedBackfillHelper(QueueReader queueReader) {
        this.queueReader = Objects.requireNonNull(queueReader);
    }

    public void resetPositiveSet() {
        this.positiveQueued.clear();
    }

    public void backfillMinute(Date date, Map<RollKey, MessageStatisticsTimeseries> map) {
        if (this.positiveQueued.isEmpty()) {
            return;
        }
        ArrayList<QKey> arrayList = new ArrayList<QKey>(this.positiveQueued);
        for (QKey qKey : arrayList) {
            RollKey rollKey = new RollKey(qKey.serverId, qKey.channelId, qKey.connectorId, date, 1);
            if (map.containsKey(rollKey)) continue;
            MessageStatisticsTimeseries messageStatisticsTimeseries = new MessageStatisticsTimeseries();
            messageStatisticsTimeseries.setServerId(qKey.serverId);
            messageStatisticsTimeseries.setChannelId(qKey.channelId);
            messageStatisticsTimeseries.setConnectorId(qKey.connectorId);
            messageStatisticsTimeseries.setTs(date);
            messageStatisticsTimeseries.setBucketSizeMinutes(Integer.valueOf(1));
            messageStatisticsTimeseries.setReceived(Integer.valueOf(0));
            messageStatisticsTimeseries.setFiltered(Integer.valueOf(0));
            messageStatisticsTimeseries.setSent(Integer.valueOf(0));
            messageStatisticsTimeseries.setError(Integer.valueOf(0));
            messageStatisticsTimeseries.setQueued(Integer.valueOf(this.readQueuedClamped(qKey.channelId, qKey.connectorId)));
            map.put(rollKey, messageStatisticsTimeseries);
        }
    }

    public void updateAfterFlush(Collection<MessageStatisticsTimeseries> collection) {
        this.resetPositiveSet();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (MessageStatisticsTimeseries messageStatisticsTimeseries : collection) {
            String string = messageStatisticsTimeseries.getServerId();
            String string2 = messageStatisticsTimeseries.getChannelId();
            String string3 = messageStatisticsTimeseries.getConnectorId();
            QKey qKey = new QKey(string, string2, string3);
            int n = messageStatisticsTimeseries.getQueued() == null ? 0 : messageStatisticsTimeseries.getQueued();
            if (n <= 0) continue;
            this.positiveQueued.add(qKey);
        }
    }

    private int readQueuedClamped(String string, String string2) {
        long l = 0L;
        try {
            l = this.queueReader.getQueuedCount(string, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l <= 0L) {
            return 0;
        }
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public static interface QueueReader {
        public long getQueuedCount(String var1, String var2) throws Exception;
    }

    public static final class QKey {
        public final String serverId;
        public final String channelId;
        public final String connectorId;

        public QKey(String string, String string2, String string3) {
            this.serverId = string;
            this.channelId = string2;
            this.connectorId = string3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof QKey)) {
                return false;
            }
            QKey qKey = (QKey)object;
            return Objects.equals(this.serverId, qKey.serverId) && Objects.equals(this.channelId, qKey.channelId) && Objects.equals(this.connectorId, qKey.connectorId);
        }

        public int hashCode() {
            return Objects.hash(this.serverId, this.channelId, this.connectorId);
        }
    }
}

