/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.server.migration;

import com.mirth.connect.plugins.messagetrends.server.migration.SqlScriptRunner;
import com.mirth.connect.plugins.messagetrends.server.util.DatabaseDialect;
import com.mirth.connect.server.util.DatabaseUtil;
import java.sql.Connection;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MessageTrendsDatabaseMigrator {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final SqlSessionManager sqlSessionManager;

    public MessageTrendsDatabaseMigrator(SqlSessionManager sqlSessionManager) {
        this.sqlSessionManager = sqlSessionManager;
    }

    public void initializeDatabase() throws Exception {
        this.logger.info("Initializing database schema...");
        boolean bl = false;
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            bl = DatabaseUtil.tableExists((Connection)sqlSession.getConnection(), (String)"message_statistics_timeseries");
        }
        if (!bl) {
            DatabaseDialect.DatabaseType databaseType = DatabaseDialect.determineDatabaseType(this.sqlSessionManager);
            String string = SqlScriptRunner.loadScript(this.getCreateSchemaScriptPath(databaseType));
            SqlScriptRunner.runWithSemicolon(this.sqlSessionManager, string);
            this.logger.info("Database schema initialized successfully");
        }
    }

    private String getCreateSchemaScriptPath(DatabaseDialect.DatabaseType databaseType) {
        return switch (databaseType) {
            case DatabaseDialect.DatabaseType.POSTGRESQL -> "/sql/postgres/create-message-trends-tables.sql";
            case DatabaseDialect.DatabaseType.MYSQL -> "/sql/mysql/create-message-trends-tables.sql";
            case DatabaseDialect.DatabaseType.SQLSERVER -> "/sql/sqlserver/create-message-trends-tables.sql";
            case DatabaseDialect.DatabaseType.ORACLE -> "/sql/oracle/create-message-trends-tables.sql";
            default -> "/sql/derby/create-message-trends-tables.sql";
        };
    }
}

