/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.server.service;

import com.mirth.connect.plugins.messagetrends.server.dao.MessageStatisticsTimeseriesDao;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageStatisticsTimeseries;
import com.mirth.connect.server.controllers.ControllerFactory;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageTrendsService {
    private static MessageTrendsService instance = null;
    private MessageStatisticsTimeseriesDao dao;
    private String serverId;
    private final Logger logger = LogManager.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageTrendsService getInstance() {
        Class<MessageTrendsService> clazz = MessageTrendsService.class;
        synchronized (MessageTrendsService.class) {
            if (instance == null) {
                instance = new MessageTrendsService();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private MessageTrendsService() {
    }

    public void init(MessageStatisticsTimeseriesDao messageStatisticsTimeseriesDao) {
        this.dao = messageStatisticsTimeseriesDao;
        this.serverId = ControllerFactory.getFactory().createConfigurationController().getServerId();
    }

    private void ensureInit() {
        if (this.dao == null || this.serverId == null) {
            throw new IllegalStateException("MessageTrendsService not initialized with DAO + serverId");
        }
    }

    public int replaceRollupWindow(Date date, int n, List<MessageStatisticsTimeseries> list) {
        this.ensureInit();
        try {
            return this.dao.replaceRollupWindow(this.serverId, date, n, list);
        }
        catch (Exception exception) {
            this.logger.warn("Failed to replace rollup window", (Throwable)exception);
            return 0;
        }
    }

    public List<MessageStatisticsTimeseries> getChannelSeries(String string, Date date, Date date2, int n) {
        this.ensureInit();
        return this.dao.selectSeriesServerChannel(this.serverId, string, date, date2, n);
    }

    public List<MessageStatisticsTimeseries> getConnectorSeries(String string, String string2, Date date, Date date2, int n) {
        this.ensureInit();
        return this.dao.selectSeriesServerConnector(this.serverId, string, string2, date, date2, n);
    }

    public List<MessageStatisticsTimeseries> getServerSeries(Date date, Date date2, int n) {
        this.ensureInit();
        return this.dao.selectSeriesServerAll(this.serverId, date, date2, n);
    }

    public int purgeBeforeByBucket(int n, Date date) {
        this.ensureInit();
        return this.dao.purgeBefore(this.serverId, n, date);
    }
}

