/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.mllpmode;

import com.mirth.connect.model.transmission.framemode.FrameModeProperties;

public class MLLPModeProperties
extends FrameModeProperties {
    public static final String PLUGIN_POINT = "MLLP";
    private boolean useMLLPv2;
    private String ackBytes;
    private String nackBytes;
    private String maxRetries;

    public MLLPModeProperties() {
        super(PLUGIN_POINT);
        this.setStartOfMessageBytes("0B");
        this.setEndOfMessageBytes("1C0D");
        this.useMLLPv2 = false;
        this.ackBytes = "06";
        this.nackBytes = "15";
        this.maxRetries = "2";
    }

    public boolean isUseMLLPv2() {
        return this.useMLLPv2;
    }

    public void setUseMLLPv2(boolean useMLLPv2) {
        this.useMLLPv2 = useMLLPv2;
    }

    public String getAckBytes() {
        return this.ackBytes;
    }

    public void setAckBytes(String ackBytes) {
        this.ackBytes = ackBytes;
    }

    public String getNackBytes() {
        return this.nackBytes;
    }

    public void setNackBytes(String nackBytes) {
        this.nackBytes = nackBytes;
    }

    public String getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(String maxRetries) {
        this.maxRetries = maxRetries;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof MLLPModeProperties) {
            MLLPModeProperties props = (MLLPModeProperties)((Object)obj);
            equal = props.isUseMLLPv2() == this.useMLLPv2 && props.getAckBytes().equals(this.ackBytes) && props.getNackBytes().equals(this.nackBytes) && props.getMaxRetries().equals(this.maxRetries);
        }
        return equal && super.equals(obj);
    }
}

