/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.js;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.VariableListHandler;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.connectors.js.JavaScriptReceiverProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;

public class JavaScriptReader
extends ConnectorSettingsPanel {
    private JLabel jsLabel;
    private MirthRTextScrollPane javascriptTextPane;

    public JavaScriptReader() {
        this.initComponents();
        this.initLayout();
    }

    public String getConnectorName() {
        return new JavaScriptReceiverProperties().getName();
    }

    public ConnectorProperties getProperties() {
        JavaScriptReceiverProperties properties = new JavaScriptReceiverProperties();
        properties.setScript(this.javascriptTextPane.getText());
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        JavaScriptReceiverProperties props = (JavaScriptReceiverProperties)properties;
        this.javascriptTextPane.setText(props.getScript());
    }

    public ConnectorProperties getDefaults() {
        return new JavaScriptReceiverProperties();
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        JavaScriptReceiverProperties props = (JavaScriptReceiverProperties)properties;
        boolean valid = true;
        if (props.getScript().length() == 0) {
            valid = false;
            if (highlight) {
                this.javascriptTextPane.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    public VariableListHandler.TransferMode getTransferMode() {
        return VariableListHandler.TransferMode.JAVASCRIPT;
    }

    public void resetInvalidProperties() {
        this.javascriptTextPane.setBackground(null);
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.javascriptTextPane.updateDisplayOptions();
    }

    public String doValidate(ConnectorProperties properties, boolean highlight) {
        JavaScriptReceiverProperties props = (JavaScriptReceiverProperties)properties;
        Object error = null;
        String script = props.getScript();
        if (script.length() != 0) {
            Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
            try {
                context.compileString("function rhinoWrapper() {" + script + "\n}", UUID.randomUUID().toString(), 1, null);
            }
            catch (EvaluatorException e) {
                if (error == null) {
                    error = "";
                }
                error = (String)error + "Error in connector \"" + this.getName() + "\" at Javascript:\nError on line " + e.lineNumber() + ": " + e.getMessage() + ".\n\n";
            }
            catch (Exception e) {
                if (error == null) {
                    error = "";
                }
                error = (String)error + "Error in connector \"" + this.getName() + "\" at Javascript:\nUnknown error occurred during validation.";
            }
            Context.exit();
        }
        return error;
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.jsLabel = new JLabel("JavaScript:");
        this.javascriptTextPane = new MirthRTextScrollPane(ContextType.SOURCE_RECEIVER, true);
        this.javascriptTextPane.setBorder(BorderFactory.createEtchedBorder());
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 6 6", "6[]13[]"));
        this.add(this.jsLabel, "top, right");
        this.add((Component)this.javascriptTextPane, "grow, push, w :400, h :100");
    }
}

