/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class DatabaseSettings {
    private static Map<String, String> DEFAULT_DRIVER_MAP = new HashMap<String, String>();
    private boolean useExternalDb;
    private String database;
    private String url;
    private String username;
    private String password;
    private String driver;
    private int maxConnections;
    private int maxRetry;

    public boolean isUseExternalDb() {
        return this.useExternalDb;
    }

    public void setUseExternalDb(boolean bl) {
        this.useExternalDb = bl;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String string) {
        this.database = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public void setMaxRetry(int n) {
        this.maxRetry = n;
    }

    private String getMappedDatabaseDriver() {
        if (StringUtils.isBlank((CharSequence)this.driver)) {
            return MapUtils.getString(DEFAULT_DRIVER_MAP, (Object)this.getDatabase());
        }
        return this.driver;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        if (this.getMappedDatabaseDriver() != null) {
            properties.setProperty("driver", this.getMappedDatabaseDriver());
        }
        if (this.url != null) {
            properties.setProperty("url", this.url);
        }
        if (this.username != null) {
            properties.setProperty("username", this.username);
        }
        if (this.password != null) {
            properties.setProperty("password", this.password);
        }
        properties.setProperty("database.max-connections", String.valueOf(this.maxConnections));
        properties.setProperty("database.connection.maxretry", String.valueOf(this.maxRetry));
        return properties;
    }

    public String toString() {
        return "DatabaseSettings{useExternalDb=" + this.useExternalDb + ", database='" + this.database + "', url='" + this.url + "', username='" + this.username + "', password='" + this.password + "', driver='" + this.driver + "', maxConnections=" + this.maxConnections + ", maxRetry=" + this.maxRetry + "}";
    }

    static {
        DEFAULT_DRIVER_MAP.put("derby", "org.apache.derby.jdbc.EmbeddedDriver");
        DEFAULT_DRIVER_MAP.put("mysql", "com.mysql.cj.jdbc.Driver");
        DEFAULT_DRIVER_MAP.put("oracle", "oracle.jdbc.OracleDriver");
        DEFAULT_DRIVER_MAP.put("postgres", "org.postgresql.Driver");
        DEFAULT_DRIVER_MAP.put("sqlserver", "net.sourceforge.jtds.jdbc.Driver");
    }
}

