/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.config;

import com.mirth.connect.client.core.PropertiesConfigurationUtil;
import com.mirth.connect.plugins.dynamiclookup.server.config.DatabaseSettings;
import com.mirth.connect.server.tools.ClassPathResource;
import java.io.File;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseSettingsLoader {
    private static final Logger logger = LogManager.getLogger(DatabaseSettingsLoader.class);
    private static final String CONFIG_PATH = "dynamic-lookup.properties";

    public static DatabaseSettings load() {
        DatabaseSettings databaseSettings = new DatabaseSettings();
        try {
            PropertiesConfiguration propertiesConfiguration = PropertiesConfigurationUtil.create((File)new File(ClassPathResource.getResourceURI((String)CONFIG_PATH)));
            databaseSettings.setUseExternalDb(propertiesConfiguration.getBoolean("useExternalDb", false));
            databaseSettings.setDatabase(propertiesConfiguration.getString("database", ""));
            databaseSettings.setUrl(propertiesConfiguration.getString("database.url", ""));
            databaseSettings.setUsername(propertiesConfiguration.getString("database.username", ""));
            databaseSettings.setPassword(propertiesConfiguration.getString("database.password", ""));
            databaseSettings.setDriver(propertiesConfiguration.getString("database.driver", ""));
            databaseSettings.setMaxConnections(propertiesConfiguration.getInt("database.max-connections", 20));
            databaseSettings.setMaxRetry(propertiesConfiguration.getInt("database.connection.maxretry", 2));
            logger.info("Loaded database settings from {}", (Object)CONFIG_PATH);
        }
        catch (Exception exception) {
            logger.warn("Failed to load database settings from {}", (Object)CONFIG_PATH, (Object)exception);
            databaseSettings.setUseExternalDb(false);
        }
        return databaseSettings;
    }
}

