/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.controller;

import com.mirth.connect.plugins.dynamiclookup.server.cache.LookupCacheManager;
import com.mirth.connect.plugins.dynamiclookup.server.controller.LookupPropertiesProvider;
import com.mirth.connect.plugins.dynamiclookup.server.dao.impl.MyBatisLookupAuditDao;
import com.mirth.connect.plugins.dynamiclookup.server.dao.impl.MyBatisLookupGroupDao;
import com.mirth.connect.plugins.dynamiclookup.server.dao.impl.MyBatisLookupGroupExtraDao;
import com.mirth.connect.plugins.dynamiclookup.server.dao.impl.MyBatisLookupStatisticsDao;
import com.mirth.connect.plugins.dynamiclookup.server.dao.impl.MyBatisLookupValueDao;
import com.mirth.connect.plugins.dynamiclookup.server.exception.LookupTableException;
import com.mirth.connect.plugins.dynamiclookup.server.maintenance.AuditPurgeTask;
import com.mirth.connect.plugins.dynamiclookup.server.migration.LookupDatabaseMigrator;
import com.mirth.connect.plugins.dynamiclookup.server.service.LookupService;
import com.mirth.connect.plugins.dynamiclookup.server.userutil.LookupHelper;
import com.mirth.connect.plugins.dynamiclookup.server.util.DatabaseDialect;
import com.mirth.connect.plugins.dynamiclookup.server.util.SqlSessionManagerProvider;
import com.mirth.connect.plugins.dynamiclookup.shared.capability.DatabaseInfo;
import com.mirth.connect.plugins.dynamiclookup.shared.capability.LookupJsonCapability;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupProperties;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupValue;
import com.mirth.connect.server.controllers.ExtensionController;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupTableController
implements LookupPropertiesProvider {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final LookupService lookupService = LookupService.getInstance();
    private LookupCacheManager cacheManager;
    private volatile LookupProperties currentProperties = LookupProperties.getDefault();
    private AuditPurgeTask auditPurgeTask;
    private final ScheduledExecutorService restoreExec = Executors.newSingleThreadScheduledExecutor(runnable -> {
        Thread thread = new Thread(runnable, "Lookup Table Restore Reconcile");
        thread.setDaemon(true);
        return thread;
    });
    private ScheduledFuture<?> pendingRestore;
    private static LookupTableController instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LookupTableController getInstance() {
        Class<LookupTableController> clazz = LookupTableController.class;
        synchronized (LookupTableController.class) {
            if (instance == null) {
                instance = new LookupTableController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public LookupProperties get() {
        return this.currentProperties;
    }

    public void init(Properties properties) throws LookupTableException {
        try {
            SqlSessionManager sqlSessionManager = this.getSqlSessionManager();
            DatabaseInfo databaseInfo = DatabaseDialect.determineDatabase(sqlSessionManager);
            LookupJsonCapability.initialize((DatabaseInfo)databaseInfo);
            new LookupDatabaseMigrator(sqlSessionManager).initializeDatabase();
            MyBatisLookupGroupDao myBatisLookupGroupDao = new MyBatisLookupGroupDao(sqlSessionManager);
            MyBatisLookupGroupExtraDao myBatisLookupGroupExtraDao = new MyBatisLookupGroupExtraDao(sqlSessionManager);
            MyBatisLookupValueDao myBatisLookupValueDao = new MyBatisLookupValueDao(sqlSessionManager);
            MyBatisLookupAuditDao myBatisLookupAuditDao = new MyBatisLookupAuditDao(sqlSessionManager);
            MyBatisLookupStatisticsDao myBatisLookupStatisticsDao = new MyBatisLookupStatisticsDao(sqlSessionManager);
            this.cacheManager = new LookupCacheManager(myBatisLookupGroupDao);
            this.lookupService.init(myBatisLookupGroupDao, myBatisLookupValueDao, myBatisLookupAuditDao, myBatisLookupStatisticsDao, myBatisLookupGroupExtraDao, this.cacheManager);
            LookupHelper.initialize(this.lookupService);
            this.currentProperties = LookupProperties.fromProperties((Properties)properties);
            this.auditPurgeTask = new AuditPurgeTask(this, this.lookupService);
            this.logger.info("Lookup Table Management System plugin initialized successfully");
        }
        catch (Exception exception) {
            throw new LookupTableException(exception);
        }
    }

    public void update(Properties properties) throws LookupTableException {
        if (this.pendingRestore != null) {
            this.pendingRestore.cancel(false);
            this.pendingRestore = null;
        }
        this.updateProperties(LookupProperties.fromProperties((Properties)properties));
        this.refreshAuditPurgeSchedule();
    }

    public void start() throws LookupTableException {
        try {
            this.preloadLookupTables();
            this.refreshAuditPurgeSchedule();
        }
        catch (Exception exception) {
            throw new LookupTableException(exception);
        }
    }

    public void stop() throws LookupTableException {
        try {
            if (this.cacheManager != null) {
                this.cacheManager.clearAllCaches();
            }
            if (this.auditPurgeTask != null) {
                this.auditPurgeTask.stop();
                this.auditPurgeTask = null;
            }
        }
        catch (Exception exception) {
            throw new LookupTableException(exception);
        }
        finally {
            if (this.pendingRestore != null) {
                this.pendingRestore.cancel(false);
                this.pendingRestore = null;
            }
        }
    }

    public void onRestoreTriggered() {
        if (this.pendingRestore != null && !this.pendingRestore.isDone()) {
            this.pendingRestore.cancel(false);
            this.pendingRestore = null;
        }
        try {
            this.pendingRestore = this.restoreExec.schedule(() -> {
                try {
                    Properties properties = ExtensionController.getInstance().getPluginProperties("Lookup Table Management System");
                    if (properties != null) {
                        this.update(properties);
                    }
                }
                catch (Exception exception) {
                    this.logger.error("Failed to reconcile after restore", (Throwable)exception);
                }
            }, 5L, TimeUnit.SECONDS);
            this.logger.debug("Scheduled reconcile after restore (5s delay).");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.logger.warn("Restore reconcile skipped: executor already shut down.");
        }
    }

    public synchronized void updateProperties(LookupProperties lookupProperties) {
        this.currentProperties = lookupProperties;
    }

    private void refreshAuditPurgeSchedule() {
        if (this.auditPurgeTask == null) {
            this.logger.warn("Audit purge task is not initialized; skipping schedule refresh.");
            return;
        }
        LookupProperties lookupProperties = this.currentProperties;
        boolean bl = lookupProperties.isAuditPruneEnabled();
        long l = this.auditPurgeTask.getFixedRateSeconds();
        long l2 = this.auditPurgeTask.getInitialDelaySeconds();
        this.auditPurgeTask.refresh(bl, l, l2);
        this.logger.info("Audit purge schedule {} (interval={}s, delay={}s)", (Object)(bl ? "enabled" : "disabled"), (Object)l, (Object)l2);
    }

    private SqlSessionManager getSqlSessionManager() {
        return SqlSessionManagerProvider.get();
    }

    private void preloadLookupTables() {
        this.logger.info("Preloading lookup tables...");
        try {
            List<LookupGroup> list = this.lookupService.getAllGroups();
            int n = 0;
            for (LookupGroup lookupGroup : list) {
                int n2;
                this.cacheManager.createOrRebuildGroupCache(lookupGroup);
                int n3 = lookupGroup.getCacheSize();
                if (n3 <= 0 || (n2 = this.preloadGroupValues(lookupGroup)) <= 0) continue;
                ++n;
                this.logger.info("Preloaded {} values for group: {} (ID: {})", (Object)n2, (Object)lookupGroup.getName(), (Object)lookupGroup.getId());
            }
            this.logger.info("Completed preloading {} lookup groups", (Object)n);
        }
        catch (Exception exception) {
            this.logger.error("Error preloading lookup tables", (Throwable)exception);
        }
    }

    private int preloadGroupValues(LookupGroup lookupGroup) {
        try {
            int n = lookupGroup.getCacheSize() * 2;
            List<LookupValue> list = this.lookupService.searchLookupValues(lookupGroup.getId(), 0, n, null);
            if (list == null || list.isEmpty()) {
                return 0;
            }
            for (LookupValue lookupValue : list) {
                this.cacheManager.putValue(lookupGroup.getId(), lookupValue.getKeyValue(), lookupValue.getValueData(), lookupValue.getUpdatedDate());
            }
            return list.size();
        }
        catch (Exception exception) {
            this.logger.warn("Failed to preload values for group: {} (ID: {}): {}", (Object)lookupGroup.getName(), (Object)lookupGroup.getId(), (Object)exception.getMessage());
            return 0;
        }
    }
}

