/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.dao.impl;

import com.mirth.connect.plugins.dynamiclookup.server.dao.LookupGroupDao;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;

public class MyBatisLookupGroupDao
implements LookupGroupDao {
    private SqlSessionManager sqlSessionManager;

    public MyBatisLookupGroupDao(SqlSessionManager sqlSessionManager) {
        this.sqlSessionManager = sqlSessionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupGroup getGroupById(int n) {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            LookupGroup lookupGroup = (LookupGroup)sqlSession.selectOne("Lookup.getGroupById", (Object)n);
            return lookupGroup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupGroup getGroupByName(String string) {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            LookupGroup lookupGroup = (LookupGroup)sqlSession.selectOne("Lookup.getGroupByName", (Object)string);
            return lookupGroup;
        }
    }

    @Override
    public List<LookupGroup> getAllGroups() {
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            List list = sqlSession.selectList("Lookup.getAllGroups");
            return list;
        }
    }

    @Override
    public int insertGroup(LookupGroup lookupGroup) {
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", lookupGroup.getName());
            hashMap.put("description", lookupGroup.getDescription());
            hashMap.put("version", lookupGroup.getVersion());
            hashMap.put("cacheSize", lookupGroup.getCacheSize());
            hashMap.put("cachePolicy", lookupGroup.getCachePolicy());
            hashMap.put("valueType", lookupGroup.getValueType());
            hashMap.put("statisticsEnabled", lookupGroup.isStatisticsEnabled());
            sqlSession.insert("Lookup.insertGroup", hashMap);
            sqlSession.commit();
            bl = true;
            Object v = hashMap.get("id");
            if (v instanceof BigDecimal) {
                int n = ((BigDecimal)v).intValue();
                return n;
            }
            if (v instanceof BigInteger) {
                int n = ((BigInteger)v).intValue();
                return n;
            }
            if (v instanceof Integer) {
                int n = (Integer)v;
                return n;
            }
            throw new IllegalStateException("Unexpected ID type: " + String.valueOf(v.getClass()));
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGroup(LookupGroup lookupGroup) {
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", lookupGroup.getId());
            hashMap.put("name", lookupGroup.getName());
            hashMap.put("description", lookupGroup.getDescription());
            hashMap.put("version", lookupGroup.getVersion());
            hashMap.put("cacheSize", lookupGroup.getCacheSize());
            hashMap.put("cachePolicy", lookupGroup.getCachePolicy());
            hashMap.put("valueType", lookupGroup.getValueType());
            hashMap.put("statisticsEnabled", lookupGroup.isStatisticsEnabled());
            sqlSession.update("Lookup.updateGroup", hashMap);
            sqlSession.commit();
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteGroup(int n) {
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            sqlSession.delete("Lookup.deleteGroup", (Object)n);
            sqlSession.commit();
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createValueTable(String string) {
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tableName", string);
            sqlSession.update("Lookup.createLookupValueTable", hashMap);
            sqlSession.commit();
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createValueJsonTable(String string) {
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tableName", string);
            sqlSession.update("Lookup.createLookupValueJsonTable", hashMap);
            sqlSession.commit();
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropValueTable(String string) {
        SqlSession sqlSession = this.sqlSessionManager.openSession();
        boolean bl = false;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tableName", string);
            sqlSession.update("Lookup.dropLookupValueTable", hashMap);
            sqlSession.commit();
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    sqlSession.rollback();
                }
                catch (Exception exception) {}
            }
            sqlSession.close();
        }
    }

    @Override
    public boolean tableExists(String string) {
        return false;
    }
}

