/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.maintenance;

import com.mirth.connect.plugins.dynamiclookup.server.controller.LookupPropertiesProvider;
import com.mirth.connect.plugins.dynamiclookup.server.maintenance.AbstractScheduledTask;
import com.mirth.connect.plugins.dynamiclookup.server.service.LookupService;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupProperties;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class AuditPurgeTask
extends AbstractScheduledTask {
    private static final int FIXED_RATE_SECONDS = 3600;
    private static final int INITIAL_DELAY_SECONDS = 300;
    private final LookupService service;
    private final LookupPropertiesProvider provider;

    public AuditPurgeTask(LookupPropertiesProvider lookupPropertiesProvider, LookupService lookupService) {
        super("AuditPurge");
        this.provider = lookupPropertiesProvider;
        this.service = lookupService;
    }

    public int getFixedRateSeconds() {
        return 3600;
    }

    public int getInitialDelaySeconds() {
        return 300;
    }

    @Override
    protected void runOnce() throws Exception {
        Instant instant = Clock.systemUTC().instant();
        LookupProperties lookupProperties = this.provider.get();
        if (!lookupProperties.isAuditPruneEnabled()) {
            this.logDebug("Prune disabled; skipping.");
            return;
        }
        int n = lookupProperties.getAuditPruneRetentionDays();
        if (n <= 0) {
            this.logWarn("RetentionDays <= 0; skipping purge.");
            return;
        }
        Instant instant2 = instant.minus(Duration.ofDays(n));
        Date date = Date.from(instant2);
        int n2 = this.service.deleteAuditEntriesBefore(date);
        this.logInfo(String.format("Audit purge completed successfully: retention=%dd, cutoff=%s (UTC), purgedRows=%d", n, instant2.truncatedTo(ChronoUnit.SECONDS), n2));
    }
}

