/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.plugin;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.client.core.api.util.OperationUtil;
import com.mirth.connect.model.ExtensionPermission;
import com.mirth.connect.plugins.MergePropertiesInterface;
import com.mirth.connect.plugins.ServicePlugin;
import com.mirth.connect.plugins.dynamiclookup.server.controller.LookupTableController;
import com.mirth.connect.plugins.dynamiclookup.server.exception.LookupTableException;
import com.mirth.connect.plugins.dynamiclookup.shared.interfaces.LookupTableServletInterface;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupTableServicePlugin
implements ServicePlugin,
MergePropertiesInterface {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final LookupTableController lookupTableController = LookupTableController.getInstance();

    public void init(Properties properties) {
        try {
            this.lookupTableController.init(properties);
        }
        catch (LookupTableException lookupTableException) {
            this.logger.error("Error initializing Lookup Table Management System plugin", (Throwable)lookupTableException);
            throw new RuntimeException("Failed to initialize plugin: " + lookupTableException.getMessage(), lookupTableException);
        }
    }

    public void update(Properties properties) {
        try {
            this.lookupTableController.update(properties);
        }
        catch (LookupTableException lookupTableException) {
            this.logger.error("Failed to update Lookup Table Management System plugin", (Throwable)lookupTableException);
        }
    }

    public Properties getDefaultProperties() {
        return new Properties();
    }

    public ExtensionPermission[] getExtensionPermissions() {
        ExtensionPermission extensionPermission = new ExtensionPermission("Lookup Table Management System", "Access Lookup Table", "Allows to accessing Lookup Table", OperationUtil.getOperationNamesForPermission((String)"Access Lookup Table", LookupTableServletInterface.class, (String[])new String[0]), new String[0]);
        return new ExtensionPermission[]{extensionPermission};
    }

    public String getPluginPointName() {
        return "Lookup Table Management System";
    }

    public void start() {
        try {
            this.lookupTableController.start();
        }
        catch (LookupTableException lookupTableException) {
            this.logger.error("Failed to start Lookup Table Management System plugin", (Throwable)lookupTableException);
        }
    }

    public void stop() {
        try {
            this.lookupTableController.stop();
        }
        catch (LookupTableException lookupTableException) {
            this.logger.error("Failed to stop Lookup Table Management System plugin", (Throwable)lookupTableException);
        }
    }

    public void modifyPropertiesOnRestore(Properties properties) throws ControllerException {
        this.lookupTableController.onRestoreTriggered();
    }
}

