/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.shared.interfaces;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/statistics/timeseries")
@Tag(name="Message Trends")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface MessageTrendsServletInterface
extends BaseServletInterface {
    public static final String PERMISSION_ACCESS = "Access Message Trends";

    @GET
    @Path(value="/channels/{channelId}")
    @Operation(summary="Get channel-level statistics.")
    @ApiResponse(responseCode="200", description="Channel statistics returned successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="channelStats", value="[\n  {\n    \"id\": 4711,\n    \"channelId\": \"123e4567-e89b-12d3-a456-426614174000\",\n    \"connectorId\": null,\n    \"serverId\": \"srv-01\",\n    \"ts\": \"2025-05-01T08:15:00Z\",\n    \"bucketSizeMinutes\": 5,\n    \"received\": 120,\n    \"filtered\": 5,\n    \"queued\": 3,\n    \"sent\": 112,\n    \"error\": 0\n  },\n  {\n    \"id\": 4712,\n    \"channelId\": \"123e4567-e89b-12d3-a456-426614174000\",\n    \"connectorId\": null,\n    \"serverId\": \"srv-01\",\n    \"ts\": \"2025-05-01T08:20:00Z\",\n    \"bucketSizeMinutes\": 5,\n    \"received\": 98,\n    \"filtered\": 2,\n    \"queued\": 1,\n    \"sent\": 95,\n    \"error\": 0\n  }\n]")})})
    @MirthOperation(name="getChannelStatistics", display="Get channel time series statistics", permission="Access Message Trends")
    public String getChannelStatistics(@Param(value="channelId") @Parameter(name="channelId", description="The unique ID of the channel to fetch statistics for.", example="123e4567-e89b-12d3-a456-426614174000", required=true) @PathParam(value="channelId") String var1, @Param(value="startTime") @Parameter(description="Start timestamp (epoch seconds, UTC) for the query window.", required=true) @QueryParam(value="startTime") Long var2, @Param(value="endTime") @Parameter(description="End timestamp (epoch seconds, UTC) for the query window.", required=true) @QueryParam(value="endTime") Long var3, @Param(value="interval") @Parameter(description="Bucket interval for aggregating statistics.", required=false, schema=@Schema(type="string", allowableValues={"1minute", "5minute", "15minute", "60minute", "daily"}, defaultValue="5minute")) @QueryParam(value="interval") @DefaultValue(value="5minute") String var4) throws ClientException;

    @GET
    @Path(value="/channels/{channelId}/connectors/{connectorId}")
    @Operation(summary="Get connector-level statistics.")
    @ApiResponse(responseCode="200", description="Connector statistics returned successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="channelStats", value="[\n  {\n    \"id\": 4711,\n    \"channelId\": \"123e4567-e89b-12d3-a456-426614174000\",\n    \"connectorId\": \"2\",\n    \"serverId\": \"srv-01\",\n    \"ts\": \"2025-05-01T08:15:00Z\",\n    \"bucketSizeMinutes\": 5,\n    \"received\": 120,\n    \"filtered\": 5,\n    \"queued\": 3,\n    \"sent\": 112,\n    \"error\": 0\n  },\n  {\n    \"id\": 4712,\n    \"channelId\": \"123e4567-e89b-12d3-a456-426614174000\",\n    \"connectorId\": \"2\",\n    \"serverId\": \"srv-01\",\n    \"ts\": \"2025-05-01T08:20:00Z\",\n    \"bucketSizeMinutes\": 5,\n    \"received\": 98,\n    \"filtered\": 2,\n    \"queued\": 1,\n    \"sent\": 95,\n    \"error\": 0\n  }\n]")})})
    @MirthOperation(name="getConnectorStatistics", display="Get connector time series statistics", permission="Access Message Trends")
    public String getConnectorStatistics(@Param(value="channelId") @Parameter(name="channelId", description="The unique ID of the channel to fetch statistics for.", example="123e4567-e89b-12d3-a456-426614174000", required=true) @PathParam(value="channelId") String var1, @Param(value="connectorId") @Parameter(name="connectorId", description="The unique ID of the connector to fetch statistics for.", example="2", required=true) @PathParam(value="connectorId") String var2, @Param(value="startTime") @Parameter(description="Start timestamp (epoch seconds, UTC) for the query window.", required=true) @QueryParam(value="startTime") Long var3, @Param(value="endTime") @Parameter(description="End timestamp (epoch seconds, UTC) for the query window.", required=true) @QueryParam(value="endTime") Long var4, @Param(value="interval") @Parameter(description="Bucket interval for aggregating statistics.", required=false, schema=@Schema(type="string", allowableValues={"1minute", "5minute", "15minute", "60minute", "daily"}, defaultValue="5minute")) @QueryParam(value="interval") @DefaultValue(value="5minute") String var5) throws ClientException;

    @GET
    @Path(value="/server")
    @Operation(summary="Get server-wide statistics.")
    @ApiResponse(responseCode="200", description="Server statistics returned successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="channelStats", value="[\n  {\n    \"id\": 4711,\n    \"channelId\": \"123e4567-e89b-12d3-a456-426614174000\",\n    \"connectorId\": \"2\",\n    \"serverId\": \"srv-01\",\n    \"ts\": \"2025-05-01T08:15:00Z\",\n    \"bucketSizeMinutes\": 5,\n    \"received\": 120,\n    \"filtered\": 5,\n    \"queued\": 3,\n    \"sent\": 112,\n    \"error\": 0\n  },\n  {\n    \"id\": 4712,\n    \"channelId\": \"123e4567-e89b-12d3-a456-426614174000\",\n    \"connectorId\": \"2\",\n    \"serverId\": \"srv-01\",\n    \"ts\": \"2025-05-01T08:20:00Z\",\n    \"bucketSizeMinutes\": 5,\n    \"received\": 98,\n    \"filtered\": 2,\n    \"queued\": 1,\n    \"sent\": 95,\n    \"error\": 0\n  }\n]")})})
    @MirthOperation(name="getServerStatistics", display="Get server time series statistics", permission="Access Message Trends")
    public String getServerStatistics(@Param(value="startTime") @Parameter(description="Start timestamp (epoch seconds, UTC) for the query window.", required=true) @QueryParam(value="startTime") Long var1, @Param(value="endTime") @Parameter(description="End timestamp (epoch seconds, UTC) for the query window.", required=true) @QueryParam(value="endTime") Long var2, @Param(value="interval") @Parameter(description="Bucket interval for aggregating statistics.", required=false, schema=@Schema(type="string", allowableValues={"1minute", "5minute", "15minute", "60minute", "daily"}, defaultValue="5minute")) @QueryParam(value="interval") @DefaultValue(value="5minute") String var3) throws ClientException;

    @GET
    @Path(value="/intervals")
    @Operation(summary="Get available time intervals.", description="Returns the list of supported bucket intervals for time-series aggregation.")
    @ApiResponse(responseCode="200", description="Intervals returned successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="intervals", value="[\"1minute\",\"5minute\",\"15minute\",\"60minute\",\"daily\"]")})})
    @MirthOperation(name="getAvailableIntervals", display="Get available time intervals", permission="Access Message Trends")
    public String getAvailableIntervals() throws ClientException;
}

