/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.shared.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Intervals {
    private static final List<String> CANONICAL_CODES = Collections.unmodifiableList(Arrays.asList("1minute", "5minute", "15minute", "60minute", "daily"));
    private static final Map<String, Integer> CODE_TO_MINUTES;
    private static final Map<Integer, String> MINUTES_TO_CODE;

    private Intervals() {
    }

    public static int minutesOf(String string) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("Interval is null or blank");
        }
        String string2 = Intervals.normalize(string);
        Integer n = CODE_TO_MINUTES.get(string2);
        if (n == null) {
            throw new IllegalArgumentException("Unsupported interval: " + string + ". Allowed: " + String.valueOf(CANONICAL_CODES));
        }
        return n;
    }

    public static boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        return CODE_TO_MINUTES.containsKey(Intervals.normalize(string));
    }

    public static String canonicalOfMinutes(int n) {
        String string = MINUTES_TO_CODE.get(n);
        if (string == null) {
            throw new IllegalArgumentException("Unsupported minutes: " + n + ". Allowed: " + String.valueOf(MINUTES_TO_CODE.keySet()));
        }
        return string;
    }

    public static List<String> canonicalCodes() {
        return CANONICAL_CODES;
    }

    private static String normalize(String string) {
        return string.trim().toLowerCase();
    }

    static {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("1minute", 1);
        hashMap.put("5minute", 5);
        hashMap.put("15minute", 15);
        hashMap.put("60minute", 60);
        hashMap.put("daily", 1440);
        CODE_TO_MINUTES = Collections.unmodifiableMap(hashMap);
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        hashMap2.put(1, "1minute");
        hashMap2.put(5, "5minute");
        hashMap2.put(15, "15minute");
        hashMap2.put(60, "60minute");
        hashMap2.put(1440, "daily");
        MINUTES_TO_CODE = Collections.unmodifiableMap(hashMap2);
    }
}

